/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.console;

import java.util.Map;
import java.util.TreeMap;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.console.Command;
import net.sf.apptools.console.CommandInterpreter;

public class ActionInterpreter
implements CommandInterpreter {
    protected Map<CommandKey, UserAction> commandMap = new TreeMap<CommandKey, UserAction>();

    public void putCommand(CommandKey key, UserAction a) {
        this.commandMap.put(key, a);
    }

    public void removeCommand(CommandKey key) {
        this.commandMap.remove(key);
    }

    public byte interpret(Command command, Command.Option[] options) {
        if (options.length == 2) {
            System.out.println("Parsing: " + command.getName() + ", " + options[0].getName() + ", " + options[1].getName());
            CommandKey key = new CommandKey(command, options[0], options[1]);
            UserAction a = this.commandMap.get(key);
            if (a == null) {
                return -1;
            }
            a.execute();
            return 1;
        }
        if (options.length == 1) {
            CommandKey key = new CommandKey(command, options[0]);
            UserAction a = this.commandMap.get(key);
            if (a == null) {
                return -1;
            }
            a.execute();
            return 1;
        }
        if (command.getOptions().length == 0) {
            CommandKey key = new CommandKey(command, null);
            UserAction a = this.commandMap.get(key);
            if (a == null) {
                return -1;
            }
            a.execute();
            return 1;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandKey
    implements Comparable<CommandKey> {
        Command command;
        Command.Option option1;
        Command.Option option2;

        public CommandKey(Command command, Command.Option option) {
            this(command, option, null);
        }

        public CommandKey(Command command, Command.Option suboption, Command.Option option) {
            this.command = command;
            this.option1 = suboption;
            this.option2 = option;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CommandKey) {
                CommandKey key = (CommandKey)obj;
                if (!key.command.getName().equals(this.command.getName())) {
                    return false;
                }
                if (key.option1 == null && this.option1 == null) {
                    return true;
                }
                if (key.option1 == null && this.option1 != null) {
                    return false;
                }
                if (!key.option1.getName().equals(this.option1.getName())) {
                    return false;
                }
                if (key.option2 == null && this.option2 == null) {
                    return true;
                }
                if (key.option2 == null && this.option2 != null) {
                    return false;
                }
                if (key.option2.getName().equals(this.option2)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(CommandKey key) {
            int res1 = key.command.getName().compareTo(this.command.getName());
            if (key.option1 == null) {
                if (this.option1 == null) {
                    return 0;
                }
                return -1;
            }
            if (res1 != 0) {
                return res1;
            }
            int res2 = key.option1.getName().compareTo(this.option1.getName());
            if (res2 != 0) {
                return res2;
            }
            if (key.option2 == null) {
                if (this.option2 == null) {
                    return 0;
                }
                return -1;
            }
            return key.option2.getName().compareTo(this.option2.getName());
        }
    }
}

