/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.console;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sf.apptools.console.Command;

public class CommandSet {
    Set<Command> commands = new HashSet<Command>();

    public boolean addCommand(Command c) {
        return this.commands.add(c);
    }

    public boolean removeCommand(Command c) {
        return this.commands.remove(c);
    }

    public Command[] getCommands() {
        return this.commands.toArray(new Command[this.commands.size()]);
    }

    public static Command[] getCommands(Command[] commands, final String command) {
        return CommandSet.select(commands, new CommandPredicate(){

            public boolean accept(Command c) {
                return c.getName().toUpperCase().startsWith(command.toUpperCase());
            }
        });
    }

    static Command[] select(Command[] commands, CommandPredicate p) {
        ArrayList<Command> l = new ArrayList<Command>();
        for (int i = 0; i < commands.length; ++i) {
            Command c = commands[i];
            if (!p.accept(c)) continue;
            l.add(c);
        }
        return l.toArray(new Command[l.size()]);
    }

    static interface CommandPredicate {
        public boolean accept(Command var1);
    }
}

