/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.console;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import net.sf.apptools.Platform;
import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.data.DefaultDataHolder;
import net.sf.apptools.data.ListSelectionDescriptor;
import net.sf.apptools.data.OptionDescriptor;
import net.sf.apptools.data.PlugInClassListSelectionDescriptor;
import net.sf.apptools.plugin.ParameterPlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInUtils;
import net.sf.apptools.ui.PlatformUI;
import net.sf.apptools.ui.console.Console;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleUI
implements PlatformUI {
    private static final long serialVersionUID = 1L;
    File cwd;
    Platform platform;
    Console console;
    Thread commandThread;
    Thread inputThread;
    static final byte WAIT_COMMAND = 0;
    static final byte WAIT_READ = 1;
    static final byte BUSY = 2;
    static final byte EXIT = 3;
    byte state;
    private Object monitor = new Object();
    private String input;
    private String command;

    public ConsoleUI(Platform pf, Console con) {
        this.platform = pf;
        this.setConsole(con);
        this.cwd = this.platform.getHomeDirectory();
    }

    public void setConsole(Console con) {
        if (this.console != null && con != null) {
            throw new UnsupportedOperationException("A console is already connected");
        }
        this.console = con;
        if (this.commandThread != null) {
            this.commandThread.interrupt();
        }
        if (this.inputThread != null) {
            this.inputThread.interrupt();
        }
        this.commandThread = new Thread(new CommandConsumer());
        this.inputThread = new Thread(new InputConsumer());
        this.commandThread.start();
        this.inputThread.start();
        this.state = 0;
    }

    protected String getPrompt() {
        return ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        this.state = (byte)3;
        this.println("Exiting console");
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandConsumerLoop() {
        while (this.state != 3) {
            this.print(this.getPrompt());
            boolean done = false;
            while (!done) {
                Object object = this.monitor;
                synchronized (object) {
                    try {
                        this.monitor.wait();
                        if (this.state == 0 && this.command != null) {
                            done = true;
                        }
                        if (this.state == 3) {
                            done = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.state == 3) break;
            this.state = (byte)2;
            try {
                this.platform.sendCommand(this.command, this.console.getOut());
            }
            catch (Exception ex) {
                this.platform.handleError("Exception during command execution:\n" + ex.toString(), ex);
                ex.printStackTrace(this.console.getErr());
            }
            if (this.state == 3) break;
            this.state = 0;
            this.command = null;
        }
    }

    protected void inputConsumerLoop() {
        StringBuffer line = new StringBuffer();
        while (this.state != 3) {
            line.delete(0, line.length());
            boolean nl = false;
            char[] buffer = new char[100];
            while (!nl && this.state != 3) {
                try {
                    int nlindex;
                    int read = this.console.getIn().read(buffer, 0, 60);
                    if (read <= 0) continue;
                    String str = new String(buffer, 0, read);
                    if (str.startsWith("\\u")) {
                        StringBuffer buf = new StringBuffer();
                        int lineLength = str.length();
                        for (int i = 0; i < lineLength; i += 6) {
                            char c = (char)Integer.parseInt(str.substring(i + 2, i + 6), 16);
                            buf.append(c);
                        }
                        str = buf.toString();
                    }
                    if ((nlindex = str.indexOf("\n")) >= 0) {
                        nl = true;
                        line.append(str.substring(0, nlindex));
                        continue;
                    }
                    line.append(str);
                }
                catch (IOException e) {
                    this.platform.handleError(e.toString(), e);
                }
            }
            String inline = line.toString().trim();
            if (!inline.equals(";") && inline.length() != 0 || this.state == 1) {
                this.submitInput(inline);
                continue;
            }
            this.print(this.getPrompt());
        }
        this.println("Exited console");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitInput(String line) {
        switch (this.state) {
            case 0: {
                this.command = line;
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                    break;
                }
            }
            case 1: {
                this.input = line;
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                    break;
                }
            }
            default: {
                this.println("Console is not ready, ignoring...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(String inputPrompt) {
        if (inputPrompt != null) {
            this.print(inputPrompt);
        }
        this.state = 1;
        boolean done = false;
        while (!done) {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.monitor.wait();
                    if (this.state == 1 && this.input != null) {
                        done = true;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.state = (byte)2;
        String ret = this.input;
        this.input = null;
        return ret;
    }

    @Override
    public byte sendMessage(String message, String messageTitle, byte responseType) {
        this.println("-- " + messageTitle + " --");
        this.println(message);
        switch (responseType) {
            case 0: {
                return 1;
            }
            case 1: {
                String str1 = this.read("(Y)es or (N)o? ");
                return str1.toUpperCase().equals("Y") ? (byte)1 : 0;
            }
            case 2: {
                String str2 = this.read("(Y)es, (N)o or (C)ancel? ").toUpperCase();
                return (byte)(str2.equals("Y") ? 1 : (str2.equals("N") ? 0 : -1));
            }
        }
        return -1;
    }

    @Override
    public byte sendMessage(List<?> message, String messageTitle, byte responseType) {
        this.println("-- " + messageTitle + " --");
        Iterator<?> i = message.iterator();
        while (i.hasNext()) {
            this.println("  " + i.next().toString());
        }
        switch (responseType) {
            case 0: {
                return 1;
            }
            case 1: {
                String str1 = this.read("(Y)es or (N)o? ");
                return str1.toUpperCase().equals("Y") ? (byte)1 : 0;
            }
            case 2: {
                String str2 = this.read("(Y)es, (N)o or (C)ancel? ").toUpperCase();
                return (byte)(str2.equals("Y") ? 1 : (str2.equals("N") ? 0 : -1));
            }
        }
        return -1;
    }

    @Override
    public File selectFile(FileFilter filter, File defaultFile, String caption) {
        return new File(this.read(caption + ": "));
    }

    @Override
    public File selectDir(File defaultDir, String caption) {
        return new File(this.read(caption + ": "));
    }

    @Override
    public File[] selectFiles(FileFilter filter, String caption) {
        String nameString = this.read(caption + ": ");
        String[] names = nameString.split(";");
        File[] files = new File[names.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(names[i]);
        }
        return files;
    }

    @Override
    public File selectSaveFile(FileFilter filter, File defaultFile, String caption, String autoSuffix) {
        return new File(this.read(caption + ": "));
    }

    @Override
    public boolean inputData(DataHolder dh, String title) {
        this.println("-- " + title + " --");
        DataDescriptor[] dds = dh.getDataDescriptors();
        for (int i = 0; i < dds.length; ++i) {
            String str;
            int inp;
            String str2;
            Object[] objects;
            String key = dds[i].getKey();
            Converter toStringConv = DataHolderUtils.getToStringConverter((DataDescriptor)dds[i]);
            Converter toValueConv = DataHolderUtils.getToValueConverter((DataDescriptor)dds[i]);
            if (toValueConv == null) {
                throw new RuntimeException("No Converter found for " + dds[i].getClass());
            }
            if (dds[i] instanceof ListSelectionDescriptor) {
                objects = ((ListSelectionDescriptor)dds[i]).getObjects();
                for (int j = 0; j < objects.length; ++j) {
                    this.println(j + " - " + toStringConv.convert(String.class, objects[j]));
                }
                str2 = this.read(dds[i].getName() + ": ");
                try {
                    inp = Integer.parseInt(str2);
                    dh.setData(key, toValueConv.convert(dds[i].getDataType(), objects[inp]));
                }
                catch (NumberFormatException e) {
                    dh.setData(key, (Object)str2);
                }
                continue;
            }
            if (dds[i] instanceof OptionDescriptor) {
                objects = ((OptionDescriptor)dds[i]).getOptions();
                for (int j = 0; j < objects.length; ++j) {
                    this.println(j + " - " + (String)objects[j]);
                }
                str2 = this.read(dds[i].getName() + ": ");
                try {
                    inp = Integer.parseInt(str2);
                    dh.setData(key, toStringConv.convert(String.class, objects[inp]));
                }
                catch (NumberFormatException e) {
                    dh.setData(key, (Object)str2);
                }
                continue;
            }
            if (dds[i] instanceof BooleanDescriptor) {
                str = this.read(dds[i].getName() + " (Y/N)? ");
                dh.setData(key, (Object)new Boolean(str.toUpperCase().equals("Y")));
                continue;
            }
            str = this.read(dds[i].getName() + ": ");
            dh.setData(key, (Object)str);
        }
        return true;
    }

    @Override
    public Object selectPlugIn(String message, String typeID) {
        try {
            ArrayList plugInClasses = new ArrayList(this.platform.getPlugInManager().getPlugInList(typeID));
            return this.selectPlugIn(message, plugInClasses);
        }
        catch (PlugInException e) {
            this.platform.handleError(e.toString(), e);
            return null;
        }
    }

    @Override
    public Object selectPlugIn(String message, List<Class<?>> plugInClasses) {
        PlugInClassListSelectionDescriptor dd = new PlugInClassListSelectionDescriptor(message, "", "PLUGIN", plugInClasses, true);
        DefaultDataHolder dh = new DefaultDataHolder(new DataDescriptor[]{dd});
        if (!this.inputData((DataHolder)dh, message)) {
            return null;
        }
        Class c = (Class)dh.getData("PLUGIN");
        if (c == null) {
            return null;
        }
        try {
            Object p = c.newInstance();
            if (p instanceof ParameterPlugIn) {
                ParameterPlugIn pm = (ParameterPlugIn)p;
                this.inputData((DataHolder)pm, PlugInUtils.getBriefDescription((Object)pm));
            }
            return p;
        }
        catch (Throwable t) {
            this.platform.handleError(t.toString(), t);
            return null;
        }
    }

    @Override
    public File getCurrentPath() {
        return this.cwd == null ? this.cwd : new File("").getParentFile();
    }

    public void print(String string) {
        if (this.console != null) {
            this.console.getOut().print(string);
        }
    }

    public void println(String string) {
        if (this.console != null) {
            this.console.getOut().println(string);
        }
    }

    class CommandConsumer
    implements Runnable {
        CommandConsumer() {
        }

        public void run() {
            try {
                ConsoleUI.this.commandConsumerLoop();
            }
            catch (Throwable t) {
                ConsoleUI.this.platform.handleError(t.toString(), t);
            }
        }
    }

    class InputConsumer
    implements Runnable {
        InputConsumer() {
        }

        public void run() {
            try {
                ConsoleUI.this.inputConsumerLoop();
            }
            catch (Throwable t) {
                ConsoleUI.this.platform.handleError(t.toString(), t);
            }
        }
    }
}

