/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import edu.stanford.disperse.RunTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.genefront.piecemaker.PieceMakerPlugIn;
import net.genefront.piecemaker.io.PieceMakerIOUtils;
import net.genefront.piecemaker.io.TextRestrictionReactionIO;
import net.genefront.piecemaker.io.XMLRestrictionReactionIO;
import net.genefront.piecemaker.model.CutResults;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.MutableFragmentSet;
import net.genefront.piecemaker.model.PieceMakerProject;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.model.TargetFragment;
import net.genefront.piecemaker.model.impl.PieceMakerDataFactory;
import net.genefront.piecemaker.ops.CombinationSelector;
import net.genefront.piecemaker.ops.EndoPositionCalculator;
import net.genefront.piecemaker.ops.FragmentFilter;
import net.genefront.piecemaker.ops.FragmentGenerator;
import net.genefront.piecemaker.ops.RestrictionSiteSource;
import net.genefront.piecemaker.ops.SuccessCalculator;
import net.genefront.piecemaker.ops.impl.CoverageCombinationSelector;
import net.genefront.piecemaker.ops.impl.DefaultFragmentGenerator;
import net.genefront.piecemaker.ops.impl.DefaultRestrictionSiteSource;
import net.genefront.piecemaker.tasks.DefaultReactionCombinationSelectTask;
import net.genefront.piecemaker.tasks.ThreadPoolFindEndoPositionTask;
import net.genefront.piecemaker.tasks.ThreadPoolFragmentGeneratorTask;
import net.genefront.piecemaker.tasks.ThreadPoolFragmentSelectionTask;
import net.genefront.piecemaker.utils.PropertyUtils;
import net.genefront.piecemaker.utils.SettingsUtils;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.ProgressModel;
import org.apache.commons.cli.Options;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.db.SequenceDB;

public class PieceMaker
extends RunTarget {
    private static final String REPORT_FILE_OPTION = "r";
    protected PrintWriter reportWriter;

    protected static Options createOptions() {
        Options options = new Options();
        options.addOption(targetOption);
        options.addOption(settingsOption);
        options.addOption("o", true, "Output file");
        options.addOption(REPORT_FILE_OPTION, true, "Report file");
        options.addOption(helpOption);
        return options;
    }

    public PieceMaker() {
        super("piecemaker", PieceMaker.createOptions());
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            PieceMaker runner = new PieceMaker();
            if (runner.parseCommandLine(args)) {
                void var19_25;
                File reactionFile;
                if (!runner.commandLine.hasOption("t")) {
                    PieceMaker.error("No target file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                if (!runner.commandLine.hasOption("s")) {
                    PieceMaker.error("No settings file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                File reportfile = null;
                if (runner.commandLine.hasOption(REPORT_FILE_OPTION)) {
                    reportfile = new File(runner.commandLine.getOptionValue(REPORT_FILE_OPTION));
                }
                File outputfile = null;
                if (runner.commandLine.hasOption("o")) {
                    outputfile = new File(runner.commandLine.getOptionValue("o"));
                }
                File targetfile = new File(runner.commandLine.getOptionValue("t"));
                File settingsfile = new File(runner.commandLine.getOptionValue("s"));
                if (!targetfile.canRead()) {
                    PieceMaker.error("Target file does not exist: " + targetfile.getAbsolutePath());
                    System.exit(1);
                }
                if (!settingsfile.canRead()) {
                    PieceMaker.error("Settings file does not exist: " + settingsfile.getAbsolutePath());
                    System.exit(1);
                }
                if (outputfile != null && !outputfile.getAbsoluteFile().getParentFile().canWrite()) {
                    PieceMaker.error("Output file can not be written: " + outputfile.getAbsolutePath());
                    System.exit(1);
                }
                if (reportfile != null && !reportfile.getAbsoluteFile().getParentFile().canWrite()) {
                    PieceMaker.error("Report file can not be written: " + reportfile.getAbsolutePath());
                    System.exit(1);
                }
                runner.reportWriter = reportfile == null ? null : new PrintWriter(new FileWriter(reportfile));
                runner.report("#PieceMaker report file");
                Date startTime = new Date();
                runner.report("START\t" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(startTime));
                PieceMakerProject project = new PieceMakerProject();
                System.out.println("Loading targets from " + targetfile.getName());
                project.setTargets(runner.readTargets(targetfile));
                System.out.println("Loaded " + project.getTargetCount() + " targets");
                runner.report("TARGET_COUNT\t" + project.getTargetCount());
                Properties props = new Properties();
                props.load(new FileInputStream(settingsfile));
                Map vars = SettingsUtils.getVariables((Map)props);
                String reactionFileName = props.getProperty("piecemaker.reactionFile");
                byte strandOption = Byte.parseByte(props.getProperty("piecemaker.strands", "3"));
                boolean discard = Boolean.valueOf(props.getProperty("piecemaker.discardEndFragments", "true"));
                int maxReactionCount = Integer.parseInt(props.getProperty("piecemaker.maxReactions", "3"));
                boolean stepwiseOutput = Boolean.valueOf(props.getProperty("piecemaker.stepwiseOutput", "false"));
                boolean stepwise = Boolean.valueOf(props.getProperty("piecemaker.stepwise", "true"));
                if (reactionFileName == null) {
                    PieceMaker.error("Settings file must contain a piecemaker.reactionFile entry");
                    System.exit(1);
                }
                if (!(reactionFile = new File(reactionFileName)).getAbsolutePath().equals(reactionFile.getPath())) {
                    reactionFile = new File(settingsfile.getAbsoluteFile().getParent() + "/" + reactionFile.getPath());
                }
                if (!reactionFile.canRead()) {
                    PieceMaker.error("Reaction file does not exist or cannot be read: " + reactionFile.getAbsolutePath());
                    System.exit(1);
                }
                runner.report("[SETTINGS]");
                ArrayList<String> keys = new ArrayList<String>();
                for (Object object : props.keySet()) {
                    keys.add(object.toString());
                }
                Collections.sort(keys);
                for (String string : keys) {
                    if (!string.startsWith("piecemaker.")) continue;
                    String value = (String)props.get(string);
                    String parsed = SettingsUtils.parseValueString((String)value, (Map)vars);
                    System.out.println(string + ": " + parsed);
                    runner.report(string + ": " + parsed);
                }
                ProgressListener pl = new ProgressListener(){

                    public void taskCompleted(ProgressModel source) {
                    }

                    public void taskAborted(ProgressModel source) {
                    }

                    public void statusChanged(ProgressModel source, int level, String status) {
                    }

                    public void progressChanged(ProgressModel source, int newProgress) {
                        if (newProgress % 1000 == 0) {
                            System.out.println(newProgress + "/" + source.getMaxProgress());
                        }
                    }
                };
                Object var19_23 = null;
                try {
                    FragmentFilter fragmentFilter = SettingsUtils.getPreFilter((Map)props, (Map)vars);
                }
                catch (Exception e) {
                    PieceMaker.error("Error configuring the pre filter: " + e.getMessage(), e);
                    System.exit(1);
                }
                EndoPositionCalculator flapFinder = null;
                try {
                    flapFinder = SettingsUtils.getEndoPositionCalculator((Map)props, (Map)vars);
                }
                catch (Exception e) {
                    PieceMaker.error("Error configuring the flap finder: " + e.getMessage(), e);
                    System.exit(1);
                }
                if (flapFinder == null) {
                    throw new UnsupportedOperationException("No flap finder was specified");
                }
                FragmentFilter filter = null;
                try {
                    filter = SettingsUtils.getFragmentFilter((Map)props, (Map)vars);
                }
                catch (Exception e) {
                    PieceMaker.error("Error configuring the fragment filter: " + e.getMessage(), e);
                    System.exit(1);
                }
                CombinationSelector selector = null;
                try {
                    selector = SettingsUtils.getCombinationSelector((Map)props, (Map)vars);
                }
                catch (Exception e) {
                    PieceMaker.error("Error configuring the combination selector: " + e.getMessage(), e);
                    System.exit(1);
                }
                if (selector == null) {
                    throw new UnsupportedOperationException("No combination selector was specified");
                }
                SuccessCalculator calculator = null;
                try {
                    calculator = SettingsUtils.getSuccessCalculator((Map)props, (Map)vars);
                }
                catch (Exception e) {
                    PieceMaker.error("Error configuring the success calculator: " + e.getMessage(), e);
                    System.exit(1);
                }
                if (calculator == null && selector instanceof SuccessCalculator) {
                    calculator = (SuccessCalculator)selector;
                }
                if (calculator == null) {
                    System.err.println("WARNING: No success calculator specified. This may results in too many evaluations of reaction combinations.");
                }
                project.setSuccessCalculator(calculator);
                runner.report("[RUN]");
                FileReader in = new FileReader(reactionFile);
                List reactions = reactionFile.getName().endsWith(".xml") ? new XMLRestrictionReactionIO().readReactions((Reader)in) : new TextRestrictionReactionIO().readReactions((Reader)in);
                project.setReactions(reactions);
                if (reactions.isEmpty()) {
                    PieceMaker.error("No reactions found in " + reactionFile.getAbsolutePath());
                }
                System.out.println("Loaded " + project.getReactionCount() + " reactions");
                runner.report("REACTION_COUNT\t" + project.getReactionCount());
                System.out.println("Digesting");
                DefaultFragmentGenerator fg = new DefaultFragmentGenerator(discard, (RestrictionSiteSource)new DefaultRestrictionSiteSource());
                ThreadPoolFragmentGeneratorTask cutter = new ThreadPoolFragmentGeneratorTask((Collection)project.getTargetList(), (Collection)project.getReactions(), strandOption, (FragmentGenerator)fg, (FragmentFilter)var19_25, (SequenceDB)project);
                cutter.addListener(pl);
                cutter.run();
                CutResults res = cutter.getResults();
                project.setAllResults(res);
                System.out.println("Done");
                int allFragCount = PieceMakerPlugIn.countFragments((CutResults)project.getAllFragmentSets());
                runner.report("ALL_FRAGMENTS\t" + allFragCount);
                System.out.println("Finding flap cleavage positions");
                ThreadPoolFindEndoPositionTask finder = new ThreadPoolFindEndoPositionTask(project.getAllFragmentSets(), (SequenceDB)project, flapFinder);
                finder.addListener(pl);
                finder.run();
                System.out.println("Done");
                System.out.println("Selecting fragments");
                ThreadPoolFragmentSelectionTask selectionTask = new ThreadPoolFragmentSelectionTask(project.getAllFragmentSets(), project.getAcceptedFragmentSets(), filter, (SequenceDB)project);
                selectionTask.addListener(pl);
                selectionTask.run();
                System.out.println("Done");
                int accFragCount = PieceMakerPlugIn.countFragments((CutResults)project.getAcceptedFragmentSets());
                runner.report("ACCEPTED_FRAGMENTS\t" + accFragCount);
                System.out.println("Selecting optimal combination of at most " + maxReactionCount + " reactions");
                int cuts = 1;
                if (!stepwise) {
                    cuts = maxReactionCount;
                }
                while (cuts <= maxReactionCount) {
                    project.clearCombination();
                    DefaultReactionCombinationSelectTask selectorTask = new DefaultReactionCombinationSelectTask(project.getAcceptedFragmentSets(), cuts, (SequenceDB)project, selector, project.getSuccessCalculator());
                    selectorTask.setStepWise(false);
                    selectorTask.addListener(pl);
                    selectorTask.run();
                    int[] best = selectorTask.getBest();
                    if (best != null) {
                        for (int i = 0; i < best.length; ++i) {
                            project.addToCombination(best[i]);
                            System.out.println("  Selected " + project.getReaction(best[i]).getName());
                        }
                    }
                    System.out.println("Number of selected reactions: " + (best == null ? "None" : String.valueOf(best.length)));
                    int rCount = project.getCombinationReactionCount();
                    runner.report("REACTION_COUNT\t" + rCount);
                    for (int i = 0; i < rCount; ++i) {
                        runner.report("REACTION\t" + project.getCombinationReaction(i).getName());
                    }
                    runner.report("SUCCESSES\t" + project.getSuccesses());
                    int selFragCount = PieceMakerPlugIn.countFragments((FragmentSet[][])project.getCombinationArray());
                    runner.report("COMBINATION_FRAGMENTS\t" + selFragCount);
                    System.out.println("Outputting resulting fragments");
                    MutableFragmentSet[][] sets = project.getCombinationArray();
                    Vector<TargetFragment> fragments = new Vector<TargetFragment>();
                    for (int t = 0; t < sets.length; ++t) {
                        for (int enzyme = 0; enzyme < sets[t].length; ++enzyme) {
                            MutableFragmentSet set = sets[t][enzyme];
                            for (TargetFragment tf : set) {
                                fragments.add(tf);
                            }
                        }
                    }
                    PrintWriter outputWriter = outputfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputfile));
                    PieceMakerIOUtils.putFragmentsWithSequence((Writer)outputWriter, fragments, (List)project.getTargetList(), (String)("Design results " + new Date()));
                    outputWriter.close();
                    if (stepwiseOutput && outputfile != null) {
                        FileWriter stepwiseoutputwriter = new FileWriter(new File(outputfile.getAbsolutePath() + "_" + cuts));
                        PieceMakerIOUtils.putFragmentsWithSequence((Writer)stepwiseoutputwriter, fragments, (List)project.getTargetList(), (String)("Design results " + new Date()));
                        ((Writer)stepwiseoutputwriter).close();
                    }
                    System.out.println("Done");
                    runner.report("TIME\t" + (System.currentTimeMillis() - startTime.getTime()));
                    int succCount = 0;
                    int allsize = 0;
                    int allcovered = 0;
                    SuccessCalculator sc = project.getSuccessCalculator();
                    for (int i = 0; i < project.getTargetCount(); ++i) {
                        SelectorTarget t = project.getTarget(i);
                        MutableFragmentSet[] setArray = project.getCombinationArray()[i];
                        FragmentSet fs = PieceMakerDataFactory.createPooledMutableFragmentSet((FragmentSet[])setArray, (SelectorTarget)t);
                        boolean success = false;
                        if (sc != null && sc.isSuccess(t, (FragmentSet[])setArray)) {
                            success = true;
                            ++succCount;
                        }
                        int targetSize = PropertyUtils.getTargetRegion((PropertyHolder)t).length();
                        int covered = ((CoverageCombinationSelector)project.getSuccessCalculator()).getCoveredBaseCount(t, (Collection)fs.getAllFragments());
                        allsize += targetSize;
                        allcovered += covered;
                        StringBuffer targetline = new StringBuffer();
                        targetline.append("TARGET\t" + t.getID() + "\t");
                        targetline.append(sc == null ? "UNDEFINED" : (success ? "SUCCESS" : "FAILURE"));
                        targetline.append("\t" + targetSize);
                        targetline.append("\t" + fs.size());
                        targetline.append("\t" + covered);
                        runner.report(targetline.toString());
                    }
                    StringBuffer targetline = new StringBuffer();
                    targetline.append("ALL\t");
                    targetline.append(succCount + "/" + project.getTargetCount() + "\t");
                    targetline.append("\t" + allsize);
                    targetline.append("\t" + selFragCount);
                    targetline.append("\t" + allcovered);
                    runner.report(targetline.toString());
                    NumberFormat nf = NumberFormat.getPercentInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    System.out.println("Generated " + selFragCount + " fragments");
                    System.out.println("Covering " + succCount + " of " + project.getTargetCount() + " targets completely (" + nf.format((double)succCount / (double)project.getTargetCount()) + ")");
                    System.out.println("Covering " + allcovered + " of " + allsize + " bases (" + nf.format((double)allcovered / (double)allsize) + ")");
                    if (project.getSuccesses() == project.getTargetCount()) break;
                    ++cuts;
                }
                if (runner.reportWriter != null) {
                    runner.reportWriter.flush();
                }
            }
            if (runner.reportWriter != null) {
                runner.reportWriter.close();
            }
        }
        catch (Exception ex) {
            PieceMaker.error(ex.getMessage(), ex);
            System.exit(1);
        }
    }

    protected void report(String line) {
        if (this.reportWriter != null) {
            this.reportWriter.println(line);
        }
    }
}

