/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.calculators;

import java.util.Stack;
import org.moltools.apps.probemaker.calculators.PadlockLigationCalculator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class GapLigationCalculator
extends PadlockLigationCalculator {
    public int[] isLigationTemplate(ChangeableNucleotideSequence s, Probe p, boolean circular, boolean target) {
        int min3Length;
        int min5Length;
        if (target) {
            min5Length = Integer.parseInt((String)this.parameters.get("TARGET_TEMPLATING_FIVE_MIN_LENGTH"));
            min3Length = Integer.parseInt((String)this.parameters.get("TARGET_TEMPLATING_THREE_MIN_LENGTH"));
        } else {
            min5Length = Integer.parseInt((String)this.parameters.get("PROBE_TEMPLATING_FIVE_MIN_LENGTH"));
            min3Length = Integer.parseInt((String)this.parameters.get("PROBE_TEMPLATING_THREE_MIN_LENGTH"));
        }
        if (min5Length < 1) {
            return null;
        }
        if (min3Length < 1) {
            return null;
        }
        if (min5Length + min3Length > p.length()) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Templating not properly calculated because minimum lengths are too great", PROBE_IS_SELF_TEMPLATE, 0));
            while (min5Length + min3Length > p.length()) {
                if (min5Length > min3Length) {
                    min5Length = p.length() - min3Length > 0 ? p.length() - min3Length : 1;
                    continue;
                }
                min3Length = p.length() - min5Length > 0 ? p.length() - min5Length : 1;
            }
        }
        String seqstr = s.seqString();
        if (circular) {
            seqstr = seqstr + seqstr.substring(0, min3Length + min5Length - 1);
        }
        seqstr = seqstr.replace('U', 'T');
        seqstr = seqstr.replace('u', 't');
        Stack<Integer> results = new Stack<Integer>();
        String threeseq = p.subsequence(p.length() - min3Length, p.length());
        String fiveseq = p.subsequence(1, min5Length);
        String fseq = NucleotideSequenceHandler.getRevComp((String)fiveseq, (byte)p.getType(), (byte)s.getType());
        String tseqfull = NucleotideSequenceHandler.getRevComp((String)threeseq.substring(1), (byte)p.getType(), (byte)s.getType());
        String tseqminusone = NucleotideSequenceHandler.getRevComp((String)threeseq, (byte)p.getType(), (byte)s.getType());
        int index = -1;
        while ((index = seqstr.indexOf(fseq, index + 1)) > -1) {
            if (seqstr.indexOf(tseqfull, index + fseq.length()) == index + fseq.length()) {
                results.push(new Integer(index + min5Length));
            }
            if (seqstr.indexOf(tseqminusone, index + fseq.length() + 1) != index + fseq.length() + 1) continue;
            results.push(new Integer(index + min5Length));
        }
        if (results.isEmpty()) {
            return null;
        }
        int[] res = new int[results.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)results.pop() + 1;
        }
        return res;
    }
}

