/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.data.StringDataDescriptor;
import org.moltools.apps.probemaker.calculators.SWTagSimilarityCalculator;
import org.moltools.apps.probemaker.calculators.TagSimilarityCalculator;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Candidate;
import org.moltools.design.data.Group;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDB;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTagOccurrenceModule
extends AbstractProbeModule {
    public static final MessageType TAG_ELSEWHERE_INTERNAL = new MessageType("TAG_ELSEWHERE_INTERNAL", "Tag sequence within probe");
    public static final MessageType TAG_COMPLEMENT_INTERNAL = new MessageType("TAG_COMPLEMENT_INTERNAL", "Tag complement within probe");
    public static final MessageType TAG_ELSEWHERE_EXTERNAL = new MessageType("TAG_ELSEWHERE_EXTERNAL", "Tag sequence in other probe");
    public static final MessageType TAG_COMPLEMENT_EXTERNAL = new MessageType("TAG_COMPLEMENT_EXTERNAL", "Tag complement in other probe");
    public static final MessageType OTHER_TAG_PRESENT = new MessageType("OTHER_TAG_PRESENT", "Sequence of other tag found in this probe");
    public static final MessageType OTHER_TAG_COMPLEMENT_PRESENT = new MessageType("OTHER_TAG_COMPLEMENT_PRESENT", "Complement sequence of other tag found in this probe");
    public static final String KEY_PERCENT_SIMILARITY = "PERCENT_SIMILARITY";
    public static final String KEY_SEQUENCE_POSITIONS = "SEQUENCE_POSITIONS";
    public static final String KEY_COMPLEMENT_POSITIONS = "COMPLEMENT_POSITIONS";
    public static final byte NO_SIMILARITY = 0;
    public static final byte THIS_IN_OTHER = 1;
    public static final byte OTHER_IN_THIS = 2;
    public static final byte BOTH = 3;
    protected TagSimilarityCalculator tsc = new SWTagSimilarityCalculator();
    protected int[] seqPositions;
    protected int[] compPositions;

    public static String getBriefDescription() {
        return "Tag sequences outside of intended positions";
    }

    public static String getLongDescription() {
        return "<html>Determines if the sequence of any tag occurs outside the intended position. Also check if the complement of any tag occurs outside the intended position. If the max score parameter is set to 100, a full match string search is performed, if the parameter is set to less than 100, a Smith-Waterman alignment is performed, and a match is called if the alignment score exceeds the limit defined as the alignment score for a full match * the per cent limit. If a match is scored outside of the intended position, an error message is given. <br>If the tag sequences or their complements are specifically allowed to occur  by the Tag settings, the corresponding tests are not performed.</html>";
    }

    public DefaultTagOccurrenceModule() {
        super(new TestDescriptor[]{new TestDescriptor("Tag sequence within probe"), new TestDescriptor("Tag complement within probe"), new TestDescriptor("Tag sequence in other probe"), new TestDescriptor("Tag complement in other probe")}, new DataDescriptor[1]);
        this.dataDescriptors = new DataDescriptor[]{new IntegerDescriptor("Per cent of max score required for match", "The value in percent of the maximum alignment score required to yield a match. If 100 % regular string search used.", KEY_PERCENT_SIMILARITY, 1, 100), new StringDataDescriptor("Positions to check sequence", "A comma-separated list of tag positions for which to check if the sequence occurs elsewhere", KEY_SEQUENCE_POSITIONS, false), new StringDataDescriptor("Positions to check complement", "A comma-separated list of tag positions for which to check if the complement occurs elsewhere", KEY_COMPLEMENT_POSITIONS, false)};
        this.setData(KEY_PERCENT_SIMILARITY, new Integer(((String)this.tsc.getParameters().get(KEY_PERCENT_SIMILARITY)).toString()));
        this.setData(KEY_SEQUENCE_POSITIONS, "");
        this.setData(KEY_COMPLEMENT_POSITIONS, "");
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void doIntraAnalysis(Probe p, TagAllocator pd, SequenceDB<? extends Probe> probes) {
        int tagcount = p.getTags().size();
        for (int i = 0; i < tagcount; ++i) {
            int pos;
            int occ;
            Integer[] occurrences;
            if (i >= pd.getTagLibraries().length) {
                throw new IllegalArgumentException("No such tag library: " + i);
            }
            boolean allowsSeq = true;
            for (int pos2 = 0; pos2 < this.seqPositions.length; ++pos2) {
                if (this.seqPositions[pos2] != i + 1) continue;
                allowsSeq = false;
            }
            boolean allowsComp = true;
            for (int pos3 = 0; pos3 < this.compPositions.length; ++pos3) {
                if (this.compPositions[pos3] != i + 1) continue;
                allowsComp = false;
            }
            NucleotideSequence tag = p.getTagAt(i);
            int block = p.getBlockNoOfTag(i);
            int blockStart = p.getStartOfSequence(block);
            if (tag.length() <= 0) continue;
            if (!allowsSeq) {
                occurrences = this.tsc.getOccurrences(tag.seqString(), p.seqString(), tag.getType(), p.getType(), true);
                for (occ = 0; occ < occurrences.length; ++occ) {
                    pos = occurrences[occ] + 1;
                    if (pos == blockStart) continue;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message(tag.getID() + " found elsewhere in probe (position " + pos + ")", TAG_ELSEWHERE_INTERNAL, 2));
                }
            }
            if (allowsComp) continue;
            occurrences = this.tsc.getOccurrences(NucleotideSequenceHandler.getRevComp((NucleotideSequence)tag, (byte)p.getType()), p.seqString(), tag.getType(), p.getType(), true);
            for (occ = 0; occ < occurrences.length; ++occ) {
                pos = occurrences[occ] + 1;
                if (pos == blockStart) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Complement of " + tag.getID() + " found (position " + pos + ")", TAG_COMPLEMENT_INTERNAL, 2));
            }
        }
    }

    public void doInterAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        TagLibrary[] taglibraries = pd.getTagLibraries();
        int tagcount = p.getTags().size();
        for (int tagpos = 0; tagpos < tagcount; ++tagpos) {
            boolean allowsSeq = true;
            for (int pos = 0; pos < this.seqPositions.length; ++pos) {
                if (this.seqPositions[pos] != tagpos + 1) continue;
                allowsSeq = false;
            }
            boolean allowsComp = true;
            for (int pos = 0; pos < this.compPositions.length; ++pos) {
                if (this.compPositions[pos] != tagpos + 1) continue;
                allowsComp = false;
            }
            if (allowsSeq && allowsComp) continue;
            for (Probe other : probes) {
                byte result;
                if (other == p || !other.tagsAllocated() || (result = this.compareTag(p, other, tagpos, allowsSeq, allowsComp, taglibraries, this.tsc)) != 1 && result != 3) continue;
                pd.setCurrentTagBad(tagpos);
            }
        }
    }

    protected byte compareTag(Probe thisProbe, Probe otherProbe, int tagpos, boolean allowsSequence, boolean allowsComplement, TagLibrary[] taglibraries, TagSimilarityCalculator tsc1) {
        int occ;
        boolean add;
        boolean checkComplement;
        boolean checkSequence;
        Group otherGroup;
        TagLibrary tl = taglibraries[tagpos];
        byte mode = tl.getMode();
        Group thisGroup = DesignUtils.getGroupWithType((PropertyHolder)thisProbe, (String)"probeGroup");
        boolean sameGroup = thisGroup == (otherGroup = DesignUtils.getGroupWithType((PropertyHolder)otherProbe, (String)"probeGroup"));
        boolean bl = checkSequence = !allowsSequence && this.tests[2].perform();
        if (this.tests[0].perform() && mode == 0) {
            checkSequence = false;
        }
        if (!sameGroup && mode == 4) {
            checkSequence = false;
        }
        boolean bl2 = checkComplement = !allowsComplement && this.tests[3].perform();
        if (this.tests[1].perform() && mode == 0) {
            checkComplement = false;
        }
        if (!sameGroup && mode == 4) {
            checkComplement = false;
        }
        String thisSeq = thisProbe.seqString();
        String otherSeq = otherProbe.seqString();
        Integer[] occurrences = new Integer[]{};
        boolean foundTIO = false;
        boolean foundOIT = false;
        NucleotideSequence tag = thisProbe.getTagAt(tagpos);
        String tagseq = tag.seqString();
        if (tagseq.length() > 0) {
            if (checkSequence) {
                occurrences = tsc1.getOccurrences(tagseq, otherSeq, tag.getType(), otherProbe.getType(), true);
                int blockStart = otherProbe.getStartOfSequence(thisProbe.getBlockNoOfTag(tagpos));
                for (int occ2 = 0; occ2 < occurrences.length; ++occ2) {
                    int pos = occurrences[occ2] + 1;
                    switch (mode) {
                        case 0: 
                        case 2: {
                            add = pos != blockStart;
                            break;
                        }
                        case 4: {
                            add = pos != blockStart || sameGroup;
                            break;
                        }
                        case 3: {
                            add = pos != blockStart || !sameGroup;
                            break;
                        }
                        default: {
                            add = true;
                        }
                    }
                    if (!add) continue;
                    foundTIO = true;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)thisProbe, (Message)new Message(tag.getID() + " found in " + otherProbe.getName(), TAG_ELSEWHERE_EXTERNAL, 2));
                }
            }
            if (checkComplement) {
                occurrences = tsc1.getOccurrences(NucleotideSequenceHandler.getRevComp((NucleotideSequence)tag, (byte)otherProbe.getType()), otherSeq, tag.getType(), otherProbe.getType(), true);
                for (occ = 0; occ < occurrences.length; ++occ) {
                    foundTIO = true;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)thisProbe, (Message)new Message("Complement of " + tag.getID() + " found in " + otherProbe.getName(), TAG_COMPLEMENT_EXTERNAL, 2));
                }
            }
        }
        if (otherProbe.getTags().size() > tagpos && (tagseq = (tag = otherProbe.getTagAt(tagpos)).seqString()).length() > 0) {
            occurrences = checkSequence ? tsc1.getOccurrences(tagseq, thisSeq, tag.getType(), otherProbe.getType(), true) : new Integer[]{};
            for (occ = 0; occ < occurrences.length; ++occ) {
                int pos = occurrences[occ] + 1;
                int blockStart = thisProbe.getStartOfSequence(otherProbe.getBlockNoOfTag(tagpos));
                switch (mode) {
                    case 0: 
                    case 2: {
                        add = pos != blockStart;
                        break;
                    }
                    case 4: {
                        add = pos != blockStart || sameGroup;
                        break;
                    }
                    case 3: {
                        add = pos != blockStart || !sameGroup;
                        break;
                    }
                    default: {
                        add = true;
                    }
                }
                if (!add) continue;
                foundOIT = true;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)thisProbe, (Message)new Message(tag.getID() + " from " + otherProbe.getName() + " found (position " + pos + ")", OTHER_TAG_PRESENT, 2));
            }
            if (checkComplement) {
                if (otherProbe.getTags().size() > tagpos) {
                    tag = otherProbe.getTagAt(tagpos);
                    tagseq = tag.seqString();
                    occurrences = tsc1.getOccurrences(NucleotideSequenceHandler.getRevComp((NucleotideSequence)tag, (byte)thisProbe.getType()), thisSeq, tag.getType(), otherProbe.getType(), true);
                } else {
                    occurrences = new Integer[]{};
                }
                for (occ = 0; occ < occurrences.length; ++occ) {
                    foundOIT = true;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)thisProbe, (Message)new Message("Complement of " + tag.getID() + " from " + otherProbe.getName() + " found (position " + occurrences[occ] + ")", OTHER_TAG_COMPLEMENT_PRESENT, 2));
                }
            }
        }
        byte result = 0;
        if (foundTIO) {
            result = (byte)(result + 1);
        }
        if (foundOIT) {
            result = (byte)(result + 2);
        }
        return result;
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        for (Probe other : probes) {
            if (other != p && other.tagsAllocated()) {
                for (int tagpos = 0; tagpos < other.getTags().size(); ++tagpos) {
                    boolean allowsSeq = true;
                    for (int pos = 0; pos < this.seqPositions.length; ++pos) {
                        if (this.seqPositions[pos] != tagpos + 1) continue;
                        allowsSeq = false;
                    }
                    boolean allowsComp = true;
                    for (int pos = 0; pos < this.compPositions.length; ++pos) {
                        if (this.compPositions[pos] != tagpos + 1) continue;
                        allowsComp = false;
                    }
                    this.compareTag(other, p, tagpos, allowsSeq, allowsComp, pd.getTagLibraries(), this.tsc);
                }
            }
            Analyzer.calculateAndSetQuality((Candidate)other);
        }
    }

    public void reset() {
        int i;
        this.tsc.addParameters(DataHolderUtils.getProperties((DataHolder)this));
        String[] seqPosStrings = ((String)this.getData(KEY_SEQUENCE_POSITIONS)).split(",");
        String[] compPosStrings = ((String)this.getData(KEY_COMPLEMENT_POSITIONS)).split(",");
        this.seqPositions = new int[seqPosStrings.length];
        for (i = 0; i < seqPosStrings.length; ++i) {
            this.seqPositions[i] = seqPosStrings[i].trim().length() > 0 ? Integer.parseInt(seqPosStrings[i].trim()) : -1;
        }
        this.compPositions = new int[compPosStrings.length];
        for (i = 0; i < compPosStrings.length; ++i) {
            this.compPositions[i] = compPosStrings[i].trim().length() > 0 ? Integer.parseInt(compPosStrings[i].trim()) : -1;
        }
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        this.doIntraAnalysis(p, pd, (SequenceDB<? extends Probe>)probes);
        this.doInterAnalysis(p, pd, probes);
    }
}

