/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.ta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.apptools.utils.HTMLLogWriter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.SpacerLibrary;
import org.moltools.apps.probemaker.design.TagAllocationTable;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.design.TagSelector;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.SeverityFilter;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreedyTagAllocator
extends AbstractParameterHolder
implements ProbeMakerConstants,
TagAllocator {
    protected static Log log = LogFactory.getLog(GreedyTagAllocator.class);
    public static final Map<String, String> defaultParameters = new HashMap<String, String>();
    protected TagLibrary[] taglibraries = new TagLibrary[0];
    protected String status;
    protected boolean canceled = false;
    protected DefiniteSequenceDB<Probe> probes = new ListSequenceDB();
    protected HTMLLogWriter htmllog;
    protected Analyzer analyzer;
    protected int currentTagCombination;
    protected Collection<Integer>[] badTagsAll;
    protected Collection<Integer>[] badTagsCurrent;
    protected boolean testAfterEachModule;
    protected int prefLength;
    protected int spacerPosition;
    protected String spacerString;
    protected boolean constantSpacer;
    protected TagSelector tagSelector;
    public int candidatesGenerated = 0;
    public int predictions = 0;
    protected ListSequenceDB<Probe> tempCandidates;
    private TagAllocationTable tagAllocationTable;
    protected long debugtime = 0L;

    public Map<String, String> getDefaultParameters() {
        return defaultParameters;
    }

    public GreedyTagAllocator() {
        this.setStatus("Ready");
        this.badTagsCurrent = new List[0];
        this.badTagsAll = new List[0];
    }

    public void setup(Project p, Analyzer analyzer, HTMLLogWriter htmllog) {
        this.analyzer = analyzer;
        this.htmllog = htmllog;
        this.probes = p.getProbes();
        if (this.probes == null) {
            this.probes = new ListSequenceDB();
        }
        this.addParameters(p.getSettings().getDesignParameters());
        this.tagAllocationTable = p.getTagAllocationTable();
        this.setTagUsage(p.getTagLibraries());
        this.badTagsAll = analyzer.screenTags(this.taglibraries, this.probes);
    }

    protected void setTagUsage(TagLibrary[] libs) {
        boolean useSpacer = new Boolean((String)this.parameters.get("USE_SPACER"));
        String spacerSequence = "";
        if (useSpacer) {
            int spacerPos = Integer.parseInt((String)this.parameters.get("SPACER_POSITION"));
            this.prefLength = Integer.parseInt((String)this.parameters.get("PREFERRED_LENGTH"));
            this.spacerString = (String)this.parameters.get("SPACER_SEQUENCE");
            if (this.spacerString == null) {
                this.spacerString = "";
            }
            if (spacerPos < 0 || spacerPos > libs.length) {
                throw new IllegalArgumentException("Invalid spacer position");
            }
            this.spacerPosition = spacerPos;
            SpacerLibrary spacerLib = new SpacerLibrary(0, 0);
            spacerSequence = "";
            for (int i = 0; i < this.spacerString.length(); ++i) {
                Nucleotide nt = NucleotideSequenceHandler.getNucleotide((char)this.spacerString.charAt(i), (byte)0);
                if (nt == null) {
                    throw new UnsupportedOperationException("Invalid spacer sequence");
                }
                spacerSequence = spacerSequence + nt.getChar();
            }
            this.taglibraries = new TagLibrary[libs.length + 1];
            boolean inserted = false;
            for (int i = 0; i < this.taglibraries.length; ++i) {
                if (i == this.spacerPosition) {
                    this.taglibraries[i] = spacerLib;
                    inserted = true;
                    continue;
                }
                this.taglibraries[i] = inserted ? libs[i - 1] : libs[i];
            }
        } else {
            this.spacerPosition = -1;
            this.taglibraries = libs;
        }
        this.badTagsCurrent = new List[this.taglibraries.length];
        this.badTagsAll = new List[this.taglibraries.length];
        for (int i = 0; i < this.badTagsCurrent.length; ++i) {
            this.badTagsCurrent[i] = new ArrayList<Integer>();
            this.badTagsAll[i] = new ArrayList<Integer>();
        }
        this.tagSelector = new TagSelector(this.tagAllocationTable, this.taglibraries);
    }

    public void abort() {
        this.canceled = true;
    }

    public TagLibrary[] getTagLibraries() {
        return this.taglibraries;
    }

    public boolean allocateTagsToGroup(ProbeGroup pg) {
        int i;
        this.htmllog.printLineAndHeader("Allocating tags to next group");
        log.info((Object)"Allocating tags to next group");
        if (this.tagSelector == null) {
            throw new UnsupportedOperationException("No TagSelector has been set");
        }
        Probe[] groupprobes = new Probe[pg.getMembers().size()];
        Iterator pi = pg.getMembers().iterator();
        for (i = 0; i < groupprobes.length; ++i) {
            groupprobes[i] = (Probe)pi.next();
        }
        for (i = 0; i < groupprobes.length; ++i) {
            this.badTagsCurrent = new List[this.taglibraries.length];
            for (int b = 0; b < this.badTagsCurrent.length; ++b) {
                this.badTagsCurrent[b] = new ArrayList<Integer>(this.badTagsAll[b]);
            }
            if (this.canceled) {
                this.htmllog.printError("Aborted - exiting");
                return false;
            }
            int[] comb = new int[this.taglibraries.length];
            if (comb.length > 0) {
                comb[comb.length - 1] = -1;
            }
            this.tagSelector.setTagIndices(comb);
            this.currentTagCombination = 0;
            if (!this.allocateTags(groupprobes[i])) continue;
            this.reserve(groupprobes[i]);
        }
        return true;
    }

    protected boolean allocateTags(Probe p) {
        this.tagSelector.setBadTags((Collection[])this.badTagsCurrent);
        if (this.canceled) {
            this.htmllog.printError("Aborted - exiting");
            return false;
        }
        if (p == null) {
            throw new UnsupportedOperationException("Cannot allocate tags to null probe.");
        }
        log.info((Object)("Allocating tags to " + p.getName()));
        this.htmllog.printHeader("Allocating tags to " + p.getName());
        this.tempCandidates = new ListSequenceDB();
        byte accept = this.analyzer.analyzeTSSPair(p, (TagAllocator)this, this.probes);
        if (accept == 2) {
            log.debug((Object)"TSS pair accepted");
            boolean gotprobe = false;
            boolean done = false;
            boolean madeNew = false;
            while (!done) {
                if (this.canceled) {
                    this.htmllog.printError("Aborted - exiting");
                    return false;
                }
                madeNew = this.taglibraries.length == 0 ? !madeNew : this.nextCandidate(p);
                if (madeNew) {
                    log.debug((Object)"Made new");
                    if (this.taglibraries.length == 0) {
                        this.setStatus("Trying candidate " + this.currentTagCombination);
                    }
                    StringBuffer s = new StringBuffer("Trying candidate: ");
                    for (int i = 1; i <= p.getSequenceCount(); ++i) {
                        if (i > 1) {
                            s.append(" - ");
                        }
                        s.append(((NucleotideSequence)p.getSequence(i)).getID());
                    }
                    this.htmllog.printLine(s.toString());
                    log.debug((Object)("Analyzing candidate " + this.currentTagCombination));
                    log.debug((Object)(p.getID() + " " + p.seqString()));
                    byte acceptance = this.analyzer.analyzeCandidateStage1(p, (TagAllocator)this, this.probes);
                    log.debug((Object)("Analysis complete: " + acceptance));
                    Collection warnings = CollectionUtils.select((Collection)ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p), (Predicate)new SeverityFilter(1));
                    if (!warnings.isEmpty()) {
                        this.htmllog.printList(warnings);
                        Iterator i = warnings.iterator();
                        while (i.hasNext()) {
                            log.debug((Object)((Message)i.next()).getMessage());
                        }
                    }
                    block0 : switch (acceptance) {
                        case -2: {
                            this.htmllog.printError("Aborted - exiting");
                            this.canceled = true;
                            this.badProbe(p);
                            return false;
                        }
                        case -1: {
                            this.htmllog.printLine("Probe skipped by acceptor");
                            done = true;
                            this.badProbe(p);
                            break;
                        }
                        case 0: {
                            this.htmllog.printLine("Rejected");
                            break;
                        }
                        case 1: {
                            this.htmllog.printLine("Temporarily accepted");
                            this.tempCandidates.addSequence((Sequence)p.getCopy());
                            throw new UnsupportedOperationException("Acceptor should not return temporary for stage 1");
                        }
                        case 2: {
                            this.htmllog.printLine("Candidate accepted, performing stage 2 analysis");
                            this.setStatus("Performing stage 2 analysis");
                            byte accept2 = this.analyzer.analyzeCandidateStage2(p, (TagAllocator)this, this.probes);
                            Collection warns = CollectionUtils.select((Collection)ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p), (Predicate)new SeverityFilter(1));
                            if (!warns.isEmpty()) {
                                this.htmllog.printList(warns);
                            }
                            switch (accept2) {
                                case -2: {
                                    this.htmllog.printError("Aborted - exiting");
                                    this.canceled = true;
                                    this.badProbe(p);
                                    return false;
                                }
                                case -1: {
                                    this.htmllog.printLine("Probe skipped by acceptor");
                                    done = true;
                                    this.badProbe(p);
                                    break block0;
                                }
                                case 0: {
                                    this.htmllog.printLine("Rejected");
                                    break block0;
                                }
                                case 1: {
                                    this.htmllog.printLine("Temporarily accepted");
                                    this.tempCandidates.addSequence((Sequence)p.getCopy());
                                    break block0;
                                }
                                case 2: {
                                    this.htmllog.printLine("Accepted");
                                    this.tempCandidates.addSequence((Sequence)p.getCopy());
                                    gotprobe = true;
                                }
                            }
                        }
                    }
                    if (!gotprobe) continue;
                    done = true;
                    continue;
                }
                this.htmllog.printLine("Failed to generate new candidate");
                this.badProbe(p);
                done = true;
            }
            if (this.tempCandidates.isEmpty()) {
                this.htmllog.printLine("No probes to select from");
                return false;
            }
            this.setStatus("Selecting probe");
            this.htmllog.printLine("Selecting probe");
            Probe selected = this.analyzer.selectProbe(this.tempCandidates);
            if (selected != null) {
                ProbeGroup pg = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)p, (String)"probeGroup");
                if (pg != null) {
                    pg.removeMember((Object)p);
                }
                p.copy(selected);
                if (pg != null) {
                    pg.addMember((Object)p);
                }
                String s = "Selected: ";
                for (int i = 1; i <= p.getSequenceCount(); ++i) {
                    if (i > 1) {
                        s = s + " - ";
                    }
                    s = s + ((NucleotideSequence)p.getSequence(i)).getID();
                }
                this.htmllog.printLine(s);
            }
        } else {
            log.info((Object)"TSS pair not accepted");
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Skipped probe because of problems with TSS pair", TAG_ALLOCATION, 3));
            this.htmllog.printLine("TSS pair not accepted - Skipping probe");
            this.htmllog.printList(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p));
            ProbeMakerPropertyUtils.setRank((PropertyAcceptor)p, (short)1);
            return false;
        }
        return true;
    }

    protected void badProbe(Probe p) {
        this.clear(p);
        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Tested all variations, none accepted", TAG_ALLOCATION, 3));
        ProbeMakerPropertyUtils.setRank((PropertyAcceptor)p, (short)1);
    }

    protected boolean addTags(Probe p) {
        p.getTags().clear();
        NucleotideSequence[] tags = this.tagSelector.getNextValidCombination((PropertyHolder)p);
        if (tags == null) {
            this.badProbe(p);
            return false;
        }
        for (int pos = 0; pos < tags.length; ++pos) {
            p.addTagAt(tags[pos], pos);
        }
        return true;
    }

    protected boolean nextCandidate(Probe p) {
        NucleotideSequence spacer;
        if (this.canceled) {
            this.htmllog.printError("Aborted - exiting");
            return false;
        }
        this.setStatus("Generating new candidate");
        ++this.candidatesGenerated;
        ++this.currentTagCombination;
        if (this.spacerPosition > -1 && this.spacerString.length() == 0 && p.getTags().size() > 0 && this.tagSelector.isValidCombination(this.tagSelector.getTagIndices(), (PropertyHolder)p) && (spacer = ((SpacerLibrary)this.taglibraries[this.spacerPosition]).getNext()) != null) {
            p.removeTagAt(this.spacerPosition);
            p.addTagAt(spacer, this.spacerPosition);
            return true;
        }
        boolean added = this.addTags(p);
        if (added) {
            this.adjustLength(p);
            return true;
        }
        --this.candidatesGenerated;
        return false;
    }

    protected void setStatus(String s) {
        this.status = s;
    }

    protected void adjustLength(Probe p) {
        if (this.spacerPosition >= 0 && this.prefLength > 0) {
            if (p.getTags().size() > this.spacerPosition) {
                NucleotideSequence spacer;
                p.removeTagAt(this.spacerPosition);
                int spacerLength = Math.max(0, this.prefLength - p.length());
                if (this.spacerString.length() > 0) {
                    String temp = "";
                    for (int i = 0; i < spacerLength; ++i) {
                        temp = temp + this.spacerString.charAt(i % this.spacerString.length());
                    }
                    spacer = new SimpleNucleotideSequence("Spacer " + temp, temp, p.getType());
                } else {
                    this.taglibraries[this.spacerPosition] = new SpacerLibrary(spacerLength, p.getType());
                    spacer = ((SpacerLibrary)this.taglibraries[this.spacerPosition]).getNext();
                }
                p.addTagAt(spacer, this.spacerPosition);
            } else {
                throw new UnsupportedOperationException("Invalid spacer position");
            }
        }
    }

    protected void reserve(Probe p) {
        p.setTagsAllocated(true);
        for (int tagpos = 0; tagpos < p.getTags().size(); ++tagpos) {
            NucleotideSequence tag = p.getTagAt(tagpos);
            this.tagAllocationTable.use(tag, (Candidate)p, tagpos);
        }
    }

    protected void clear(Probe p) {
        ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)p);
        for (int i = 0; i < p.getTags().size(); ++i) {
            NucleotideSequence t = p.getTagAt(i);
            this.tagAllocationTable.unuse(t, p);
        }
        p.removeAllTags();
        p.setTagsAllocated(false);
        ProbeMakerPropertyUtils.setRank((PropertyAcceptor)p, (short)0);
    }

    public void confirm(Probe p) {
        if (p.tagsAllocated()) {
            this.reserve(p);
            this.analyzer.confirmUpdate(p, (TagAllocator)this, this.probes);
        }
    }

    public void setCurrentTagBad(int position) {
        int[] indices = this.tagSelector.getTagIndices();
        if (indices != null && indices.length > 0) {
            Integer posInt = new Integer(indices[position]);
            this.badTagsCurrent[position].add(posInt);
        }
    }

    protected void debugtime() {
        System.err.print("\t" + (new Date().getTime() - this.debugtime));
        this.debugtime = new Date().getTime();
    }

    public long getCandidateCount() {
        return this.candidatesGenerated;
    }

    static {
        defaultParameters.put("USE_SPACER", Boolean.FALSE.toString());
        defaultParameters.put("PREFERRED_LENGTH", "0");
        defaultParameters.put("SPACER_POSITION", "0");
        defaultParameters.put("SPACER_SEQUENCE", "");
    }
}

