/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.impl.SimpleRegion;
import org.moltools.lib.seq.utils.AdjacentRegionPredicate;
import org.moltools.lib.seq.utils.OverlapsRegionPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionUtils {
    public static final Comparator<Region> regionComparator = new Comparator<Region>(){

        @Override
        public int compare(Region o1, Region o2) {
            if (o1.getStart() < o2.getStart()) {
                return -1;
            }
            if (o1.getStart() > o2.getStart()) {
                return 1;
            }
            if (o1.getEnd() < o2.getEnd()) {
                return -1;
            }
            if (o1.getEnd() > o2.getEnd()) {
                return 1;
            }
            return 0;
        }
    };

    public static void sort(List<? extends Region> regions) {
        Collections.sort(regions, regionComparator);
    }

    public static Collection<Region> mergeAdjacent(Collection<? extends Region> regions) {
        ArrayList<Region> merged = new ArrayList<Region>();
        for (Region region : regions) {
            RegionUtils.addRegionWithMerge(merged, region);
        }
        return merged;
    }

    public static Region mergeUnchecked(Collection<? extends Region> merges) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Region region : merges) {
            min = Math.min(min, region.getStart());
            max = Math.max(max, region.getEnd());
        }
        return new SimpleRegion(min, max);
    }

    public static void addRegionWithMerge(Collection<Region> regions, Region newRegion) {
        Collection merges = CollectionUtils.select(regions, (Predicate)new AnyPredicate(new Predicate[]{new AdjacentRegionPredicate(newRegion), new OverlapsRegionPredicate(newRegion)}));
        regions.removeAll(merges);
        merges.add(newRegion);
        regions.add(RegionUtils.mergeUnchecked(merges));
    }

    public static int getTotalSize(List<Region> regions) {
        Collection<Region> merged = RegionUtils.mergeAdjacent(regions);
        int size = 0;
        for (Region r : merged) {
            size += r.length();
        }
        return size;
    }

    public static boolean contains(Region region, int pos) {
        if (region == null) {
            return false;
        }
        return region.getStart() <= pos && pos <= region.getEnd();
    }

    public static boolean equal(List<Region> allRegs, List<Region> selRegs) {
        if (allRegs.size() != selRegs.size()) {
            return false;
        }
        for (Region r1 : allRegs) {
            boolean found = false;
            for (Region r2 : selRegs) {
                if (r2.getStart() != r1.getStart() || r2.getEnd() != r1.getEnd()) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static Region intersection(Region r1, Region r2) {
        int start = Math.max(r1.getStart(), r2.getStart());
        int end = Math.min(r1.getEnd(), r2.getEnd());
        if (end >= start) {
            return new SimpleRegion(start, end);
        }
        return null;
    }
}

