/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.utils;

import org.moltools.lib.utils.AbstractIndexIterator;
import org.moltools.lib.utils.IndexUtils;

public class CombinationIndexIterator
extends AbstractIndexIterator {
    int[] stopIndices;

    static int[] getFirstComb(int[] stopIndices) {
        int[] start = new int[stopIndices.length];
        for (int i = 0; i < start.length; ++i) {
            if (stopIndices[i] < i) {
                throw new UnsupportedOperationException("Can't create combination iterator with too few elements to choose from");
            }
            start[i] = i;
        }
        return start;
    }

    private static int[] getStopIndices(int combSize, int elementCount) {
        int[] stop = new int[combSize];
        for (int i = 0; i < stop.length; ++i) {
            stop[i] = elementCount - combSize + i;
        }
        return stop;
    }

    public CombinationIndexIterator(int combSize, int elementCount) {
        this(CombinationIndexIterator.getStopIndices(combSize, elementCount));
    }

    protected CombinationIndexIterator(int[] stopIndices) {
        super(CombinationIndexIterator.getFirstComb(stopIndices));
        this.stopIndices = IndexUtils.copy(stopIndices);
    }

    protected int[] updateIndex(int[] current) {
        if (current == null) {
            return null;
        }
        int[] copy = IndexUtils.copy(current);
        for (int i = copy.length - 1; i >= 0; --i) {
            if (copy[i] < this.stopIndices[i]) {
                int n = i;
                copy[n] = copy[n] + 1;
                break;
            }
            copy[i] = 0;
            if (i != 0) continue;
            return null;
        }
        for (int i2 = 1; i2 < copy.length; ++i2) {
            if (copy[i2] > copy[i2 - 1]) continue;
            copy[i2] = copy[i2 - 1] + 1;
        }
        return copy;
    }
}

