/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.impl;

import org.moltools.lib.AbstractReidentifiable;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class SimpleChangeableNucleotideSequence
extends AbstractReidentifiable
implements Renameable,
ChangeableNucleotideSequence {
    protected String name;
    protected StringBuffer sequence;
    protected byte type;

    protected SimpleChangeableNucleotideSequence() {
        this("");
    }

    public SimpleChangeableNucleotideSequence(String id) {
        this(id, "", 0, "");
    }

    public SimpleChangeableNucleotideSequence(String id, byte typ) {
        this(id, "", typ, "");
    }

    public SimpleChangeableNucleotideSequence(String id, String seq) {
        this(id, seq, 0, "");
    }

    public SimpleChangeableNucleotideSequence(String id, String seq, byte typ) {
        this(id, seq, typ, "");
    }

    public SimpleChangeableNucleotideSequence(String id, String seq, String name) {
        this(id, seq, 0, name);
    }

    public SimpleChangeableNucleotideSequence(String id, String seq, byte type, String name) {
        super(id);
        this.type = type;
        this.name = name;
        this.sequence = new StringBuffer(seq);
    }

    public void setSequence(String newSeq) {
        this.sequence.replace(0, this.sequence.length(), newSeq);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setType(byte newType) {
        this.type = newType;
    }

    public void edit(SequenceEdit edit) {
        int stringIndex1 = edit.getPos() - 1;
        int stringIndex2 = stringIndex1 + edit.getReplaceLength();
        this.sequence.replace(stringIndex1, stringIndex2, edit.getReplaceString());
    }

    public String seqString() {
        return this.sequence.toString();
    }

    public String getName() {
        return this.name;
    }

    public byte getType() {
        return this.type;
    }

    public int length() {
        return this.sequence.length();
    }

    public String subsequence(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException("Start index out of bounds: " + start);
        }
        if (end > this.length()) {
            throw new IllegalArgumentException("End index out of bounds: " + end);
        }
        if (start > end) {
            throw new IllegalArgumentException("Start index greater than end index: " + start + " > " + end);
        }
        return this.sequence.substring(start - 1, end);
    }

    public Nucleotide getNucleotideAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new ArrayIndexOutOfBoundsException("Trying to get a nucleotide outside of the sequence (" + pos + ")");
        }
        Nucleotide nucleotide = NucleotideSequenceHandler.getNucleotide(this.sequence.charAt(pos - 1), this.type);
        return nucleotide;
    }
}

