/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import net.sf.apptools.textio.DataMapBuilder;
import net.sf.apptools.textio.DataMapOutput;
import net.sf.apptools.textio.OutputMapping;
import net.sf.apptools.textio.RecordBuilder;
import net.sf.apptools.textio.StringArrayOutput;
import net.sf.apptools.textio.TextIOUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOutputUtils {
    static Log log = LogFactory.getLog(TextOutputUtils.class);

    public static <T> void writeObjects(Collection<? extends T> objects, Writer out, StringArrayOutput dest, OutputMapping mapping, DataMapBuilder<T> builder) {
        TextOutputUtils.writeObjects(objects, out, dest, mapping, null, builder);
    }

    public static <T> void writeObjects(Collection<? extends T> objects, Writer out, StringArrayOutput dest, OutputMapping mapping, Map<String, Transformer> transforms, DataMapBuilder<T> builder) {
        PrintWriter pw = new PrintWriter(out);
        dest.setWriter(pw);
        for (T obj : objects) {
            Map<String, String> dataMap = builder.createDataMap(obj);
            Map<String, String> transformed = TextIOUtils.transformDataMap(dataMap, transforms);
            String[] record = mapping.createRecord(transformed);
            dest.writeRecord(record);
        }
        pw.flush();
    }

    public static <T> void writeObjects(Collection<? extends T> objects, Writer out, DataMapOutput output, DataMapBuilder<T> builder) {
        TextOutputUtils.writeObjects(objects, out, output, null, builder);
    }

    public static <T> void writeObjects(Collection<? extends T> objects, Writer out, DataMapOutput output, Map<String, Transformer> transforms, DataMapBuilder<T> builder) {
        PrintWriter pw = new PrintWriter(out);
        for (T obj : objects) {
            Map<String, String> dataMap = builder.createDataMap(obj);
            Map<String, String> transformed = TextIOUtils.transformDataMap(dataMap, transforms);
            output.writeDataMap(pw, transformed);
        }
        pw.flush();
    }

    public static <T> void writeObjects(Collection<? extends T> objects, Writer out, StringArrayOutput dest, RecordBuilder<T> recordBuilder) {
        PrintWriter pw = new PrintWriter(out);
        dest.setWriter(pw);
        for (T obj : objects) {
            String[] record = recordBuilder.getRecord(obj);
            dest.writeRecord(record);
        }
        pw.flush();
    }
}

