/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.textio.InputMapping;
import net.sf.apptools.textio.OutputMapping;
import net.sf.apptools.textio.TextIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnIndexMapping
implements InputMapping,
OutputMapping {
    private Map<Integer, String> columnIndexMapping;
    private int highestCol;
    protected boolean acceptTooFewColumns;

    public ColumnIndexMapping() {
        this(new HashMap<Integer, String>(), false);
    }

    public ColumnIndexMapping(Map<Integer, String> columnIndexMapping) {
        this(columnIndexMapping, false);
    }

    public ColumnIndexMapping(Map<Integer, String> columnIndexMapping, boolean acceptTooFewColumns) {
        this.setColumnIndexMapping(columnIndexMapping);
        this.acceptTooFewColumns = acceptTooFewColumns;
    }

    public boolean isAcceptTooFewColumns() {
        return this.acceptTooFewColumns;
    }

    public void setAcceptTooFewColumns(boolean acceptTooFewColumns) {
        this.acceptTooFewColumns = acceptTooFewColumns;
    }

    public Map<Integer, String> getColumnIndexMapping() {
        return this.columnIndexMapping;
    }

    public void setColumnIndexMapping(Map<Integer, String> columnIndexMapping) {
        this.columnIndexMapping = columnIndexMapping;
        this.highestCol = -1;
        for (Integer key : columnIndexMapping.keySet()) {
            if (key <= this.highestCol) continue;
            this.highestCol = key;
        }
    }

    @Override
    public Map<String, String> createMapForRecord(String[] record) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int index : this.columnIndexMapping.keySet()) {
            if (record.length > index) {
                String key = this.columnIndexMapping.get(index);
                String value = record[index];
                map.put(key, value);
                continue;
            }
            if (this.acceptTooFewColumns) continue;
            int colCount = record.length;
            String start = colCount == 0 ? "" : record[0].substring(0, Math.min(record[0].length(), 20));
            throw new TextIOException("Too few columns (" + colCount + " in record starting with '" + start + "'");
        }
        return map;
    }

    @Override
    public String[] createRecord(Map<String, String> outputData) {
        String[] record = new String[this.highestCol + 1];
        for (int i = 0; i < record.length; ++i) {
            record[i] = outputData.get(this.columnIndexMapping.get(i));
        }
        return record;
    }
}

