/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.textio.InputMapping;
import net.sf.apptools.textio.OutputMapping;
import net.sf.apptools.textio.TextIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMapping
implements InputMapping,
OutputMapping {
    protected String[] columnNames;
    protected boolean acceptTooFewColumns;
    protected boolean acceptTooManyColumns;

    public SimpleMapping() {
        this(new String[0], false, false);
    }

    public SimpleMapping(String[] columnNames) {
        this(columnNames, false, false);
    }

    public SimpleMapping(String[] columnNames, boolean acceptTooFewColumns, boolean acceptTooManyColumns) {
        this.columnNames = columnNames;
        this.acceptTooFewColumns = acceptTooFewColumns;
        this.acceptTooManyColumns = acceptTooManyColumns;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Map<String, String> createMapForRecord(String[] record) {
        int length;
        HashMap<String, String> map;
        block9: {
            map = new HashMap<String, String>();
            if (record.length < this.columnNames.length) {
                if (this.acceptTooFewColumns) {
                    length = record.length;
                    break block9;
                } else {
                    int colCount = record.length;
                    String start = colCount == 0 ? "" : record[0].substring(0, Math.min(record[0].length(), 20));
                    throw new TextIOException("Too few columns (" + colCount + " in record starting with '" + start + "'");
                }
            }
            if (record.length > this.columnNames.length) {
                if (this.acceptTooManyColumns) {
                    length = this.columnNames.length;
                    break block9;
                } else {
                    int colCount = record.length;
                    String start = colCount == 0 ? "" : record[0].substring(0, Math.min(record[0].length(), 20));
                    throw new TextIOException("Too many columns (" + colCount + " in record starting with '" + start + "'");
                }
            }
            length = record.length;
        }
        int i = 0;
        while (i < length) {
            if (this.columnNames[i] != null) {
                map.put(this.columnNames[i], record[i]);
            }
            ++i;
        }
        return map;
    }

    public boolean isAcceptTooFewColumns() {
        return this.acceptTooFewColumns;
    }

    public void setAcceptTooFewColumns(boolean acceptTooFewColumns) {
        this.acceptTooFewColumns = acceptTooFewColumns;
    }

    public boolean isAcceptTooManyColumns() {
        return this.acceptTooManyColumns;
    }

    public void setAcceptTooManyColumns(boolean acceptTooManyColumns) {
        this.acceptTooManyColumns = acceptTooManyColumns;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public String[] createRecord(Map<String, String> outputData) {
        String[] record = new String[this.columnNames.length];
        for (int i = 0; i < record.length; ++i) {
            String val;
            record[i] = val = outputData.get(this.columnNames[i]);
        }
        return record;
    }
}

