/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.textio.DataMapBuilder;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerDataMapBuilder<T>
implements DataMapBuilder<T> {
    protected Map<String, Transformer> transformers;

    public TransformerDataMapBuilder(Map<String, Transformer> transformers) {
        this.transformers = transformers;
    }

    @Override
    public Map<String, String> createDataMap(T obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.transformers.keySet()) {
            Object value = this.transformers.get(key).transform(obj);
            String valueString = value instanceof String ? (String)value : ConvertUtils.convert((Object)value);
            map.put(key, valueString);
        }
        return map;
    }

    public Map<String, Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Map<String, Transformer> transformers) {
        this.transformers = transformers;
    }
}

