/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.RequirementsResolver;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInLoader;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.plugin.RegistryFilePlugInLoader;
import net.sf.apptools.prefs.EntryDescriptor;
import net.sf.apptools.prefs.FileEntryDescriptor;
import net.sf.apptools.utils.JarClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreEngine
implements PreferenceChangeListener {
    public static final String ACTIVE_PLUGIN = "ACTIVE_PLUGIN";
    public static final String ACTIVE_PLUGIN_DESC = PlatformTexts.getString("CoreEngine.DESCRIPTION_ACTIVE_PLUGIN");
    public static final Class<ActivePlugIn> ACTIVE_PLUGIN_CLASS = ActivePlugIn.class;
    static final String KEY_PLUGIN_PATH = "PLUGIN_PATH";
    static final String KEY_PLUGIN_FILE = "PLUGIN_AUTOLOAD_FILE";
    public static final EntryDescriptor PLUGIN_PATH = new FileEntryDescriptor("PLUGIN_PATH", PlatformTexts.getString("CoreEngine.PREF_PLUGIN_PATH"), PlatformTexts.getString("CoreEngine.DESCRIPTION_PLUGIN_PATH"), "plugins", 1, true);
    public static final EntryDescriptor PLUGIN_FILE = new FileEntryDescriptor("PLUGIN_AUTOLOAD_FILE", PlatformTexts.getString("CoreEngine.PREF_PLUG_IN_FILE"), PlatformTexts.getString("CoreEngine.DESCRIPTION_PLUGIN_FILE"), "plugins/autoload.txt", 1, false);
    protected PlugInManager plugInManager;
    protected Preferences userPrefs;
    protected ActivePlugInManager activeManager;
    protected File plugInPath;
    protected File plugInFile;
    protected JarClassLoader classLoader;
    protected Log logger = LogFactory.getLog(CoreEngine.class);
    protected RequirementsResolver requirementsResolver;
    protected ResourceBundle configBundle;
    protected File libPath;

    public CoreEngine(PlugInManager manager, Preferences usePrefs) {
        try {
            this.configBundle = ResourceBundle.getBundle("apptools.platform");
        }
        catch (Throwable t) {
            this.logger.warn((Object)"Error accessing apptools.platform.properties configuration file. Attempting to run without it.");
        }
        if (this.configBundle == null) {
            this.logger.warn((Object)"No apptools.platform.properties configuration file found. Using defaults.");
            this.configBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    if (key.equals("apptools.platform.requirementsResolver")) {
                        return "net.sf.apptools.DefaultRequirementsResolver";
                    }
                    return null;
                }

                @Override
                public Enumeration<String> getKeys() {
                    Vector<String> v = new Vector<String>();
                    v.add("apptools.platform.requirementsResolver");
                    return v.elements();
                }
            };
        }
        this.plugInManager = manager;
        this.plugInManager.registerPlugInType(ACTIVE_PLUGIN, ACTIVE_PLUGIN_CLASS, ACTIVE_PLUGIN_DESC);
        this.activeManager = new ActivePlugInManager();
        this.userPrefs = usePrefs;
        if (this.userPrefs != null) {
            this.userPrefs.addPreferenceChangeListener(this);
            this.setPlugInPath(this.userPrefs.get(PLUGIN_PATH.getKey(), PLUGIN_PATH.getDefault()));
            this.setPlugInFile(this.userPrefs.get(PLUGIN_FILE.getKey(), PLUGIN_FILE.getDefault()));
        } else {
            this.setPlugInPath(PLUGIN_PATH.getDefault());
            this.setPlugInFile(null);
        }
        String libPathName = "extlib";
        try {
            libPathName = this.configBundle.getString("apptools.platform.extensionDir");
            this.logger.info((Object)("Config file extlib entry: " + libPathName));
        }
        catch (MissingResourceException mrx) {
            // empty catch block
        }
        this.libPath = new File(libPathName);
        this.logger.info((Object)("Plug-in path = " + this.plugInPath.getAbsolutePath()));
        this.logger.info((Object)("Extension library path = " + this.libPath.getAbsolutePath()));
        this.classLoader = new JarClassLoader(new URL[0], this.getClass().getClassLoader());
        this.updateClassLoader();
        this.logger.info((Object)("Loading plugins, " + PLUGIN_FILE.getKey() + " = " + this.plugInFile));
        if (this.plugInFile != null && !this.plugInFile.exists()) {
            this.logger.warn((Object)("Plugin file does not exist: " + this.plugInFile.getAbsolutePath()));
        }
        ArrayList loadMessages = new ArrayList();
        try {
            loadMessages.addAll(this.getPlugInManager().loadPlugIns(this.getPreferredPlugInLoader(false), true));
        }
        catch (PlugInException e) {
            this.logger.error((Object)"Error loading plug-ins", (Throwable)e);
        }
        for (String message : loadMessages) {
            this.logger.warn((Object)message);
        }
        this.logger.info((Object)"Done loading plugins");
    }

    private boolean isLibFile(File f) {
        String upp = f.getName().toUpperCase();
        return upp.endsWith(".JAR") || upp.endsWith(".ZIP");
    }

    private void updateClassLoader() {
        boolean libPathExists;
        if (this.plugInPath != null && this.plugInPath.exists()) {
            File[] files = this.plugInPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!this.isLibFile(file) || !this.classLoader.addJar(file)) continue;
                this.logger.info((Object)("Added plugin file: " + file.getAbsolutePath()));
            }
        }
        boolean bl = libPathExists = this.libPath.exists() && this.libPath.isDirectory();
        if (libPathExists) {
            File[] files = this.libPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!this.isLibFile(file) || !this.classLoader.addJar(file)) continue;
                this.logger.info((Object)("Added library file: " + file.getAbsolutePath()));
            }
        }
    }

    public PlugInManager getPlugInManager() {
        return this.plugInManager;
    }

    public Log getLog() {
        return this.logger;
    }

    public File getPlugInFile() {
        return this.plugInFile;
    }

    public File getPlugInPath() {
        return this.plugInPath;
    }

    public Preferences getUserPreferences() {
        return this.userPrefs;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        String value = evt.getNewValue();
        if (key.equals(PLUGIN_PATH.getKey()) && evt.getNode().isUserNode()) {
            this.setPlugInPath(value);
        } else if (key.equals(PLUGIN_FILE.getKey()) && evt.getNode().isUserNode()) {
            this.setPlugInFile(value);
        }
    }

    private void setPlugInPath(String path) {
        this.plugInPath = path.equals("") ? null : new File(path);
    }

    private void setPlugInFile(String fileName) {
        this.plugInFile = fileName == null ? null : (fileName.equals("") ? null : new File(fileName));
    }

    protected File[] getPlugInSearchPaths() {
        String cp = System.getProperty("java.class.path");
        String ps = System.getProperty("path.separator");
        String fs = System.getProperty("file.separator");
        String[] paths = cp.split(ps);
        ArrayList<String> pathList = new ArrayList<String>(Arrays.asList(paths));
        if (this.plugInPath != null && this.plugInPath.exists()) {
            String plugin = this.plugInPath.getAbsolutePath();
            if (!plugin.endsWith(fs)) {
                plugin = plugin + fs;
            }
            pathList.add(plugin);
        }
        String[] pathStrings = pathList.toArray(new String[pathList.size()]);
        File[] files = new File[pathStrings.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(pathStrings[i]);
        }
        return files;
    }

    public Set<ActivePlugIn> getActivePlugIns() {
        return this.activeManager.getActive();
    }

    public void addActivePlugIn(ActivePlugIn api) {
        this.activeManager.addActive(api);
    }

    public ActivePlugIn getPlugInInstance(Class<?> plugInClass) {
        for (ActivePlugIn pi : this.getActivePlugIns()) {
            if (!plugInClass.isAssignableFrom(pi.getClass())) continue;
            return pi;
        }
        return null;
    }

    public ActivePlugIn getPlugInInstance(String plugInClassName) throws PlugInException {
        Class<?> c;
        try {
            c = Class.forName(plugInClassName, true, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"Could not load PlugIn class", (Throwable)e);
            throw new PlugInException(MessageFormat.format("The PlugIn type {0} is unknown.", plugInClassName), (Throwable)e);
        }
        return this.getPlugInInstance(c);
    }

    public <T extends ActivePlugIn> List<? extends ActivePlugIn> activatePlugIn(Class<T> plugInClass) throws PlugInException {
        T o;
        ActivePlugIn p = this.getPlugInInstance(plugInClass);
        if (p != null) {
            this.logger.info((Object)(plugInClass + " already active"));
            return null;
        }
        this.logger.info((Object)("Activating " + plugInClass));
        try {
            o = plugInClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.error((Object)"Could not instantiate PlugIn class", (Throwable)e);
            throw new PlugInException(MessageFormat.format("The PlugIn type {0} could not be instantiated.", plugInClass.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)"Could not access PlugIn class", (Throwable)e);
            throw new PlugInException(MessageFormat.format("The PlugIn type {0} could not be accessed.", plugInClass.getName()), (Throwable)e);
        }
        if (o instanceof ActivePlugIn) {
            ActivePlugIn ap = (ActivePlugIn)o;
            if (this.requirementsResolver == null) {
                try {
                    String className = this.configBundle.getString("apptools.platform.requirementsResolver");
                    Class rrClass = this.classLoader.loadClass(className);
                    this.requirementsResolver = (RequirementsResolver)rrClass.newInstance();
                }
                catch (MissingResourceException e) {
                    this.logger.error((Object)"No requirements resolver set. Check the apptools properties file", (Throwable)e);
                    throw new PlugInException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    this.logger.error((Object)"Could not find resolver", (Throwable)e);
                    throw new PlugInException((Throwable)e);
                }
                catch (InstantiationException e) {
                    this.logger.error((Object)"Could not instantiate resolver", (Throwable)e);
                    throw new PlugInException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.error((Object)"Could not access resolver", (Throwable)e);
                    throw new PlugInException((Throwable)e);
                }
            }
            List<? extends ActivePlugIn> plugins = this.requirementsResolver.getRequirements(ap, this, (ClassLoader)this.classLoader);
            this.activeManager.addActive(ap);
            return plugins;
        }
        throw new PlugInException(MessageFormat.format("The specified class is not a PlugIn class: {0}", plugInClass.getName()));
    }

    public void deactivatePlugIn(ActivePlugIn plugIn) {
        this.logger.info((Object)("Closing " + plugIn.getClass()));
        plugIn.teardown();
        this.activeManager.removeActive(plugIn);
    }

    public EntryDescriptor[] getPreferencesEntries() {
        return new EntryDescriptor[]{PLUGIN_PATH, PLUGIN_FILE};
    }

    public PlugInLoader getPreferredPlugInLoader(boolean overrideNameFile) {
        return new RegistryFilePlugInLoader((ClassLoader)this.classLoader);
    }

    public JarClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ActivePlugInManager {
        private Set<ActivePlugIn> active = new HashSet<ActivePlugIn>();

        ActivePlugInManager() {
        }

        void addActive(ActivePlugIn api) {
            for (ActivePlugIn other : this.active) {
                if (api == null) {
                    throw new RuntimeException("Tried to add a null plugin");
                }
                if (!api.getClass().getName().equals(other.getClass().getName())) continue;
                throw new RuntimeException("An instance of " + api.getClass().getName() + " is already active");
            }
            this.active.add(api);
            CoreEngine.this.logger.info((Object)("Added active plugin: " + api.getClass()));
        }

        Set<ActivePlugIn> getActive() {
            return Collections.unmodifiableSet(this.active);
        }

        void removeActive(ActivePlugIn api) {
            this.active.remove(api);
        }
    }
}

