/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.utils;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.ui.swing.utils.GUIUtils;

public class ListMultiComponentDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JPanel listPane;
    protected JPanel controlPane;
    protected JPanel cardPane;
    protected CardLayout cardLayout;
    protected JList list;
    protected JButton okButton;

    public ListMultiComponentDialog(Frame owner, String title, Component[] components, Component prototype) throws HeadlessException {
        super(owner, title, true);
        this.setDefaultCloseOperation(0);
        this.cardLayout = new CardLayout();
        this.cardPane = new JPanel(this.cardLayout);
        this.cardPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel p = new JPanel(new FlowLayout(3));
        p.add(this.cardPane);
        this.okButton = new JButton(PlatformTexts.getString((String)"Common.CAPTION_OK"));
        this.okButton.addActionListener(this);
        this.controlPane = new JPanel();
        this.controlPane.setLayout(new BoxLayout(this.controlPane, 2));
        this.controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.controlPane.add(Box.createHorizontalGlue());
        this.controlPane.add(this.okButton);
        this.listPane = new JPanel(new BorderLayout());
        this.listPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.controlPane, "Last");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.listPane, "Before");
        this.list = new JList();
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getSource() == ListMultiComponentDialog.this.list && (index = ListMultiComponentDialog.this.list.locationToIndex(e.getPoint())) >= 0 && index < ListMultiComponentDialog.this.cardPane.getComponentCount()) {
                    ListMultiComponentDialog.this.cardLayout.show(ListMultiComponentDialog.this.cardPane, String.valueOf(index));
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        sp.setPreferredSize(new Dimension(220, p.getHeight()));
        this.listPane.add((Component)sp, "Center");
        this.setupComponents(components, prototype);
        this.pack();
        this.setLocation(GUIUtils.suggestLocation(this, owner));
    }

    protected void setupComponents(Component[] components, Component prototype) {
        if (prototype != null) {
            this.cardPane.add(prototype, prototype.getName() == null ? "Prototype" : prototype.getName());
        }
        if (components != null) {
            DefaultListModel<String> m = new DefaultListModel<String>();
            for (int i = 0; i < components.length; ++i) {
                Component c = components[i];
                String name = c.getName() == null ? String.valueOf(i) : c.getName();
                this.cardPane.add(c, String.valueOf(i));
                m.addElement(name);
            }
            this.list.setModel(m);
        }
        this.list.setPrototypeCellValue(prototype == null ? null : prototype.getName());
        try {
            this.cardLayout.show(this.cardPane, "0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }
}

