/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.ext.target.SelectorTarget;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Target;
import org.moltools.design.data.ValidatingTarget;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorLigationModule
extends AbstractProbeModule {
    public static final int PROPERTY_TARGET_5_MATCH_LENGTH = 6;
    public static final int PROPERTY_TARGET_3_MATCH_LENGTH = 6;
    public static final int PROPERTY_SELECTOR_5_MATCH_LENGTH = 4;
    public static final int PROPERTY_SELECTOR_3_MATCH_LENGTH = 4;
    public static final String KEY_TARGET_5_MATCH_LENGTH = "TARGET_5_MATCH_LENGTH";
    public static final String KEY_TARGET_3_MATCH_LENGTH = "TARGET_3_MATCH_LENGTH";
    public static final String KEY_SELECTOR_5_MATCH_LENGTH = "SELECTOR_5_MATCH_LENGTH";
    public static final String KEY_SELECTOR_3_MATCH_LENGTH = "SELECTOR_3_MATCH_LENGTH";
    public static final byte FIVE_PRIME_END = 1;
    public static final byte THREE_PRIME_END = 2;
    public static final MessageType SELECTOR_SELF_LIGATION_5 = new MessageType("SELECTOR_SELF_LIGATION_5", "Selector ligates to self at 5' end");
    public static final MessageType SELECTOR_SELF_LIGATION_3 = new MessageType("SELECTOR_SELF_LIGATION_3", "Selector ligates to self at 3' end");
    public static final MessageType SELECTOR_TARGET_LIGATION_5 = new MessageType("SELECTOR_TARGET_LIGATION_5", "Selector ligates to target at 5' end");
    public static final MessageType SELECTOR_OTHER_LIGATION_5 = new MessageType("SELECTOR_OTHER_LIGATION_5", "Selector 5' end ligates to other selector");
    public static final MessageType SELECTOR_OTHER_LIGATION_3 = new MessageType("SELECTOR_OTHER_LIGATION_3", "Selector 3' end ligates to other selector");
    public static final MessageType SELECTOR_LIGATION_OTHER_5 = new MessageType("SELECTOR_LIGATION_OTHER_5", "Other selector 5' end ligates to this");
    public static final MessageType SELECTOR_LIGATION_OTHER_3 = new MessageType("SELECTOR_LIGATION_OTHER_3", "Other selector 3' end ligates to this");
    public static final MessageType SELECTOR_TARGET_LIGATION_OTHER_5 = new MessageType("SELECTOR_TARGET_LIGATION_OTHER_5", "Target 5' end ligates to other selector");
    public static final MessageType SELECTOR_TARGET_LIGATION_OTHER_3 = new MessageType("SELECTOR_TARGET_LIGATION_OTHER_3", "Target 3' end ligates to other selector");
    protected transient int target5;
    protected transient int target3;
    protected transient int selector5;
    protected transient int selector3;

    public static String getBriefDescription() {
        return "Selector probe ligation";
    }

    public static String getLongDescription() {
        return "<html>For use in TSS evaluation stage.<br>Checks if a selector probe will ligate to another target in the set or to another selector in the set. If structure-specific cleavage is used, also checks if the probe will be ligated on the 5' end of its own target.<br>Also checks if selector will ligate to itself.<br>Tests are done by checking the 5' or 3' terminal nucleotides of the appropriate sequence and checking if they occur at the potential ligation site.The number of bases required to match is speicified by parameters.<br>An error message is given if a matching sequence is found.</html>";
    }

    public SelectorLigationModule() {
        super(new TestDescriptor[]{new TestDescriptor("Ligation to self on 5' end"), new TestDescriptor("Ligation to self on 3' end"), new TestDescriptor("Ligation to target's 5' end"), new TestDescriptor("Ligation to other selector on 5' end"), new TestDescriptor("Ligation to other selector on 3' end"), new TestDescriptor("Other selector ligates on 5' end"), new TestDescriptor("Other selector ligates on 3' end"), new TestDescriptor("Ligation to other target's 5' end"), new TestDescriptor("Ligation to other target's 3' end")}, new DataDescriptor[]{new IntegerDescriptor("Min. target 5' match length", "Minimum number of matching bases on 5' end for targets", KEY_TARGET_5_MATCH_LENGTH, 1, 100), new IntegerDescriptor("Min. target 3' match length", "Minimum number of matching bases on 3' end for targets", KEY_TARGET_3_MATCH_LENGTH, 1, 100), new IntegerDescriptor("Min. selectors 5' match length", "Minimum number of matching bases on 5' end for selectors", KEY_SELECTOR_5_MATCH_LENGTH, 1, 100), new IntegerDescriptor("Min. selectors 3' match length", "Minimum number of matching bases on 3' end for selectors", KEY_SELECTOR_3_MATCH_LENGTH, 1, 100)});
        this.setData(KEY_TARGET_5_MATCH_LENGTH, new Integer(6));
        this.setData(KEY_TARGET_3_MATCH_LENGTH, new Integer(6));
        this.setData(KEY_SELECTOR_5_MATCH_LENGTH, new Integer(4));
        this.setData(KEY_SELECTOR_3_MATCH_LENGTH, new Integer(4));
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        NucleotideSequence sel3;
        NucleotideSequence sel5;
        try {
            sel5 = (NucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
        }
        catch (ClusterException e) {
            sel5 = null;
        }
        try {
            sel3 = (NucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
        }
        catch (ClusterException e) {
            sel3 = null;
        }
        if (this.tests[0].perform() && sel5 != null && this.isMatch((NucleotideSequence)p, sel5, false, (byte)1)) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_SELF_LIGATION_5.getDescription(), SELECTOR_SELF_LIGATION_5, 1));
        }
        if (this.tests[1].perform() && sel3 != null && this.isMatch((NucleotideSequence)p, sel3, false, (byte)2)) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_SELF_LIGATION_3.getDescription(), SELECTOR_SELF_LIGATION_3, 1));
        }
        if (this.tests[2].perform()) {
            Target t = p.getTarget();
            if (t != null) {
                if (t instanceof SelectorTarget) {
                    SelectorTarget it = (SelectorTarget)t;
                    if (Integer.parseInt(it.getVariant().getName()) > 0 && this.isMatch((NucleotideSequence)it, sel5, true, (byte)1)) {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_TARGET_LIGATION_5.getDescription(), SELECTOR_TARGET_LIGATION_5, 1));
                    }
                } else {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: Incompatible target", SELECTOR_TARGET_LIGATION_5, 0));
                }
            } else {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: No target", SELECTOR_TARGET_LIGATION_5, 0));
            }
        }
        for (Probe other : probes) {
            SelectorTarget it;
            ValidatingTarget t;
            NucleotideSequence other3;
            NucleotideSequence other5;
            try {
                other5 = (NucleotideSequence)other.getTSSPair().getSequence("FIVE_PRIME");
            }
            catch (ClusterException e) {
                other5 = null;
            }
            try {
                other3 = (NucleotideSequence)other.getTSSPair().getSequence("THREE_PRIME");
            }
            catch (ClusterException e) {
                other3 = null;
            }
            if (other.equals(p)) continue;
            if (this.tests[3].perform() && other5 != null && this.isMatch((NucleotideSequence)p, other5, false, (byte)1)) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_OTHER_LIGATION_5.getDescription() + ": " + other.getName(), SELECTOR_OTHER_LIGATION_5, 1));
            }
            if (this.tests[4].perform() && other3 != null && this.isMatch((NucleotideSequence)p, other3, false, (byte)2)) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_OTHER_LIGATION_3.getDescription() + ": " + other.getName(), SELECTOR_OTHER_LIGATION_3, 1));
            }
            if (this.tests[5].perform() && sel5 != null && this.isMatch((NucleotideSequence)other, sel5, false, (byte)1)) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_LIGATION_OTHER_5.getDescription() + ": " + other.getName(), SELECTOR_LIGATION_OTHER_5, 1));
            }
            if (this.tests[6].perform() && sel3 != null && this.isMatch((NucleotideSequence)other, sel3, false, (byte)2)) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_LIGATION_OTHER_3.getDescription() + ": " + other.getName(), SELECTOR_LIGATION_OTHER_3, 1));
            }
            if (this.tests[7].perform() && sel5 != null) {
                t = (ValidatingTarget)other.getTarget();
                if (t != null) {
                    if (t instanceof SelectorTarget) {
                        it = (SelectorTarget)t;
                        if (this.isMatch((NucleotideSequence)it, sel5, true, (byte)1)) {
                            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_TARGET_LIGATION_OTHER_5.getDescription() + ": " + other.getName(), SELECTOR_TARGET_LIGATION_OTHER_5, 1));
                        }
                    } else {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: Incompatible target", SELECTOR_TARGET_LIGATION_OTHER_5, 0));
                    }
                } else {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: No target", SELECTOR_TARGET_LIGATION_OTHER_5, 0));
                }
            }
            if (!this.tests[8].perform() || sel3 == null) continue;
            t = (ValidatingTarget)other.getTarget();
            if (t != null) {
                if (t instanceof SelectorTarget) {
                    it = (SelectorTarget)t;
                    if (!this.isMatch((NucleotideSequence)it, sel3, true, (byte)2)) continue;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message(SELECTOR_TARGET_LIGATION_OTHER_3.getDescription() + ": " + other.getName(), SELECTOR_TARGET_LIGATION_OTHER_3, 1));
                    continue;
                }
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: Incompatible target", SELECTOR_TARGET_LIGATION_OTHER_3, 0));
                continue;
            }
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Could not perform ligation to target test: No target", SELECTOR_TARGET_LIGATION_OTHER_3, 0));
        }
    }

    protected boolean isMatch(NucleotideSequence s1, NucleotideSequence s2, boolean isTargetTest, byte end) {
        int length = isTargetTest ? (end == 1 ? this.target5 : this.target3) : (end == 1 ? this.selector5 : this.selector3);
        String str1 = this.getEnd(s1, length, end);
        String str2 = this.getEnd(s2, length, end == 1 ? (byte)2 : 1);
        boolean result = str1.equals(NucleotideSequenceHandler.getRevComp((String)str2, (byte)s2.getType(), (byte)s2.getType()));
        return result;
    }

    protected String getEnd(NucleotideSequence s, int length, byte end) {
        int maxLength = s.length();
        int useLength = length > maxLength ? maxLength : length;
        switch (end) {
            case 2: {
                return s.subsequence(maxLength - useLength + 1, maxLength);
            }
            case 1: {
                return s.subsequence(1, useLength);
            }
        }
        throw new IllegalArgumentException("Illegal end value passed to getEnd()");
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void reset() {
        this.target5 = (Integer)this.getData(KEY_TARGET_5_MATCH_LENGTH);
        this.target3 = (Integer)this.getData(KEY_TARGET_3_MATCH_LENGTH);
        this.selector5 = (Integer)this.getData(KEY_SELECTOR_5_MATCH_LENGTH);
        this.selector3 = (Integer)this.getData(KEY_SELECTOR_3_MATCH_LENGTH);
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

