/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import net.sf.apptools.data.AbstractDataDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerDescriptor
extends AbstractDataDescriptor {
    int lowerLimit;
    int upperLimit;

    public IntegerDescriptor(String name, String description, String propertyName, int lower, int upper) {
        super(name, description, propertyName, true);
        this.lowerLimit = lower;
        this.upperLimit = upper;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public Class<?> getDataType() {
        return new Integer(0).getClass();
    }

    protected Object getValue(Object valueRepr) {
        if (valueRepr instanceof Integer) {
            return valueRepr;
        }
        return new Integer(valueRepr.toString());
    }

    @Override
    public String validate(Object obj) {
        if (obj == null) {
            return "No input for '" + this.getName() + "'";
        }
        Integer i = (Integer)this.getValue(obj);
        int input = i;
        if (this.lowerLimit <= input && input <= this.upperLimit) {
            return null;
        }
        return "'" + this.getName() + "' should be [" + this.lowerLimit + ", " + this.upperLimit + "]";
    }
}

