/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import net.sf.apptools.data.AbstractDataDescriptor;
import net.sf.apptools.data.ConvertibleDataDescriptor;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSelectionDescriptor
extends AbstractDataDescriptor
implements ConvertibleDataDescriptor {
    protected Class<?> valueClass;
    protected Object[] objects;
    protected Converter toValueConverter = new ListSelectionConverter();
    protected Converter toStringConverter;

    public ListSelectionDescriptor(String name, String description, String propertyName, Object[] objects, Class<?> valueClass, boolean required, Converter toStringConverter) {
        super(name, description, propertyName, required);
        this.valueClass = valueClass;
        this.objects = objects;
        this.toStringConverter = toStringConverter;
    }

    @Override
    public Class<?> getDataType() {
        return this.valueClass;
    }

    protected Object getObjectWithString(String string) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.toStringConverter.convert(String.class, this.objects[i]).equals(string)) continue;
            return this.objects[i];
        }
        throw new IllegalArgumentException("No object with string '" + string + "'");
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public void setObjects(Object[] selectionObjects) {
        this.objects = selectionObjects;
    }

    @Override
    public Converter getToValueConverter() {
        return this.toValueConverter;
    }

    @Override
    public Converter getToStringConverter() {
        return this.toStringConverter;
    }

    class ListSelectionConverter
    implements Converter {
        ListSelectionConverter() {
        }

        public Object convert(Class type, Object valueRepr) {
            if (valueRepr == null) {
                return null;
            }
            if (valueRepr instanceof String) {
                return ListSelectionDescriptor.this.getObjectWithString((String)valueRepr);
            }
            if (ListSelectionDescriptor.this.getDataType().isAssignableFrom(valueRepr.getClass())) {
                return valueRepr;
            }
            throw new IllegalArgumentException(valueRepr.getClass() + " not supported by ListSelectionDescriptor");
        }
    }
}

