/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import java.util.List;
import net.sf.apptools.data.ListSelectionDescriptor;
import net.sf.apptools.plugin.PlugInUtils;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInListSelectionDescriptor
extends ListSelectionDescriptor {
    public PlugInListSelectionDescriptor(String name, String description, String propertyName, List<?> objects, boolean required) {
        super(name, description, propertyName, objects.toArray(), Object.class, required, new PlugInListSelectionToStringConverter());
        this.toValueConverter = new PlugInListSelectionConverter();
    }

    protected Object getPlugInWithDescription(String desc) {
        for (int i = 0; i < this.objects.length; ++i) {
            Object o = this.objects[i];
            String d = PlugInUtils.getBriefDescription(o);
            if (!desc.equals(d)) continue;
            return o;
        }
        throw new IllegalArgumentException("No plug-in with description '" + desc + "'");
    }

    class PlugInListSelectionConverter
    implements Converter {
        PlugInListSelectionConverter() {
        }

        public Object convert(Class type, Object valueRepr) {
            if (valueRepr == null) {
                return null;
            }
            if (valueRepr instanceof String) {
                return PlugInListSelectionDescriptor.this.getPlugInWithDescription((String)valueRepr);
            }
            if (PlugInUtils.isValidPlugIn(valueRepr)) {
                return valueRepr;
            }
            throw new IllegalArgumentException(valueRepr.getClass() + " not supported by PlugInListSelectionDescriptor");
        }
    }

    static class PlugInListSelectionToStringConverter
    implements Converter {
        PlugInListSelectionToStringConverter() {
        }

        public Object convert(Class type, Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return value;
            }
            return PlugInUtils.getBriefDescription(value);
        }
    }
}

