/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.apptools.prefs.EntryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesEntryTree {
    Node root;

    public PreferencesEntryTree(String rootName) {
        this.root = new Node(rootName);
    }

    public Node getRootNode() {
        return this.root;
    }

    public Node getNode(String nodePath) {
        String[] path = nodePath.split("/");
        Node n = this.root;
        for (int i = 0; i < path.length; ++i) {
            Node newNode = n.getNode(path[i]);
            if (newNode == null) {
                return null;
            }
            n = newNode;
        }
        return n;
    }

    public Node createNode(String nodePath) {
        if (nodePath.startsWith("/")) {
            throw new UnsupportedOperationException("Absolute node paths are not allowed");
        }
        if (nodePath.equals("")) {
            throw new UnsupportedOperationException("Creating root node is not allowed");
        }
        if (this.getNode(nodePath) != null) {
            throw new UnsupportedOperationException("Node already exists");
        }
        String[] path = nodePath.split("/");
        Node n = this.root;
        for (int i = 0; i < path.length; ++i) {
            Node newNode = n.getNode(path[i]);
            if (newNode == null) {
                newNode = new Node(path[i]);
                n.addNode(newNode);
            }
            n = newNode;
        }
        return n;
    }

    public void removeNode(Node n) {
        Node p = n.parent;
        if (p != null) {
            p.removeNode(n);
        }
    }

    public Map<String, Node> getAllNodes() {
        return this.getNodes(this.root, "");
    }

    protected Map<String, Node> getNodes(Node n, String path) {
        TreeMap<String, Node> m = new TreeMap<String, Node>();
        m.put(path, n);
        Iterator<Node> i = n.getNodes().iterator();
        while (i.hasNext()) {
            m.putAll(this.getNodes(i.next(), path + "/" + n.getName()));
        }
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        String name;
        List<Node> nodes;
        EntryDescriptor[] entries;
        Node parent = null;

        public Node(String name) {
            this(new EntryDescriptor[0], name, new ArrayList<Node>());
        }

        public Node(EntryDescriptor[] entries, String name, List<Node> nodes) {
            this.entries = entries;
            if (name.indexOf("/") >= 0) {
                throw new IllegalArgumentException("Node name must not contain '/'");
            }
            this.name = name;
            this.nodes = new ArrayList<Node>(nodes);
        }

        public EntryDescriptor[] getEntries() {
            return this.entries;
        }

        public String getName() {
            return this.name;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public Node getNode(String nodeName) {
            Node[] nodeArray = this.nodes.toArray(new Node[this.nodes.size()]);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!nodeArray[i].getName().equals(nodeName)) continue;
                return nodeArray[i];
            }
            return null;
        }

        public EntryDescriptor getEntry(String entryName) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!this.entries[i].getKey().equals(entryName)) continue;
                return this.entries[i];
            }
            return null;
        }

        public boolean hasChildren() {
            return this.nodes.size() > 0;
        }

        void removeNode(Node node) {
            this.nodes.remove(node);
            node.parent = null;
        }

        void addNode(Node node) {
            node.parent = this;
            this.nodes.add(node);
        }

        public void addEntries(EntryDescriptor[] descriptors) {
            EntryDescriptor[] newEntries = new EntryDescriptor[this.entries.length + descriptors.length];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            System.arraycopy(descriptors, 0, newEntries, this.entries.length, descriptors.length);
            this.entries = newEntries;
        }

        public void removeEntries(EntryDescriptor[] descriptors) {
            ArrayList<EntryDescriptor> old = new ArrayList<EntryDescriptor>(Arrays.asList(this.entries));
            ArrayList<EntryDescriptor> remove = new ArrayList<EntryDescriptor>(Arrays.asList(descriptors));
            old.removeAll(remove);
            this.entries = old.toArray(new EntryDescriptor[old.size()]);
        }

        public String toString() {
            return "Node " + this.name + ", " + this.nodes.size() + " children, " + this.entries.length + " entries";
        }
    }
}

