/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.utils;

import net.sf.apptools.utils.HTMLRenderer;

public abstract class AbstractDelegateHTMLRenderer
implements HTMLRenderer {
    private HTMLRenderer delegate = null;

    public AbstractDelegateHTMLRenderer(HTMLRenderer delegate) {
        this.setDelegateHTMLRenderer(delegate);
    }

    public void setDelegateHTMLRenderer(HTMLRenderer delegate) {
        this.delegate = delegate;
    }

    public boolean canRenderHTML(Object o) {
        if (this.canRenderHTMLInternal(o)) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.canRenderHTML(o);
        }
        return false;
    }

    public String renderHTML(Object obj) {
        if (this.canRenderHTMLInternal(obj)) {
            return this.renderHTMLInternal(obj);
        }
        if (this.delegate != null) {
            return this.delegate.renderHTML(obj);
        }
        throw new UnsupportedOperationException("HTML Renderer does not support objects of class " + obj.getClass().getName());
    }

    public String getHTMLContainerTitle(Object obj) {
        if (this.canRenderHTMLInternal(obj)) {
            return this.getHTMLContainerTitleInternal(obj);
        }
        if (this.delegate != null) {
            return this.delegate.getHTMLContainerTitle(obj);
        }
        throw new UnsupportedOperationException("HTML Renderer does not support objects of class " + obj.getClass().getName());
    }

    protected abstract boolean canRenderHTMLInternal(Object var1);

    protected abstract String renderHTMLInternal(Object var1);

    protected abstract String getHTMLContainerTitleInternal(Object var1);
}

