/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.utils;

import java.io.PrintWriter;

public class HTMLWriter {
    public static HTMLTag HEAD = new HTMLTag("head");
    public static HTMLTag BODY = new HTMLTag("body");
    public static HTMLTag HTML = new HTMLTag("html");
    public static HTMLTag P = new HTMLTag("p");
    public static HTMLTag H1 = new HTMLTag("h1");
    public static HTMLTag H2 = new HTMLTag("h2");
    public static HTMLTag H3 = new HTMLTag("h3");
    public static HTMLTag H4 = new HTMLTag("h4");
    public static HTMLTag H5 = new HTMLTag("h5");
    public static HTMLTag H6 = new HTMLTag("h6");
    public static HTMLTag BR = new HTMLTag("br");
    public static HTMLTag HR = new HTMLTag("hr");
    public static HTMLTag PRE = new HTMLTag("pre");
    public static HTMLTag BLINK = new HTMLTag("blink");
    public static HTMLTag B = new HTMLTag("b");
    public static HTMLTag I = new HTMLTag("i");
    public static HTMLTag TT = new HTMLTag("tt");
    public static HTMLTag UL = new HTMLTag("ul");
    public static HTMLTag OL = new HTMLTag("ol");
    public static HTMLTag LI = new HTMLTag("li");
    public static HTMLTag DL = new HTMLTag("dl");
    public static HTMLTag DT = new HTMLTag("dt");
    public static HTMLTag DD = new HTMLTag("dd");
    public static HTMLTag TABLE = new HTMLTag("table");
    public static HTMLTag TH = new HTMLTag("th");
    public static HTMLTag TR = new HTMLTag("tr");
    public static HTMLTag TD = new HTMLTag("td");
    public static HTMLTag BORDER = new HTMLTag("border");
    public static HTMLTag CELLPADDING = new HTMLTag("cellpadding");
    public static HTMLTag CELLSPACING = new HTMLTag("cellspacing");
    public static HTMLTag COLOR = new HTMLTag("color");
    public static HTMLTag FONT = new HTMLTag("font");
    public static HTMLTag ALIGN = new HTMLTag("align");
    public static HTMLTag LEFT = new HTMLTag("left");
    public static HTMLTag RIGHT = new HTMLTag("right");
    public static HTMLTag CENTER = new HTMLTag("center");
    static Special[] specials = new Special[]{new Special('<', "&gt;"), new Special('>', "&lt;"), new Special('&', "&amp"), new Special('\"', "&quot;")};
    PrintWriter out;

    public HTMLWriter(PrintWriter p) {
        this.out = p;
    }

    public void close() {
        this.out.close();
    }

    public void printTag(HTMLTag tag) {
        this.out.print("<" + tag.getTag() + ">");
        this.out.flush();
    }

    public void printEndTag(HTMLTag tag) {
        this.out.print("</" + tag.getTag() + ">");
        this.out.flush();
    }

    public void printAttributeTag(HTMLTag tag, String[] attributeNames, String[] attributeValues) {
        String str = "<" + tag.getTag() + " ";
        for (int i = 0; i < Math.min(attributeNames.length, attributeValues.length); ++i) {
            str = str + attributeNames[i] + "=" + "\"" + attributeValues[i] + "\" ";
        }
        str = str + ">";
        this.out.println(str);
        this.out.flush();
    }

    public void printText(String text) {
        this.out.println(HTMLWriter.getHTMLText(text));
        this.out.flush();
    }

    public void println(String text) {
        this.printText(text);
        this.printTag(BR);
    }

    public void printEnclosed(String text, HTMLTag tag) {
        this.printTag(tag);
        this.printText(text);
        this.printEndTag(tag);
    }

    public static void appendEnclosed(StringBuffer sb, String text, HTMLTag tag) {
        sb.append("<" + tag.getTag() + ">");
        sb.append(HTMLWriter.getHTMLText(text));
        sb.append("</" + tag.getTag() + ">");
    }

    public static String getHTMLText(String text) {
        StringBuffer parsed = new StringBuffer();
        String theText = text == null ? "null" : text;
        for (int i = 0; i < theText.length(); ++i) {
            char c = theText.charAt(i);
            boolean wasspecial = false;
            for (int s = 0; s < specials.length; ++s) {
                if (c != HTMLWriter.specials[s].c) continue;
                parsed.append(HTMLWriter.specials[s].str);
                wasspecial = true;
            }
            if (wasspecial) continue;
            parsed.append(c);
        }
        return parsed.toString();
    }

    static class Special {
        protected String str;
        protected char c;

        public Special(char symbol, String replacement) {
            this.str = replacement;
            this.c = symbol;
        }
    }

    public static class HTMLTag {
        protected String tag;

        public HTMLTag(String text) {
            this.tag = text.toUpperCase();
        }

        public String getTag() {
            return this.tag;
        }
    }
}

