/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DefaultDataHolder;
import net.sf.apptools.data.OptionDescriptor;
import net.sf.apptools.data.PlugInClassListSelectionDescriptor;
import net.sf.apptools.data.StringDataDescriptor;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.ParameterPlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.prefs.EntryDescriptor;
import net.sf.apptools.prefs.FileEntryDescriptor;
import net.sf.apptools.task.Task;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.ProbeAnalysisTask;
import org.moltools.apps.probemaker.ProbeDesignTask;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.ProjectInputErrorCallback;
import org.moltools.apps.probemaker.RegisteredAction;
import org.moltools.apps.probemaker.TargetIOTask;
import org.moltools.apps.probemaker.design.DefaultProbeDesigner;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.design.ProbeDesigner;
import org.moltools.apps.probemaker.design.ProbeSelector;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.design.TargetHandler;
import org.moltools.apps.probemaker.io.DefaultTargetInputFormat;
import org.moltools.apps.probemaker.io.TargetInputFormat;
import org.moltools.apps.probemaker.modules.ProbeAnalysisModule;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.project.ProjectHolder;
import org.moltools.apps.probemaker.project.ProjectIOTask;
import org.moltools.apps.probemaker.project.ProjectListener;
import org.moltools.apps.probemaker.project.ProjectTemplate;
import org.moltools.apps.probemaker.project.ProjectXMLIOTask;
import org.moltools.apps.probemaker.project.Settings;
import org.moltools.apps.probemaker.project.SettingsIO;
import org.moltools.apps.probemaker.project.TemplateListSelectionDescriptor;
import org.moltools.apps.probemaker.project.TemplateManager;
import org.moltools.apps.probemaker.project.TemplateXMLHandler;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.impl.DefaultProbe;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.io.SequenceDBDataReader;
import org.moltools.lib.seq.io.SequenceDBWriter;
import org.moltools.lib.seq.io.impl.FastaDBFormat;
import org.moltools.lib.seq.utils.SequenceIO;
import org.moltools.workbench.MolToolsWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeMakerPlugIn
implements ProjectHolder,
ActivePlugIn,
ProbeMakerConstants,
ActionListener,
ProjectListener,
PreferenceChangeListener {
    public static Class<?> defaultTagAllocatorClass;
    public static Class<?> defaultTSSConstructorClass;
    public static Class<?> defaultProbeAcceptorClass;
    public static Class<?> defaultProbeSelectorClass;
    static Log logger;
    public static final String TARGET_TYPES = "TARGET_TYPES";
    public static final String ANALYSIS_MODULES = "ANALYSIS_MODULES";
    public static final String PROBE_ACCEPTORS = "PROBE_ACCEPTORS";
    public static final String PROBE_SELECTORS = "PROBE_SELECTORS";
    public static final String TSS_CONSTRUCTORS = "TSS_CONSTRUCTORS";
    private static final String[] plugInIdentifiers;
    private static final String[] plugInDescriptions;
    private static final Class<?>[] plugInClasses;
    public static int versionNumber;
    public static String subVersionNumber;
    public static final byte STATE_NO_PROJECT = 0;
    public static final byte STATE_PROJECT_OPEN = 1;
    public static final byte STATE_RUNNING = 2;
    protected static final byte STATE_4 = 3;
    protected static final byte STATE_5 = 4;
    public static final boolean[] ENABLED_NEVER;
    public static final boolean[] ENABLED_WHEN_OPEN;
    public static final boolean[] ENABLED_WHEN_OPEN_NOT_RUNNING;
    public static final boolean[] ENABLED_WHEN_NOT_RUNNING;
    public static final boolean[] ENABLED_ALWAYS;
    static final EntryDescriptor PARAMETER_DIR;
    static final EntryDescriptor DEFAULT_PARAMS_FILE;
    static final EntryDescriptor TEMPLATE_FILE;
    static final EntryDescriptor LOG_DIR;
    static final EntryDescriptor[] USER_ENTRIES;
    protected UserAction newProject;
    protected UserAction openProject;
    protected UserAction importProject;
    protected UserAction saveProject;
    protected UserAction saveProjectAs;
    protected UserAction designProbesReplace;
    protected UserAction designProbesAppend;
    protected UserAction expandTargets;
    protected UserAction importTargets;
    protected UserAction saveTargets;
    protected UserAction reAnalyzeProbes;
    protected UserAction importProbes;
    protected UserAction removeBadProbes;
    protected UserAction exportProbes;
    UserAction[] projectActions;
    UserAction[] targetActions;
    UserAction[] designActions;
    UserAction[] probeActions;
    UserAction[] projectActionsQuickSet;
    protected DataHolder designJobData;
    protected DataHolder importProbesData;
    public static final String PROBEMAKER_MENU_ID;
    File logPath;
    File settingsPath;
    File defaultParamsFile;
    protected Platform platform;
    public Project project = null;
    protected ProjectTemplate template = null;
    protected TemplateManager templateManager;
    protected File projectFile;
    private List<UserAction> actionList;
    protected boolean projectChanged = false;
    private byte currentState = 0;
    Predicate badProbePredicate = new Predicate(){

        public boolean evaluate(Object s) {
            return ProbeMakerPropertyUtils.getRank((Probe)s) == 1;
        }
    };
    Predicate notBadProbePredicate = new Predicate(){

        public boolean evaluate(Object s) {
            return ProbeMakerPropertyUtils.getRank((Probe)s) > 1;
        }
    };
    private List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();

    public static String getBriefDescription() {
        return CoreMessages.getString("ProbeMakerPlugIn.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return CoreMessages.getString("ProbeMakerPlugIn.LONG_DESCRIPTION");
    }

    public void setup(Platform platform) {
        this.platform = platform;
        platform.getPlugInManager().registerPlugInTypes(plugInIdentifiers, (Class[])plugInClasses, plugInDescriptions);
        this.actionList = new ArrayList<UserAction>();
        this.setupActions();
        ActionSet projectaset = new ActionSet(this.projectActions, PROBEMAKER_MENU_ID + "/Project", (ActivePlugIn)this, 100);
        ActionSet targetaset = new ActionSet(this.targetActions, PROBEMAKER_MENU_ID + "/Targets", (ActivePlugIn)this, 200);
        ActionSet designaset = new ActionSet(this.designActions, PROBEMAKER_MENU_ID + "/Design", (ActivePlugIn)this, 300);
        ActionSet probeaset = new ActionSet(this.probeActions, PROBEMAKER_MENU_ID + "/Probes", (ActivePlugIn)this, 400);
        platform.addActionSet(projectaset);
        platform.addActionSet(targetaset);
        platform.addActionSet(designaset);
        platform.addActionSet(probeaset);
        platform.addQuickActionSet(new ActionSet(this.projectActionsQuickSet, "Project", (ActivePlugIn)this, 100));
        platform.addQuickActionSet(designaset);
        this.templateManager = new TemplateManager();
        TemplateXMLHandler tio = new TemplateXMLHandler();
        this.templateManager.setIO(tio);
        this.defaultParamsFile = null;
        this.logPath = new File("");
        platform.addPreferenceEntries(USER_ENTRIES, CoreMessages.getString("ProbeMakerPlugIn.PREF_TITLE"), (PreferenceChangeListener)this);
        this.currentState = 0;
        this.addProjectListener(this);
        this.updateEnabledState();
    }

    public boolean teardown() {
        this.promptAbandonProjectYesNo(CoreMessages.getString("ProbeMakerPlugIn.QUERY_SAVE_ON_EXIT"));
        this.project = null;
        this.fireProjectChange(1);
        this.removeProjectListener(this);
        this.platform.getPlugInManager().unRegisterPlugInTypes(plugInIdentifiers);
        this.platform.removeActionSets((ActivePlugIn)this);
        this.platform.removePreferenceEntries(USER_ENTRIES, CoreMessages.getString("ProbeMakerPlugIn.PREF_TITLE"), (PreferenceChangeListener)this);
        return true;
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(MolToolsWorkbench.class.getName(), "1.0.0");
        return m;
    }

    public UserAction createRegisterAction(String name, String tooltip, ActionListener listener, boolean[] enabledStates) {
        RegisteredAction a = new RegisteredAction(name, tooltip, listener, enabledStates);
        this.actionList.add((UserAction)a);
        a.setEnabled(a.enabledStates[this.currentState]);
        return a;
    }

    private void setupActions() {
        this.newProject = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_NEW_PROJECT"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_NEW_PROJECT"), this, ENABLED_WHEN_NOT_RUNNING);
        this.openProject = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_OPEN_PROJECT"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_OPEN_PROJECT"), this, ENABLED_WHEN_NOT_RUNNING);
        this.importProject = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_IMPORT_PROJECT"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_IMPORT_PROJECT"), this, ENABLED_WHEN_NOT_RUNNING);
        this.saveProject = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_PROJECT"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_SAVE_PROJECT"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.saveProjectAs = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_PROJECT_AS"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_SAVE_PROJECT_AS"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.designProbesReplace = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_DESIGN_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_DESIGN_PROBES"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.designProbesAppend = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_DESIGN_PROBES_APPEND"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_DESIGN_PROBES_APPEND"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.expandTargets = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_EXPAND_TARGETS"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_EXPAND_TARGETS"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.importTargets = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_IMPORT_TARGETS"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_IMPORT_TARGETS"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.saveTargets = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_TARGETS_FASTA"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_SAVE_TARGETS_FASTA"), this, ENABLED_WHEN_OPEN);
        this.reAnalyzeProbes = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_REANALYZE"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_REANALYZE"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.importProbes = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_IMPORT_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_IMPORT"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.removeBadProbes = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_REMOVE_FAILED_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_REMOVE_FAILED_PROBES"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.exportProbes = this.createRegisterAction(CoreMessages.getString("ProbeMakerPlugIn.CAPTION_EXPORT_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_EXPORT_PROBES"), this, ENABLED_WHEN_OPEN_NOT_RUNNING);
        this.projectActions = new UserAction[]{this.newProject, this.openProject, this.importProject, this.saveProject, this.saveProjectAs};
        this.projectActionsQuickSet = new UserAction[]{this.newProject, this.openProject, this.saveProject};
        this.targetActions = new UserAction[]{this.importTargets, this.expandTargets, this.saveTargets};
        this.designActions = new UserAction[]{this.designProbesReplace, this.designProbesAppend};
        this.probeActions = new UserAction[]{this.reAnalyzeProbes, this.removeBadProbes, this.importProbes, this.exportProbes};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object src = e.getSource();
            if (src == this.newProject) {
                this.newProject();
            } else if (src == this.openProject) {
                this.loadProject();
            } else if (src == this.importProject) {
                this.importProject();
            } else if (src == this.saveProject) {
                this.saveProject(false);
            } else if (src == this.saveProjectAs) {
                this.saveProject(true);
            } else if (src == this.designProbesReplace) {
                this.designProbes(false);
            } else if (src == this.designProbesAppend) {
                this.designProbes(true);
            } else if (src == this.expandTargets) {
                TargetHandler.expandTargets(this.project.getTargets());
            } else if (src == this.importTargets) {
                this.importTargets();
            } else if (src == this.saveTargets) {
                this.saveTargets();
            } else if (src == this.reAnalyzeProbes) {
                this.analyzeProbes();
            } else if (src == this.exportProbes) {
                this.exportProbes();
            } else if (src == this.removeBadProbes) {
                String[] options = new String[]{CoreMessages.getString("Common.CAPTION_NO"), CoreMessages.getString("ProbeMakerPlugIn.CAPTION_REMOVE_SUCCESFUL_TARGETS"), CoreMessages.getString("ProbeMakerPlugIn.CAPTION_REMOVE_FAILED_TARGETS")};
                String title = CoreMessages.getString("ProbeMakerPlugIn.TITLE_REMOVING_PROBES");
                String message = CoreMessages.getString("ProbeMakerPlugIn.QUERY_REMOVE_TARGETS");
                OptionDescriptor option = new OptionDescriptor(message, null, "OPTION", options, true);
                DefaultDataHolder dh = new DefaultDataHolder(new DataDescriptor[]{option});
                if (!this.platform.getUI().inputData((DataHolder)dh, title)) {
                    return;
                }
                Integer result = (Integer)dh.getData("OPTION");
                if (result == null) {
                    return;
                }
                switch (result) {
                    case 1: {
                        this.removeTargetsForProbes(this.notBadProbePredicate);
                        break;
                    }
                    case 2: {
                        this.removeTargetsForProbes(this.badProbePredicate);
                        break;
                    }
                }
                this.removeProbes(this.badProbePredicate);
            } else if (src == this.importProbes) {
                this.importProbes();
            }
        }
        catch (Throwable ex) {
            this.platform.handleError(ex.toString(), ex);
        }
    }

    protected void saveTargets() {
        File defaultFile = new File(this.platform.getUI().getCurrentPath(), this.project.getName() + "_targets." + "lib");
        File targetFile = this.platform.getUI().selectSaveFile(ProbeMakerConstants.libFilter, defaultFile, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_TARGET_FILE"), "lib");
        if (targetFile == null) {
            return;
        }
        try {
            FileWriter fout = new FileWriter(targetFile);
            this.exportTargets(fout, (SequenceDBWriter<ProbeMakerTarget>)new FastaDBFormat());
            fout.close();
        }
        catch (IOException ie) {
            this.platform.handleError(CoreMessages.getString("Common.MESSAGE_FILE_WRITE_ERROR"), (Throwable)ie);
        }
    }

    public void loadTargets(File[] targetFiles, TargetInputFormat<?> tif) {
        this.project.getTargets().clear();
        Reader[] ins = new Reader[targetFiles.length];
        for (int i = 0; i < targetFiles.length; ++i) {
            try {
                ins[i] = new FileReader(targetFiles[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                this.platform.handleError(e.toString(), (Throwable)e);
                ins[i] = null;
            }
        }
        TargetIOTask targetIOtask = new TargetIOTask(this.project, (ErrorHandler)this.platform, ins, tif);
        this.platform.runTask((Task)targetIOtask);
    }

    protected void importTargets() {
        DefaultTargetInputFormat tif;
        block15: {
            tif = null;
            Class<?> targetClass = null;
            Transformer conv = null;
            SequenceDBBuilder dbBuilder = null;
            try {
                if (this.template == null) {
                    Object plugin = this.platform.getUI().selectPlugIn(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_TARGET_TYPE"), TARGET_TYPES);
                    if (plugin == null) {
                        return;
                    }
                    targetClass = plugin.getClass();
                    SequenceBuilder seqBuilder = (SequenceBuilder)targetClass.getMethod("getSequenceBuilder", null).invoke(null, (Object[])null);
                    SequenceDBDataReader format = (SequenceDBDataReader)this.platform.getUI().selectPlugIn(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_FILE_FORMAT"), "INPUT_FORMATS");
                    if (format == null) {
                        return;
                    }
                    conv = (Transformer)this.platform.getUI().selectPlugIn(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_CONVERTER_HTML"), "CONVERTERS");
                    dbBuilder = (SequenceDBBuilder)this.platform.getUI().selectPlugIn(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_DBBUILDER_HTML"), "DB_BUILDERS");
                    tif = new DefaultTargetInputFormat("Custom", format, conv, seqBuilder, dbBuilder);
                    break block15;
                }
                String name = this.template.getName();
                targetClass = Class.forName(this.template.getTargetClassName());
                SequenceBuilder seqBuilder = (SequenceBuilder)targetClass.getMethod("getSequenceBuilder", null).invoke(null, (Object[])null);
                SequenceDBDataReader format = (SequenceDBDataReader)Class.forName(this.template.getFormatClassName()).newInstance();
                try {
                    conv = (Transformer)Class.forName(this.template.getConverterClassName()).newInstance();
                }
                catch (ClassNotFoundException c) {
                    // empty catch block
                }
                try {
                    dbBuilder = (SequenceDBBuilder)Class.forName(this.template.getDbBuilderClassName()).newInstance();
                }
                catch (ClassNotFoundException c) {
                    // empty catch block
                }
                tif = new DefaultTargetInputFormat(name, format, conv, seqBuilder, dbBuilder);
            }
            catch (IllegalAccessException e) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_PLUG_IN_NOT_ACCESSED"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_ERROR_INVOKING_SEQBUILDER"), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SEQBUILDER_NOT_FOUND"), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_PLUG_IN_NOT_CREATED"), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_PLUG_IN_NOT_FOUND") + (targetClass == null ? "" : targetClass.getName()), (Throwable)e);
            }
        }
        if (tif == null) {
            return;
        }
        File[] targetFiles = this.platform.getUI().selectFiles(null, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_OPEN_TARGET_FILES"));
        if (targetFiles == null) {
            return;
        }
        this.loadTargets(targetFiles, tif);
    }

    protected void exportTargets(Writer out, SequenceDBWriter<ProbeMakerTarget> format) throws IOException {
        SequenceIO.writeSequenceDB((Writer)out, this.project.getTargets(), format, null);
    }

    protected void importProbes() {
        ArrayList formatClasses;
        File probeFile = this.platform.getUI().selectFile(null, null, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_OPEN_PROBE_FILE"));
        if (probeFile == null) {
            return;
        }
        try {
            formatClasses = new ArrayList(this.platform.getPlugInManager().getPlugInList("INPUT_FORMATS"));
        }
        catch (PlugInException e1) {
            this.platform.handleError(e1.toString(), (Throwable)e1);
            return;
        }
        PlugInClassListSelectionDescriptor formatDesc = new PlugInClassListSelectionDescriptor(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_INPUT_FORMAT"), CoreMessages.getString("ProbeMakerPlugIn.TOOL_TIP_SELECT_INPUT_FORMAT"), "FORMAT", formatClasses, true);
        BooleanDescriptor replaceDesc = new BooleanDescriptor(CoreMessages.getString("ProbeMakerPlugIn.NAME_REPLACE_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_REPLACE_PROBES"), "REPLACE");
        if (this.importProbesData == null) {
            this.importProbesData = new DefaultDataHolder(new DataDescriptor[]{formatDesc, replaceDesc});
        }
        if (!this.platform.getUI().inputData(this.importProbesData, CoreMessages.getString("ProbeMakerPlugIn.TITLE_IMPORT_PROBES"))) {
            return;
        }
        Class formatClass = (Class)this.importProbesData.getData("FORMAT");
        SequenceDBDataReader format = null;
        try {
            format = (SequenceDBDataReader)formatClass.newInstance();
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
            return;
        }
        Boolean replaceO = (Boolean)this.importProbesData.getData("REPLACE");
        boolean replace = replaceO;
        try {
            this.importProbes(replace, new FileReader(probeFile), format);
        }
        catch (Exception e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
    }

    protected void exportProbes() {
        if (this.project.getProbes().isEmpty()) {
            this.platform.getUI().sendMessage(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_NO_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_EXPORT_PROBES"), (byte)0);
            return;
        }
        Object plugin = this.platform.getUI().selectPlugIn(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_SELECT_OUTPUT_FORMAT"), "OUTPUT_FORMATS");
        if (plugin == null) {
            return;
        }
        SequenceDBWriter pof = (SequenceDBWriter)plugin;
        File defaultFile = new File(this.platform.getUI().getCurrentPath(), this.project.getName() + "_out");
        File probeFile = this.platform.getUI().selectSaveFile(null, defaultFile, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_PROBE_FILE"), null);
        if (probeFile == null) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(probeFile);
            this.saveProbes(fw, (SequenceDBWriter<Probe>)pof);
            fw.close();
        }
        catch (IOException fnfx) {
            this.platform.handleError(CoreMessages.getString("Common.MESSAGE_FILE_WRITE_ERROR"), (Throwable)fnfx);
        }
    }

    public void importProbes(boolean replace, Reader in, SequenceDBDataReader formatter) throws IOException, SequenceFormatException, DuplicateIDException {
        if (replace) {
            this.project.getProbes().clear();
            this.project.getTagAllocationTable().clear();
        }
        this.project.getProbes().addSequences((Collection)SequenceIO.readSequences((Reader)in, (SequenceDBDataReader)formatter, DefaultProbe.getSequenceBuilder()));
    }

    public void saveProbes(Writer out, SequenceDBWriter<Probe> writer) throws IOException {
        SequenceIO.writeSequenceDB((Writer)out, this.project.getProbes(), writer, null);
    }

    public void designProbes(boolean append) {
        ArrayList constructorClasses;
        ArrayList selectorClasses;
        ArrayList acceptorClasses;
        if (this.project == null) {
            this.platform.getUI().sendMessage(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_NO_PROJECT_OPEN"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_DESIGN_PROBES"), (byte)0);
            return;
        }
        this.fireProjectChange(2);
        if (!append && !this.project.getProbes().isEmpty() && this.platform.getUI().sendMessage(CoreMessages.getString("ProbeMakerPlugIn.QUERY_DELETE_EARLIER_PROBES"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_DESIGN_PROBES"), (byte)1) == 0) {
            return;
        }
        if (this.project.getTargets().isEmpty()) {
            this.platform.getUI().sendMessage(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_NO_TARGETS"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_DESIGN_PROBES"), (byte)0);
            return;
        }
        try {
            acceptorClasses = new ArrayList(this.platform.getPlugInManager().getPlugInList(PROBE_ACCEPTORS));
        }
        catch (PlugInException e1) {
            this.platform.handleError(e1.toString(), (Throwable)e1);
            return;
        }
        try {
            selectorClasses = new ArrayList(this.platform.getPlugInManager().getPlugInList(PROBE_SELECTORS));
        }
        catch (PlugInException e1) {
            this.platform.handleError(e1.toString(), (Throwable)e1);
            return;
        }
        try {
            constructorClasses = new ArrayList(this.platform.getPlugInManager().getPlugInList(TSS_CONSTRUCTORS));
        }
        catch (PlugInException e1) {
            this.platform.handleError(e1.toString(), (Throwable)e1);
            return;
        }
        PlugInClassListSelectionDescriptor acceptorDesc = new PlugInClassListSelectionDescriptor(CoreMessages.getString("DesignJobDialog.CAPTION_CHOOSE_ACCEPTOR"), null, "ACCEPTOR", acceptorClasses, true);
        PlugInClassListSelectionDescriptor selectorDesc = new PlugInClassListSelectionDescriptor(CoreMessages.getString("DesignJobDialog.CAPTION_CHOOSE_SELECTOR"), null, "SELECTOR", selectorClasses, true);
        PlugInClassListSelectionDescriptor constructorDesc = new PlugInClassListSelectionDescriptor(CoreMessages.getString("ProbeMakerPlugIn.NAME_CHOOSE_TSSCON"), null, "CONSTRUCTOR", constructorClasses, true);
        BooleanDescriptor resetTagsDesc = new BooleanDescriptor(CoreMessages.getString("DesignJobDialog.CAPTION_RESET_TAG_LIBRARIES"), null, "RESET_TAGS");
        this.designJobData = this.designJobData == null ? new DefaultDataHolder(new DataDescriptor[]{acceptorDesc, selectorDesc, constructorDesc, resetTagsDesc}) : new DefaultDataHolder(new DataDescriptor[]{acceptorDesc, selectorDesc, constructorDesc, resetTagsDesc}, this.designJobData.getData());
        if (!this.platform.getUI().inputData(this.designJobData, CoreMessages.getString("DesignJobDialog.TITLE_NEW_DESIGN_JOB"))) {
            return;
        }
        Class acceptorClass = (Class)this.designJobData.getData("ACCEPTOR");
        Class selectorClass = (Class)this.designJobData.getData("SELECTOR");
        Class constructorClass = (Class)this.designJobData.getData("CONSTRUCTOR");
        Boolean resetTags = (Boolean)this.designJobData.getData("RESET_TAGS");
        if (acceptorClass == null || selectorClass == null || constructorClass == null) {
            return;
        }
        ProbeAcceptor acceptor = null;
        ProbeSelector selector = null;
        TSSConstructor con = null;
        TagAllocator ta = null;
        try {
            acceptor = (ProbeAcceptor)acceptorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        try {
            selector = (ProbeSelector)selectorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        try {
            con = (TSSConstructor)constructorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        try {
            ta = (TagAllocator)defaultTagAllocatorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.getMessage(), (Throwable)e);
        }
        if (acceptor == null || selector == null) {
            return;
        }
        if (acceptor instanceof ParameterPlugIn && !this.platform.getUI().inputData((DataHolder)((ParameterPlugIn)acceptor), CoreMessages.getString("ProbeMakerPlugIn.TITLE_ACCEPTOR_SETTINGS"))) {
            return;
        }
        if (selector instanceof ParameterPlugIn && this.platform.getUI().inputData((DataHolder)((ParameterPlugIn)selector), CoreMessages.getString("ProbeMakerPlugIn.TITLE_SELECTOR_SETTINGS"))) {
            return;
        }
        if (con instanceof ParameterPlugIn && this.platform.getUI().inputData((DataHolder)((ParameterPlugIn)con), CoreMessages.getString("ProbeMakerPlugIn.TITLE_TSSCON_SETTINGS"))) {
            return;
        }
        if (ta instanceof ParameterPlugIn && this.platform.getUI().inputData((DataHolder)((ParameterPlugIn)ta), CoreMessages.getString("ProbeMakerPlugIn.TITLE_TAGALLOC_SETTINGS"))) {
            return;
        }
        DefaultProbeDesigner designer = new DefaultProbeDesigner(ta);
        boolean useLog = true;
        ProbeDesignTask designTask = this.getProbeDesignTask(append, resetTags, true, acceptor, selector, designer, con, (ErrorHandler)this.platform);
        this.fireProjectChange(3);
        this.platform.runTask((Task)designTask);
        DecimalFormat format = new DecimalFormat("#0");
        String s1 = CoreMessages.getString("ProbeMakerPlugIn.TEXT_DESIGN_FINISH_TIME") + (designTask.getTotalTime() < 1000L ? CoreMessages.getString("ProbeMakerPlugIn.TEXT_DESIGN_TIME_LESS_THAN_SECOND") : format.format(designTask.getTotalTime() / 1000L) + CoreMessages.getString("ProbeMakerPlugIn.TEXT_DESIGN_TIME_SECONDS"));
        String s2 = designTask.getCandidatesGenerated() + CoreMessages.getString("ProbeMakerPlugIn.TEXT_CANDIDATES_GENERATED");
        this.platform.getUI().sendMessage(s1 + "\n" + s2, CoreMessages.getString("ProbeMakerPlugIn.TITLE_DESIGN_PROBES"), (byte)0);
        this.fireProjectChange(4);
    }

    protected void analyzeProbes() {
        ProbeAnalysisTask analysisTask = this.getProbeAnalysisTask((ErrorHandler)this.platform);
        this.platform.runTask((Task)analysisTask);
        this.fireProjectChange(4);
    }

    public void removeProbes(Predicate p) {
        Collection removeProbes = CollectionUtils.select((Collection)this.project.getProbes().getSequenceList(), (Predicate)p);
        Iterator i = removeProbes.iterator();
        while (i.hasNext()) {
            this.project.getProbes().removeSequenceByID(((Probe)i.next()).getID());
        }
    }

    public void removeTargetsForProbes(Predicate p) {
        Collection removeProbes = CollectionUtils.select((Collection)this.project.getProbes().getSequenceList(), (Predicate)p);
        Iterator i = removeProbes.iterator();
        while (i.hasNext()) {
            this.project.getTargets().removeSequenceByID(((Probe)i.next()).getTarget().getID());
        }
    }

    private void promptAbandonProjectYesNo(String message) {
        if (this.projectChanged) {
            switch (this.platform.getUI().sendMessage(message, CoreMessages.getString("ProbeMakerPlugIn.TITLE_SAVE_CHANGES"), (byte)1)) {
                case 1: {
                    this.saveProject(false);
                    break;
                }
            }
        }
    }

    private boolean promptAbandonProjectYesNoCancel(String message) {
        if (this.projectChanged) {
            switch (this.platform.getUI().sendMessage(message, CoreMessages.getString("ProbeMakerPlugIn.TITLE_SAVE_CHANGES"), (byte)2)) {
                case 1: {
                    this.saveProject(false);
                    return true;
                }
                case 0: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    private void newProject() {
        boolean use;
        if (!this.promptAbandonProjectYesNoCancel(CoreMessages.getString("ProbeMakerPlugIn.QUERY_SAVE_PROJECT"))) {
            return;
        }
        String useToolTip = "<html>" + CoreMessages.getString("NewProjectDialog.TEXT_INFO_HTML") + "</html>";
        StringDataDescriptor projectName = new StringDataDescriptor(CoreMessages.getString("ProbeMakerPlugIn.NAME_PROJECT_NAME"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_PROJECT_NAME"), "PROJECT_NAME", true);
        BooleanDescriptor useTemplate = new BooleanDescriptor(CoreMessages.getString("ProbeMakerPlugIn.NAME_USE_TEMPLATE"), useToolTip, "USE_TEMPLATE");
        TemplateListSelectionDescriptor templateSel = new TemplateListSelectionDescriptor(null, null, "TEMPLATE", this.templateManager.getTemplateArray(), false);
        DefaultDataHolder newProjectData = new DefaultDataHolder(new DataDescriptor[]{projectName, useTemplate, templateSel});
        if (!this.platform.getUI().inputData((DataHolder)newProjectData, CoreMessages.getString("NewProjectDialog.TITLE_NEW_PROJECT"))) {
            return;
        }
        String name = (String)newProjectData.getData("PROJECT_NAME");
        if (name == null) {
            return;
        }
        if (name.length() == 0) {
            name = CoreMessages.getString("ProbeMakerPlugIn.NAME_NEW_PROJECT");
        }
        if (use = ((Boolean)newProjectData.getData("USE_TEMPLATE")).booleanValue()) {
            byte result;
            this.template = (ProjectTemplate)newProjectData.getData("TEMPLATE");
            if (this.template == null && (result = this.platform.getUI().sendMessage(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_NO_TEMPLATE"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_NEW_PROJECT"), (byte)1)) == 0) {
                return;
            }
        } else {
            this.template = null;
        }
        Settings s = new Settings();
        if (this.defaultParamsFile != null) {
            try {
                FileReader in = new FileReader(this.defaultParamsFile);
                s = SettingsIO.inputSettings(in);
                ((Reader)in).close();
            }
            catch (Exception iox) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_DEFAULT_SETTINGS_NOT_READ"), (Throwable)iox);
            }
        }
        Project newp = new Project(name);
        newp.setSettings(s);
        if (this.template != null) {
            String fileName = this.template.getSettingsFileName();
            if (fileName == null || fileName.length() == 0) {
                this.platform.getUI().sendMessage("No settings file set for this template. Using default settings.", "No settings file", (byte)0);
            } else {
                File f = new File(fileName);
                try {
                    FileReader in = new FileReader(f);
                    newp.setSettings(SettingsIO.inputSettings(in));
                }
                catch (FileNotFoundException e) {
                    this.platform.handleError("Template settings file not found: " + f.getAbsolutePath(), (Throwable)e);
                }
                catch (Exception e) {
                    this.platform.handleError("Template settings file input error: " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        this.projectFile = null;
        this.setProject(newp);
    }

    private void loadProject() {
        if (!this.promptAbandonProjectYesNoCancel(CoreMessages.getString("ProbeMakerPlugIn.QUERY_SAVE_PROJECT"))) {
            return;
        }
        File pFile = this.platform.getUI().selectFile(prxFilter, null, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_OPEN_PROJECT_FILE"));
        if (pFile == null) {
            return;
        }
        FileReader in = null;
        try {
            in = new FileReader(pFile);
        }
        catch (FileNotFoundException e) {
            this.platform.handleError(CoreMessages.getString(pFile.getName() + "Common.MESSAGE_FILE_NOT_FOUND") + "\n" + e.toString(), (Throwable)e);
            return;
        }
        ProjectInputErrorCallback ecb = new ProjectInputErrorCallback(this.platform);
        Task IOtask = this.getLoadProjectTask(in, ecb);
        this.platform.runTask(IOtask);
        this.projectFile = pFile;
    }

    private void importProject() {
        if (!this.promptAbandonProjectYesNoCancel(CoreMessages.getString("ProbeMakerPlugIn.QUERY_SAVE_PROJECT"))) {
            return;
        }
        File pFile = this.platform.getUI().selectFile(pmpFilter, null, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_IMPORT_PROJECT_FILE"));
        if (pFile == null) {
            return;
        }
        FileReader in = null;
        try {
            in = new FileReader(pFile);
        }
        catch (FileNotFoundException e) {
            this.platform.handleError(CoreMessages.getString(pFile.getName() + "Common.MESSAGE_FILE_NOT_FOUND") + "\n" + e.toString(), (Throwable)e);
            return;
        }
        ProjectInputErrorCallback ecb = new ProjectInputErrorCallback(this.platform);
        Task IOtask = this.getImportProjectTask(in, ecb);
        this.platform.runTask(IOtask);
        this.projectFile = pFile;
    }

    protected void saveProject(Writer out) {
        ProjectInputErrorCallback ecb = new ProjectInputErrorCallback(this.platform);
        Task IOtask = this.getExportProjectTask(out, ecb);
        this.platform.runTask(IOtask);
    }

    protected boolean saveProject(boolean saveAs) {
        FileWriter fout = null;
        if (!saveAs && this.projectFile != null && this.projectFile.exists()) {
            try {
                fout = new FileWriter(this.projectFile);
            }
            catch (IOException fnfx) {
                this.platform.handleError(CoreMessages.getString("ProbeMakerPlugIn.TITLE_SAVE_PROJECT"), (Throwable)fnfx);
                return false;
            }
        }
        if (fout == null) {
            File defaultFile = this.projectFile == null ? new File(this.platform.getUI().getCurrentPath(), this.project.getName() + "." + "prx") : this.projectFile;
            File pFile = this.platform.getUI().selectSaveFile(prxFilter, defaultFile, CoreMessages.getString("ProbeMakerPlugIn.CAPTION_SAVE_PROJECT_FILE"), "prx");
            if (pFile == null) {
                return false;
            }
            try {
                fout = new FileWriter(pFile);
                this.projectFile = pFile;
            }
            catch (FileNotFoundException fnfx) {
                this.platform.handleError("", (Throwable)fnfx);
                return false;
            }
            catch (IOException e) {
                this.platform.handleError("", (Throwable)e);
                return false;
            }
        }
        this.saveProject(fout);
        return true;
    }

    public void addAction(UserAction a) {
        this.actionList.add(a);
        if (a instanceof RegisteredAction) {
            a.setEnabled(((RegisteredAction)a).enabledStates[this.currentState]);
        }
    }

    public void removeAction(UserAction ra) {
        this.actionList.remove(ra);
    }

    public void addProjectListener(ProjectListener l) {
        this.projectListeners.add(l);
    }

    public void removeProjectListener(ProjectListener l) {
        this.projectListeners.remove(l);
    }

    void fireProjectChange(int type) {
        for (ProjectListener pl : this.projectListeners) {
            pl.projectStateChanged(this.project, type);
        }
    }

    private void updateEnabledState() {
        for (UserAction o : this.actionList) {
            if (!(o instanceof RegisteredAction)) continue;
            RegisteredAction a = (RegisteredAction)o;
            a.setEnabled(a.enabledStates[this.currentState]);
        }
    }

    @Override
    public void projectStateChanged(Project p, int type) {
        switch (type) {
            case 0: {
                this.currentState = 1;
                this.projectChanged = true;
                break;
            }
            case 1: {
                this.currentState = 0;
                this.projectChanged = false;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.currentState = (byte)2;
                break;
            }
            case 4: {
                this.currentState = 1;
            }
        }
        this.updateEnabledState();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project p) {
        this.project = p;
        if (this.project == null) {
            this.fireProjectChange(1);
        } else {
            this.fireProjectChange(0);
        }
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public ProjectTemplate getTemplate() {
        return this.template;
    }

    public ProbeDesignTask getProbeDesignTask(boolean append, boolean resetTags, boolean useLog, ProbeAcceptor acc, ProbeSelector sel, ProbeDesigner designer, TSSConstructor con, ErrorHandler ecb) {
        if (resetTags) {
            this.project.getTagAllocationTable().clearUsed();
        }
        return new ProbeDesignTask(this.project, useLog ? this.logPath : null, acc, sel, designer, con, ecb);
    }

    protected ProbeAnalysisTask getProbeAnalysisTask(ErrorHandler ecb) {
        try {
            return new ProbeAnalysisTask(this.project, ecb);
        }
        catch (InstantiationException e) {
            this.platform.handleError(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError(e.toString(), (Throwable)e);
        }
        return null;
    }

    protected Task getExportProjectTask(Writer out, ErrorHandler ecb) {
        return new ProjectXMLIOTask((ProjectHolder)this, ecb, out);
    }

    protected Task getImportProjectTask(Reader in, ErrorHandler ecb) {
        return new ProjectIOTask((ProjectHolder)this, ecb, in);
    }

    protected Task getLoadProjectTask(Reader in, ErrorHandler ecb) {
        return new ProjectXMLIOTask((ProjectHolder)this, ecb, in);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        if (evt.getNode().isUserNode() && key.equals(TEMPLATE_FILE.getKey())) {
            this.setTemplateFile(evt.getNewValue());
        } else if (evt.getNode().isUserNode() && key.equals(PARAMETER_DIR.getKey())) {
            this.setParameterDir(evt.getNewValue());
        } else if (evt.getNode().isUserNode() && key.equals(DEFAULT_PARAMS_FILE.getKey())) {
            this.setDefaultParamsFile(evt.getNewValue());
        } else if (evt.getNode().isUserNode() && key.equals(LOG_DIR.getKey())) {
            this.setLogDir(evt.getNewValue());
        }
    }

    private void setTemplateFile(String fileName) {
        File templateFile = fileName == "" ? null : new File(fileName);
        this.templateManager.setFile(templateFile);
        try {
            this.templateManager.loadTemplates();
        }
        catch (Exception e) {
            this.platform.handleError("Could not load Project templates\n" + e.toString(), (Throwable)e);
        }
    }

    private void setParameterDir(String fileName) {
        this.settingsPath = fileName == "" ? null : new File(fileName);
    }

    private void setDefaultParamsFile(String fileName) {
        String name = fileName == "" ? DEFAULT_PARAMS_FILE.getDefault() : fileName;
        this.defaultParamsFile = name == "" ? null : new File(name);
    }

    public void setLogDir(String fileName) {
        this.logPath = new File(fileName == "" ? LOG_DIR.getDefault() : fileName);
    }

    public String getVersion() {
        return "1.3.1";
    }

    public File getDefaultParametersFile() {
        return this.defaultParamsFile;
    }

    static {
        ResourceBundle rb;
        logger = LogFactory.getLog(ProbeMakerPlugIn.class);
        try {
            rb = ResourceBundle.getBundle("probemaker");
        }
        catch (MissingResourceException mrx) {
            logger.warn((Object)mrx);
            rb = new ListResourceBundle(){

                protected Object[][] getContents() {
                    return new Object[][]{{"probemaker.defaultTSSConstructorClass", "org.moltools.apps.probemaker.ext.tc.DefaultTSSConstructor"}, {"probemaker.defaultTagAllocatorClass", "org.moltools.apps.probemaker.ext.ta.GreedyTagAllocator"}, {"probemaker.defaultProbeAcceptorClass", "org.moltools.apps.probemaker.ext.acc.GoodFairAcceptor"}, {"probemaker.defaultProbeSelectorClass", "org.moltools.apps.probemaker.ext.sel.BestQualitySelector"}};
                }
            };
        }
        try {
            defaultTagAllocatorClass = Class.forName(rb.getString("probemaker.defaultTagAllocatorClass"));
            defaultTSSConstructorClass = Class.forName(rb.getString("probemaker.defaultTSSConstructorClass"));
            defaultProbeAcceptorClass = Class.forName(rb.getString("probemaker.defaultProbeAcceptorClass"));
            defaultProbeSelectorClass = Class.forName(rb.getString("probemaker.defaultProbeSelectorClass"));
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e);
        }
        plugInIdentifiers = new String[]{TARGET_TYPES, ANALYSIS_MODULES, PROBE_ACCEPTORS, PROBE_SELECTORS, TSS_CONSTRUCTORS};
        plugInDescriptions = new String[]{CoreMessages.getString("ProbeMakerPlugIn.DESCRIPTION_TARGET_TYPES"), CoreMessages.getString("ProbeMakerPlugIn.DESCRIPTION_MODULES"), CoreMessages.getString("ProbeMakerPlugIn.DESCRIPTION_ACCEPTORS"), CoreMessages.getString("ProbeMakerPlugIn.DESCRIPTION_SELECTORS"), "TSS constructors"};
        plugInClasses = new Class[]{ProbeMakerTarget.class, ProbeAnalysisModule.class, ProbeAcceptor.class, ProbeSelector.class, TSSConstructor.class};
        versionNumber = 1;
        subVersionNumber = "5.0";
        ENABLED_NEVER = new boolean[]{false, false, false, false, false};
        ENABLED_WHEN_OPEN = new boolean[]{false, true, true, true, true};
        ENABLED_WHEN_OPEN_NOT_RUNNING = new boolean[]{false, true, false, true, true};
        ENABLED_WHEN_NOT_RUNNING = new boolean[]{true, true, false, true, true};
        ENABLED_ALWAYS = new boolean[]{true, true, true, true, true};
        PARAMETER_DIR = new FileEntryDescriptor("Settings directory", CoreMessages.getString("ProbeMakerPlugIn.PREF_SETTINGS_PATH"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_SETTINGS_PATH"), "probemaker/settings", 1, true);
        DEFAULT_PARAMS_FILE = new FileEntryDescriptor("Default settings file", CoreMessages.getString("ProbeMakerPlugIn.PREF_SETTINGS_FILE"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_SETTINGS_FILE"), "probemaker/settings/defaultsettings.xml", 1, false);
        TEMPLATE_FILE = new FileEntryDescriptor("Project template file", CoreMessages.getString("ProbeMakerPlugIn.PREF_TEMPLATE_FILE"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_TEMPLATE_FILE"), "probemaker/settings/templates.xml", 1, false);
        LOG_DIR = new FileEntryDescriptor("Log directory", CoreMessages.getString("ProbeMakerPlugIn.PREF_LOG_PATH"), CoreMessages.getString("ProbeMakerPlugIn.TOOLTIP_LOG_PATH"), "probemaker/log/", 1, true);
        USER_ENTRIES = new EntryDescriptor[]{PARAMETER_DIR, DEFAULT_PARAMS_FILE, TEMPLATE_FILE, LOG_DIR};
        PROBEMAKER_MENU_ID = CoreMessages.getString("ProbeMakerPlugIn.MENU_ID");
    }
}

