/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.design.TagAllocationTable;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSelector {
    static Log log = LogFactory.getLog(TagSelector.class);
    private boolean skipbad = true;
    private Collection<Integer>[] badTags;
    private TagLibrary[] taglibraries;
    private TagAllocationTable tagAllocationTable;
    private int[] tagIndices;

    public TagSelector(TagAllocationTable tat, TagLibrary[] tagLibs) {
        this.taglibraries = tagLibs;
        this.tagAllocationTable = tat;
    }

    public void setBadTags(Collection<Integer>[] badTagsCurrent) {
        this.badTags = badTagsCurrent;
    }

    public NucleotideSequence[] getNextValidCombination(PropertyHolder p) {
        do {
            this.tagIndices = this.getNextCombination(0, this.tagIndices);
            if (this.tagIndices != null) continue;
            return null;
        } while (!this.isValidCombination(this.tagIndices, p));
        NucleotideSequence[] tags = new NucleotideSequence[this.tagIndices.length];
        for (int pos = 0; pos < tags.length; ++pos) {
            tags[pos] = (NucleotideSequence)this.taglibraries[pos].getSequenceAt(this.tagIndices[pos]);
        }
        return tags;
    }

    protected int[] getNextCombination(int pos, int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Can't get next combination from null");
        }
        if (indices.length == 0) {
            return null;
        }
        if (pos >= this.taglibraries.length - 1) {
            boolean done = false;
            while (!done) {
                int n = pos;
                indices[n] = indices[n] + 1;
                if (indices[pos] >= this.taglibraries[pos].size()) {
                    indices[pos] = -1;
                    return null;
                }
                done = true;
            }
            return indices;
        }
        int[] next = null;
        boolean done = false;
        TagLibrary lib = this.taglibraries[pos];
        while (!done) {
            next = this.getNextCombination(pos + 1, indices);
            if (next != null) {
                return next;
            }
            int n = pos;
            indices[n] = indices[n] + 1;
            if (indices[pos] < lib.size()) continue;
            indices[pos] = 0;
            done = true;
        }
        return null;
    }

    protected boolean isValidInPos(int index, int pos, PropertyHolder p) {
        if (!this.tagAllocationTable.isUsable(pos, index, DesignUtils.getGroupWithType((PropertyHolder)p, (String)"probeGroup"))) {
            log.debug((Object)("Tag " + index + " not usable at " + pos));
            return false;
        }
        if (this.skipbad) {
            for (int i : this.badTags[pos]) {
                if (i != index) continue;
                log.debug((Object)("Tag " + index + " bad"));
                return false;
            }
        }
        return true;
    }

    public boolean isValidCombination(int[] combination, PropertyHolder p) {
        for (int i = 0; i < combination.length; ++i) {
            if (this.isValidInPos(combination[i], i, p)) continue;
            return false;
        }
        byte[] libmodes = new byte[this.taglibraries.length];
        for (int lib = 0; lib < libmodes.length; ++lib) {
            libmodes[lib] = this.taglibraries[lib].getMode();
        }
        boolean[] allowed = new boolean[this.taglibraries.length];
        for (int lib = 0; lib < allowed.length; ++lib) {
            allowed[lib] = libmodes[lib] == 2;
        }
        for (int pos = 0; pos < combination.length; ++pos) {
            Sequence tag1 = this.taglibraries[pos].getSequenceAt(combination[pos]);
            for (int pos2 = 0; pos2 < combination.length; ++pos2) {
                Sequence tag2 = this.taglibraries[pos2].getSequenceAt(combination[pos2]);
                if (!tag1.equals(tag2) || pos == pos2 || allowed[pos] && allowed[pos2]) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getTagIndices() {
        return this.tagIndices;
    }

    public void setTagIndices(int[] comb) {
        this.tagIndices = comb;
    }
}

