/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.moltools.apps.probemaker.seq.impl.InDel;
import org.moltools.apps.probemaker.seq.impl.SNP;
import org.moltools.design.data.SequenceElementContainer;
import org.moltools.lib.AbstractReidentifiable;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.SequenceElement;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.SequenceStringElement;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariationSequenceElementContainer
extends AbstractReidentifiable
implements Renameable,
SequenceElementContainer,
ChangeableNucleotideSequence {
    public static final char variantSeparator = '/';
    public static final char inDelBeginSymbol = '[';
    public static final char inDelEndSymbol = ']';
    protected List<SequenceElement> sequence = new ArrayList<SequenceElement>();
    protected String description = "";
    protected byte type;
    private String sequenceRepr;
    private boolean seqDirty;

    public VariationSequenceElementContainer(String id, byte type) {
        super(id);
        this.type = type;
        this.setSequenceRepr("");
    }

    public static String sequenceOf(List<SequenceElement> elements) {
        String sequenceString = "";
        for (SequenceStringElement sequenceStringElement : elements) {
            sequenceString = sequenceString + sequenceStringElement.seqString();
        }
        return sequenceString;
    }

    public String parse(String seq, byte acidType, List<SequenceElement> elements) throws SequenceFormatException {
        elements.clear();
        Stack<VariationSequenceElementContainer> elementStack = new Stack<VariationSequenceElementContainer>();
        VariationSequenceElementContainer root = new VariationSequenceElementContainer("", acidType);
        elementStack.push(root);
        boolean inSNP = false;
        int SNPno = 0;
        int InDelno = 0;
        Stack<Nucleotide> SNPNucleotides = new Stack<Nucleotide>();
        char previous = ' ';
        char current = ' ';
        for (int pos = 0; pos < seq.length(); ++pos) {
            SequenceElementContainer e;
            if (pos > 0) {
                previous = seq.charAt(pos - 1);
            }
            if ((current = (char)seq.charAt(pos)) == '/') {
                Nucleotide nextnt;
                try {
                    nextnt = NucleotideSequenceHandler.getNucleotide((char)seq.charAt(pos + 1), (byte)acidType);
                }
                catch (StringIndexOutOfBoundsException sx) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + (pos + 2));
                }
                Nucleotide prevnt = NucleotideSequenceHandler.getNucleotide((char)previous, (byte)acidType);
                if (prevnt == null) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + pos);
                }
                if (nextnt == null) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + (pos + 2));
                }
                if (inSNP) {
                    SNPNucleotides.push(nextnt);
                } else {
                    SNPNucleotides.push(prevnt);
                    SNPNucleotides.push(nextnt);
                    inSNP = true;
                    SequenceElementContainer e2 = (SequenceElementContainer)elementStack.peek();
                    e2.removeFromEnd();
                }
                ++pos;
                int next = 32;
                try {
                    next = seq.charAt(pos + 1);
                }
                catch (StringIndexOutOfBoundsException sx2) {
                    sx2.printStackTrace();
                }
                if (next == 47) continue;
                Nucleotide[] nucs = new Nucleotide[SNPNucleotides.size()];
                for (int i = 0; i < nucs.length; ++i) {
                    nucs[i] = (Nucleotide)SNPNucleotides.pop();
                }
                SNP snp = new SNP(nucs, "SNP " + ++SNPno);
                SequenceElementContainer e3 = (SequenceElementContainer)elementStack.peek();
                e3.addToEnd((SequenceElement)snp);
                inSNP = false;
                continue;
            }
            if (current == '[') {
                elementStack.push(new InDel("InDel " + ++InDelno, "", "InDel " + ++InDelno, acidType));
                continue;
            }
            if (current == ']') {
                if (elementStack.size() < 2) {
                    throw new IllegalArgumentException("Too many InDel end symbols");
                }
                InDel indel = (InDel)elementStack.pop();
                e = (SequenceElementContainer)elementStack.peek();
                e.addToEnd((SequenceElement)indel);
                continue;
            }
            Nucleotide n = NucleotideSequenceHandler.getNucleotide((char)current, (byte)acidType);
            if (n == null) {
                throw new IllegalArgumentException("Invalid symbol encountered during sequence parsing: " + current);
            }
            if (NucleotideSequenceHandler.isPoly((Nucleotide)n)) {
                SNP snp = new SNP(((DegenerateNucleotide)n).getPossible(), "SNP" + ++SNPno);
                SequenceElementContainer e4 = (SequenceElementContainer)elementStack.peek();
                e4.addToEnd((SequenceElement)snp);
                continue;
            }
            e = (SequenceElementContainer)elementStack.peek();
            e.addToEnd((SequenceElement)n);
        }
        elements.addAll(root.getElements());
        return VariationSequenceElementContainer.sequenceOf(elements);
    }

    public String seqString() {
        if (this.seqDirty) {
            this.setSequenceRepr(VariationSequenceElementContainer.sequenceOf(this.sequence));
        }
        return this.sequenceRepr;
    }

    public String getName() {
        return this.description;
    }

    public byte getType() {
        return this.type;
    }

    public String subsequence(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException("Start index out of bounds");
        }
        if (end > this.length()) {
            throw new IllegalArgumentException("End index out of bounds");
        }
        if (start > end) {
            throw new IllegalArgumentException("Start index greater than end index");
        }
        List<SequenceElement> exp = this.getExpandedElements();
        String str = "";
        Iterator<SequenceElement> i = exp.subList(start - 1, end).iterator();
        while (i.hasNext()) {
            str = str + ((SequenceStringElement)i.next()).seqString();
        }
        return str;
    }

    public void setSequence(String seq) throws SequenceFormatException {
        this.sequence.clear();
        if (seq.length() > 0) {
            this.setSequenceRepr(this.parse(seq, this.type, this.sequence));
        } else {
            this.setSequenceRepr("");
        }
    }

    public void setType(byte _type) {
        this.type = _type;
    }

    public void edit(SequenceEdit edit) throws SequenceFormatException {
        String str = this.seqString();
        int stringIndex1 = edit.getPos() - 1;
        int stringIndex2 = stringIndex1 + edit.getReplaceLength();
        String part1 = str.substring(0, stringIndex1);
        String part2 = str.substring(stringIndex2);
        this.setSequence(part1 + edit.getReplaceString() + part2);
    }

    public Nucleotide getNucleotideAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new ArrayIndexOutOfBoundsException("Trying to get a nucleotide outside of the sequence (" + pos + ")");
        }
        return (Nucleotide)this.getExpandedElements().get(pos - 1);
    }

    public List<SequenceElement> getElements() {
        return this.sequence;
    }

    protected static List<SequenceElement> expandElements(SequenceElementContainer sc) {
        ArrayList<SequenceElement> expandedElements = new ArrayList<SequenceElement>();
        for (SequenceElement e : sc.getElements()) {
            if (e instanceof SequenceElementContainer) {
                expandedElements.addAll(VariationSequenceElementContainer.expandElements((SequenceElementContainer)e));
                continue;
            }
            expandedElements.add(e);
        }
        return expandedElements;
    }

    public List<SequenceElement> getExpandedElements() {
        return VariationSequenceElementContainer.expandElements(this);
    }

    public int length() {
        int length = 0;
        Iterator<SequenceElement> i = this.sequence.iterator();
        while (i.hasNext()) {
            length += i.next().length();
        }
        return length;
    }

    public void setName(String newName) {
        this.description = newName;
    }

    public void insertElement(SequenceElement element, int index) {
        if (!(element instanceof SequenceStringElement)) {
            throw new IllegalArgumentException("Only SequenceStringElement objects accepted by " + ((Object)((Object)this)).getClass());
        }
        this.sequence.add(index, element);
        this.seqDirty = true;
    }

    public void setElement(SequenceElement newElement, int index) {
        if (!(newElement instanceof SequenceStringElement)) {
            throw new IllegalArgumentException("Only SequenceStringElement objects accepted by " + ((Object)((Object)this)).getClass());
        }
        this.sequence.set(index, newElement);
        this.seqDirty = true;
    }

    public void removeElement(int index) {
        this.sequence.remove(index);
        this.seqDirty = true;
    }

    public void addToEnd(SequenceElement element) {
        if (!(element instanceof SequenceStringElement)) {
            throw new IllegalArgumentException("Only SequenceStringElement objects accepted by " + ((Object)((Object)this)).getClass());
        }
        this.sequence.add(element);
        this.seqDirty = true;
    }

    public void removeFromEnd() {
        this.sequence.remove(this.sequence.size() - 1);
        this.seqDirty = true;
    }

    protected void setSequenceRepr(String sequenceRepr) {
        this.sequenceRepr = sequenceRepr;
        this.seqDirty = false;
    }
}

