/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.Aligner;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;
import org.moltools.lib.seq.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmithWatermanCalculator
extends AbstractParameterHolder
implements Aligner {
    protected static final byte STOP = 1;
    protected static final byte F_GAP = 2;
    protected static final byte S_GAP = 3;
    protected static final byte EXTEND = 4;
    protected transient short[][] scoringTable;
    protected transient short[] gapPenaltyTable;
    protected transient short gapOpenPenalty;
    protected transient short gapExtensionPenalty;
    public transient short[][] resultMatrix;
    protected transient byte[][] traceMatrix;
    protected transient int[] positions;
    protected transient String[] traces;
    protected transient byte[] firstB;
    protected transient byte[] secondB;
    protected transient int minlooplength;

    public static char byteToBase(byte b) {
        return (char)b;
    }

    public static final byte basecode(char c) {
        return (byte)c;
    }

    @Override
    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("AA", "-8");
        p.put("AC", "-8");
        p.put("AG", "-8");
        p.put("AT", "3");
        p.put("CA", "-8");
        p.put("CC", "-8");
        p.put("CG", "6");
        p.put("CT", "-8");
        p.put("GA", "-8");
        p.put("GC", "6");
        p.put("GG", "-8");
        p.put("GT", "1");
        p.put("TA", "3");
        p.put("TC", "-8");
        p.put("TG", "1");
        p.put("TT", "-8");
        p.put("GAP_OPEN_PENALTY", "17");
        p.put("GAP_EXTENSION_PENALTY", "17");
        return p;
    }

    public SmithWatermanCalculator() {
        this.parameters = this.getDefaultParameters();
        this.scoringTable = new short[127][127];
        this.traces = new String[2];
        this.positions = new int[4];
        this.gapPenaltyTable = new short[0];
        this.readScores();
    }

    @Override
    public void addParameters(Map<String, String> p) {
        super.addParameters(p);
        this.readScores();
    }

    @Override
    public void setParameters(Map<String, String> p) {
        super.setParameters(p);
        this.readScores();
    }

    protected void readScores() {
        for (byte i = 0; i < this.scoringTable.length; i = (byte)(i + 1)) {
            for (byte j = 0; j < this.scoringTable[i].length; j = (byte)(j + 1)) {
                String s = String.valueOf(SmithWatermanCalculator.byteToBase(i)) + String.valueOf(SmithWatermanCalculator.byteToBase(j));
                String p = (String)this.parameters.get(s);
                this.scoringTable[i][j] = p == null ? (short)0 : Short.parseShort(p);
            }
        }
        this.gapOpenPenalty = Short.parseShort((String)this.parameters.get("GAP_OPEN_PENALTY"));
        this.gapExtensionPenalty = Short.parseShort((String)this.parameters.get("GAP_EXTENSION_PENALTY"));
    }

    public int getScore(String str1, String str2) {
        int score = 0;
        for (int i = 0; i < str1.length(); ++i) {
            score += this.getMatchScore(SmithWatermanCalculator.basecode(str1.charAt(i)), SmithWatermanCalculator.basecode(str2.charAt(i)));
        }
        return score;
    }

    public int getHighestCell(int[] pos) {
        if (this.resultMatrix == null) {
            return 0;
        }
        short maxvalue = 0;
        for (int i = 0; i < this.resultMatrix.length; ++i) {
            for (int j = 0; j < this.resultMatrix[i].length; ++j) {
                if (this.resultMatrix[i][j] <= maxvalue || this.traceMatrix[i][j] != 4) continue;
                maxvalue = this.resultMatrix[i][j];
                pos[0] = i;
                pos[1] = j;
            }
        }
        return maxvalue;
    }

    public short getMatchScore(byte f, byte s) {
        return this.scoringTable[f][s];
    }

    protected int getSWScore(int i, int j, byte[] first, byte[] second) {
        short gapsecond;
        int k;
        short gapfirst;
        short extend;
        short matchscore = this.scoringTable[first[i]][second[j]];
        short s = extend = i == 0 || j == 0 ? matchscore : (short)(this.resultMatrix[i - 1][j - 1] + matchscore);
        if (i == 0) {
            gapfirst = 0;
        } else {
            short maxf = 0;
            for (k = 1; k <= j; ++k) {
                maxf = (short)Math.max(maxf, this.resultMatrix[i][j - k] - this.gapPenaltyTable[k]);
            }
            gapfirst = maxf;
        }
        if (j == 0) {
            gapsecond = 0;
        } else {
            short maxs = 0;
            for (k = 1; k <= i; ++k) {
                maxs = (short)Math.max(maxs, this.resultMatrix[i - k][j] - this.gapPenaltyTable[k]);
            }
            gapsecond = maxs;
        }
        short max = (short)Math.max(extend, Math.max(gapfirst, Math.max(gapsecond, 0)));
        if (max == 0) {
            this.traceMatrix[i][j] = 1;
        } else if (max == extend) {
            this.traceMatrix[i][j] = 4;
        } else if (max == gapfirst) {
            this.traceMatrix[i][j] = 2;
        } else if (max == gapsecond) {
            this.traceMatrix[i][j] = 3;
        }
        return max;
    }

    public static byte[] getByteArray(String seq) {
        byte[] array = new byte[seq.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = SmithWatermanCalculator.basecode(seq.charAt(i));
        }
        return array;
    }

    public int traceBack() {
        int[] pos = new int[2];
        int length = 0;
        int value = this.getHighestCell(pos);
        int row = pos[0];
        int col = pos[1];
        this.resultMatrix[row][col] = -1;
        if (value < 0) {
            return -1;
        }
        if (value == 0) {
            return 0;
        }
        int firstend = row;
        int secondend = col;
        String firsttrace = "";
        String secondtrace = "";
        boolean done = false;
        while (!done) {
            switch (this.traceMatrix[row][col]) {
                case 1: {
                    ++col;
                    ++row;
                    done = true;
                    break;
                }
                case 2: {
                    secondtrace = SmithWatermanCalculator.byteToBase(this.secondB[col]) + secondtrace;
                    firsttrace = "-" + firsttrace;
                    ++length;
                    --col;
                    break;
                }
                case 3: {
                    firsttrace = SmithWatermanCalculator.byteToBase(this.firstB[row]) + firsttrace;
                    secondtrace = "-" + secondtrace;
                    ++length;
                    --row;
                    break;
                }
                case 4: {
                    firsttrace = SmithWatermanCalculator.byteToBase(this.firstB[row]) + firsttrace;
                    secondtrace = SmithWatermanCalculator.byteToBase(this.secondB[col]) + secondtrace;
                    ++length;
                    --col;
                    --row;
                }
            }
            if (row >= 0 && col >= 0) continue;
            done = true;
            ++row;
            ++col;
        }
        int firststart = row;
        int secondstart = col;
        this.positions[0] = firststart;
        this.positions[1] = firstend;
        this.positions[2] = secondstart;
        this.positions[3] = secondend;
        this.traces[0] = firsttrace;
        this.traces[1] = secondtrace;
        return length;
    }

    protected boolean isOverlap(int looplength) {
        return looplength < this.minlooplength;
    }

    protected int getLoopLength() {
        int firststart = Math.min(this.positions[0], this.positions[1]);
        int firstend = Math.max(this.positions[0], this.positions[1]);
        int secondstart = Math.min(this.positions[2], this.positions[3]);
        int secondend = Math.max(this.positions[2], this.positions[3]);
        int looplength = firststart < secondstart ? secondstart - firstend - 1 : (firststart > secondstart ? firststart - secondend - 1 : -1);
        if (looplength <= 0) {
            looplength = -1;
        }
        return looplength;
    }

    protected void doSmithWaterman() {
        int i;
        int longest = Math.max(this.firstB.length, this.secondB.length);
        if (longest > this.gapPenaltyTable.length) {
            this.gapPenaltyTable = new short[longest];
            for (i = 0; i < this.gapPenaltyTable.length; ++i) {
                this.gapPenaltyTable[i] = i == 0 ? (short)0 : (short)(this.gapOpenPenalty + (i - 1) * this.gapExtensionPenalty);
            }
        }
        this.traceMatrix = new byte[this.firstB.length][this.secondB.length];
        this.resultMatrix = new short[this.firstB.length][this.secondB.length];
        for (i = 0; i < this.firstB.length; ++i) {
            for (int j = 0; j < this.secondB.length; ++j) {
                this.resultMatrix[i][j] = (short)this.getSWScore(i, j, this.firstB, this.secondB);
            }
        }
    }

    @Override
    public void doAlignment(Sequence seq1, Sequence seq2) {
        this.doAlignment(seq1.seqString(), seq2.seqString());
    }

    @Override
    public void doAlignment(String seq1, String seq2) {
        this.firstB = SmithWatermanCalculator.getByteArray(seq1);
        this.secondB = SmithWatermanCalculator.getByteArray(seq2);
        this.doSmithWaterman();
    }

    @Override
    public Alignment getNextAlignment() {
        int length = this.traceBack();
        if (length < 0) {
            throw new UnsupportedOperationException("Length below zero in traceBack()");
        }
        if (length == 0) {
            return null;
        }
        return new SimpleAlignment(this.positions[0] + 1, this.positions[1] + 1, this.traces[0], this.positions[2] + 1, this.positions[3] + 1, this.traces[1]);
    }

    public void printTraceMatrix() {
        System.out.println("Trace:");
        for (int i = 0; i < this.traceMatrix.length; ++i) {
            for (int j = 0; j < this.traceMatrix[i].length; ++j) {
                System.out.print("\t" + this.traceMatrix[i][j]);
            }
            System.out.println();
        }
    }

    public void printResultMatrix() {
        System.out.println("Score:");
        for (int i = 0; i < this.resultMatrix.length; ++i) {
            for (int j = 0; j < this.resultMatrix[i].length; ++j) {
                System.out.print("\t" + this.resultMatrix[i][j]);
            }
            System.out.println();
        }
    }
}

