/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.data.impl;

import org.moltools.design.data.impl.AbstractSequenceTarget;
import org.moltools.lib.Named;
import org.moltools.lib.seq.SequenceView;

public abstract class AbstractPositionTarget
extends AbstractSequenceTarget
implements SequenceView,
Named {
    public static final char positionSymbol = '|';
    public static final String NAME_DELIMITER = "|";
    protected int targetPos = 0;
    protected String name;

    public AbstractPositionTarget(String id, String seq, String name) {
        this(id, seq, 0, name);
    }

    public AbstractPositionTarget(String id, String seq, byte type, String name) {
        super(id, seq, type);
        this.setSequence(this.parse(this.sequence));
        this.name = name;
    }

    private void setSequence(String newSeq) {
        this.sequence = this.parse(newSeq);
    }

    private String parse(String seq) {
        boolean found = false;
        String parsed = "";
        for (int pos = 0; pos < seq.length(); ++pos) {
            char c = seq.charAt(pos);
            if (c == '|' && !found) {
                found = true;
                this.targetPos = pos;
                continue;
            }
            if (c == '|' && found) {
                throw new IllegalArgumentException("Too many position symbols");
            }
            parsed = parsed + Character.toUpperCase(c);
        }
        return parsed;
    }

    public String getName() {
        return this.name;
    }

    public String getViewName() {
        return (this.name == null ? this.getID() : this.name) + NAME_DELIMITER + this.targetPos;
    }

    public String getViewSequence() {
        if (this.targetPos < 0) {
            return this.sequence;
        }
        return this.sequence.substring(0, this.targetPos) + '|' + this.sequence.substring(this.targetPos);
    }
}

