/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.services.impl;

import java.util.Collections;
import java.util.List;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.Property;
import org.moltools.design.services.IntraAnalysis;
import org.moltools.lib.seq.SequenceStringElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCAnalysis
implements IntraAnalysis {
    public static final String GC_CONTENT = "GC_CONTENT";

    @Override
    public List<Property> analyze(Object object) {
        SequenceStringElement seq = (SequenceStringElement)object;
        int length = seq.length();
        float GC = 0.0f;
        char[] bases = seq.seqString().toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            if (bases[i] != 'C' && bases[i] != 'G') continue;
            GC += 1.0f;
        }
        SimpleProperty gcProp = new SimpleProperty(GC_CONTENT, new Float(GC / (float)length * 100.0f), false);
        return Collections.singletonList(gcProp);
    }
}

