/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq;

import java.util.Iterator;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.impl.DefaultProbe;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.impl.DefaultChangeablePropertyNucleotideSequence;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.design.properties.Property;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeMakerSequenceFactory {
    public static PropertyAcceptorNucleotideSequence createTSS(NucleotideSequence seq, String targetID) {
        DefaultChangeablePropertyNucleotideSequence tss = new DefaultChangeablePropertyNucleotideSequence(seq.getID(), seq.seqString(), seq.getType());
        tss.getMutablePropertySet().setProperty((Property)new SimpleProperty("moltools.targetID", (Object)targetID, false));
        return tss;
    }

    public static Probe createProbeSkeleton(TSSPair pair, byte probeAcidType, int upstreamBlocks, int downstreamBlocks, DefiniteSequenceDB<Probe> probeset) {
        DefaultProbe p = new DefaultProbe(pair, upstreamBlocks, downstreamBlocks, probeAcidType);
        TargetGroup tg = (TargetGroup)DesignUtils.getGroupWithType((PropertyHolder)((PropertyHolder)p.getTarget()), (String)"moltools.targetGroup");
        if (tg != null) {
            boolean groupfound = false;
            Iterator i = probeset.iterator();
            while (i.hasNext() && !groupfound) {
                Probe other = (Probe)i.next();
                ProbeGroup og = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)other, (String)"probeGroup");
                if (og == null || og.getTargetGroup() != tg) continue;
                og.addMember(p);
                groupfound = true;
            }
            if (!groupfound) {
                ProbeGroup pg = new ProbeGroup(tg, tg.getID());
                pg.addMember(p);
            }
        }
        return p;
    }

    public static TSSPair createTSSPair(PropertyAcceptorNucleotideSequence tss5, PropertyAcceptorNucleotideSequence tss3, ProbeMakerTarget target) {
        return new TSSPair(tss5, tss3, target);
    }
}

