/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ext;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.ui.swing.AbstractSwingWorkbenchUI;
import net.sf.apptools.ui.swing.SwingUserAction;

public class CardPaneWorkbenchUI
extends AbstractSwingWorkbenchUI {
    protected JPanel cardPane;
    protected CardLayout cardLayout = new CardLayout();

    public static final String getBriefDescription() {
        return "Workbench interface using a card layout";
    }

    public CardPaneWorkbenchUI() {
        this.cardPane = new JPanel(this.cardLayout);
        this.mainPane.add((Component)this.cardPane, "Center");
    }

    protected void switchView(AbstractSwingWorkbenchUI.View v) {
        this.activeView = v;
        if (this.activeView != null) {
            this.cardLayout.show(this.cardPane, this.activeView.getName());
            this.setTitle(this.baseTitle + " - " + this.activeView.getName());
        } else {
            this.cardLayout.first(this.cardPane);
        }
        this.updateToolBar();
    }

    protected void addView(AbstractSwingWorkbenchUI.View v) {
        this.currentViews.add(v);
        if (v.getUi() != null) {
            this.cardPane.add(v.getUi(), v.getName());
        }
        this.switchView(v);
    }

    protected void removeView(AbstractSwingWorkbenchUI.View v) {
        this.currentViews.remove(v);
        this.funcButtonGroup.remove(v.getButton());
        if (v.getUi() != null) {
            this.cardPane.remove(v.getUi());
        }
        if (this.activeView == v) {
            AbstractSwingWorkbenchUI.View first = this.currentViews.size() > 0 ? (AbstractSwingWorkbenchUI.View)this.currentViews.get(0) : null;
            this.switchView(first);
        }
    }

    protected void toolBarUpdateActions() {
        if (this.activeView != null) {
            List<ActionSet> l = this.activeView.getActionSets();
            for (int i = 0; i < l.size(); ++i) {
                if (i > 0) {
                    this.toolBar.addSeparator();
                }
                UserAction[] group = l.get(i).getActions();
                for (int a = 0; a < group.length; ++a) {
                    JButton btn = new JButton(new SwingUserAction(group[a]));
                    if (btn.getIcon() != null) {
                        btn.setText(null);
                    }
                    this.toolBar.add(btn);
                }
            }
        }
    }

    protected void addActionGroupInternal(ActionSet set) {
        if (set.getGroupID() == null) {
            return;
        }
        JMenu menu = this.menuManager.getOrCreateMenu(set.getGroupID(), set.getOrder());
        CardPaneWorkbenchUI.addActionsToMenu(menu, set.getActions());
    }

    protected void removeActionGroupInternal(ActionSet set) {
        if (set.getGroupID() == null) {
            return;
        }
        JMenu menu = this.menuManager.getMenu(set.getGroupID());
        if (menu != null) {
            CardPaneWorkbenchUI.removeActionsFromMenu(menu, set.getActions());
            if (menu.getMenuComponentCount() < 1) {
                this.menuManager.remove(menu);
            }
        }
    }
}

