/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.ui.UITexts;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.data.DataEditor;
import net.sf.apptools.ui.swing.data.DataEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataEditPanel
extends JPanel {
    DataEditor[] dataEditors;
    DataDescriptor[] dataDescriptors;
    DataHolder dataHolder;

    public DataEditPanel(DataHolder dataHolder, Map<String, ?> valueMap, DataEditorFactory factory) {
        this.setLayout(new BoxLayout(this, 3));
        this.dataHolder = dataHolder;
        this.dataDescriptors = dataHolder.getDataDescriptors();
        if (this.dataDescriptors != null) {
            boolean large = this.dataDescriptors.length >= 5;
            this.dataEditors = new DataEditor[this.dataDescriptors.length];
            for (int i = 0; i < this.dataDescriptors.length; ++i) {
                this.dataEditors[i] = factory.createDataEditor(this.dataDescriptors[i], large);
                if (this.dataEditors[i] != null) {
                    JComponent comp;
                    Object value = valueMap.get(this.dataDescriptors[i].getKey());
                    if (value != null) {
                        this.dataEditors[i].setValue(value);
                    }
                    if ((comp = this.dataEditors[i].getEditorComponent()) instanceof JComponent) {
                        JComponent jc = comp;
                        jc.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                        jc.setAlignmentX(-1.0f);
                    }
                    this.add(comp);
                    continue;
                }
                this.add(new JLabel(SwingUITexts.getString("DataEditPanel.MESSAGE_NO_EDITOR_FOR") + this.dataDescriptors[i].getName()));
            }
        } else {
            this.add(new JLabel(UITexts.getString((String)"CommonUI.MESSAGE_NOT_A_PARAMETER_PLUGIN")));
        }
        this.add(Box.createVerticalGlue());
    }

    public boolean validateInput() {
        if (this.dataDescriptors != null) {
            for (int i = 0; i < this.dataDescriptors.length; ++i) {
                Object value = this.dataEditors[i].getValue();
                String v = this.dataDescriptors[i].validate(value);
                if (v == null) continue;
                JOptionPane.showMessageDialog(this, v, SwingUITexts.getString("DataEditPanel.TITLE_INVALID_INPUT"), 2);
                return false;
            }
        }
        return true;
    }

    public void applyInput() {
        if (this.dataDescriptors != null) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int i = 0; i < this.dataDescriptors.length; ++i) {
                Object value = this.dataEditors[i].getValue();
                values.put(this.dataDescriptors[i].getKey(), value);
            }
            this.dataHolder.setData(values);
        }
    }
}

