/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.sf.apptools.data.ListSelectionDescriptor;
import net.sf.apptools.data.OptionDescriptor;
import net.sf.apptools.ui.swing.data.DataEditor;

class SmallOptionEditor
implements DataEditor {
    JComboBox box;
    Object[] options;
    String title;
    String tooltip;

    public SmallOptionEditor(OptionDescriptor od) {
        this.options = od.getOptions();
        this.title = od.getName();
        this.tooltip = od.getDescription();
        this.box = new JComboBox<Object>(this.options);
    }

    public SmallOptionEditor(ListSelectionDescriptor lsd, ListCellRenderer renderer) {
        this.options = lsd.getObjects();
        this.title = lsd.getName();
        this.tooltip = lsd.getDescription();
        this.box = new JComboBox<Object>(this.options);
        if (renderer != null) {
            this.box.setRenderer(renderer);
        }
    }

    public JComponent getEditorComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        JLabel label = new JLabel(this.title + ":");
        label.setToolTipText(this.tooltip);
        label.setLabelFor(this.box);
        label.setAlignmentX(-1.0f);
        p.add(label);
        p.add(Box.createHorizontalGlue());
        p.add(this.box);
        return p;
    }

    public Object getValue() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return new Integer(index);
    }

    public void setValue(Object o) {
        int index = -1;
        if (o instanceof Integer) {
            index = (Integer)o;
        } else if (o instanceof String) {
            index = this.getIndexForOption(o.toString());
        }
        if (index < 0) {
            return;
        }
        this.box.setSelectedIndex(index);
    }

    protected int getSelectedIndex() {
        return this.box.getSelectedIndex();
    }

    protected int getIndexForOption(String option) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].toString().equals(option)) continue;
            return i;
        }
        return -1;
    }
}

