/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.ProgressModel;
import net.sf.apptools.ui.swing.task.SwingTaskRunner;

public class SimpleProgressDialog
extends JDialog
implements ActionListener,
ProgressListener {
    private static final long serialVersionUID = 1L;
    protected JButton cancelButton;
    protected JLabel[] statusLabels;
    protected JProgressBar progressBar;
    protected JPanel mainPane;
    protected JPanel btnPane;
    protected SwingTaskRunner runner;

    public SimpleProgressDialog(Frame owner, SwingTaskRunner runner) {
        super(owner, true);
        int i;
        this.runner = runner;
        runner.addListener(this);
        this.setTitle(runner.getTitle());
        this.setDefaultCloseOperation(0);
        this.cancelButton = new JButton(PlatformTexts.getString((String)"Common.CAPTION_ABORT"));
        this.cancelButton.addActionListener(this);
        this.statusLabels = new JLabel[runner.getStatusLevels()];
        for (i = 0; i < this.statusLabels.length; ++i) {
            this.statusLabels[i] = new JLabel("");
        }
        if (runner.getMaxProgress() < 0) {
            this.progressBar = new JProgressBar(0, 1);
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar = new JProgressBar(runner.getMinProgress(), runner.getMaxProgress());
            this.progressBar.setValue(runner.getMinProgress());
        }
        this.mainPane = new JPanel(new GridLayout(runner.getStatusLevels() + 1, 1, 5, 5));
        this.mainPane.add(this.progressBar);
        for (i = 0; i < this.statusLabels.length; ++i) {
            this.mainPane.add(this.statusLabels[i]);
        }
        this.btnPane = new JPanel(new FlowLayout());
        this.btnPane.add(this.cancelButton);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.mainPane, "Center");
        cp.add((Component)this.btnPane, "South");
        this.pack();
        if (owner != null) {
            Dimension parentSize = owner.getSize();
            Dimension frameSize = this.getSize();
            this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void setStatus(final String status, final int level) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    SimpleProgressDialog.this.statusLabels[level].setText(status);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
    }

    protected void setProgress(final int progress) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SimpleProgressDialog.this.progressBar.setValue(progress);
            }
        });
    }

    protected void close() {
        this.runner.removeListener(this);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.cancelButton) {
                this.runner.abort();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), PlatformTexts.getString((String)"Common.TITLE_EXCEPTION"), 2);
        }
        catch (Error er) {
            JOptionPane.showMessageDialog(this, er.toString(), PlatformTexts.getString((String)"Common.TITLE_ERROR"), 0);
        }
    }

    public void progressChanged(ProgressModel source, int newProgress) {
        this.setProgress(newProgress);
    }

    public void statusChanged(ProgressModel source, int level, String status) {
        this.setStatus(status, level);
    }

    public void taskCompleted(ProgressModel source) {
        this.close();
    }

    public void taskAborted(ProgressModel source) {
        this.close();
    }
}

