/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeLengthModule
extends AbstractProbeModule {
    protected transient int prefLength;
    public static MessageType PROBE_LENGTH = new MessageType("PROBE_LENGTH", "Probe length");

    public static String getBriefDescription() {
        return "Probe length";
    }

    public static String getLongDescription() {
        return "Checks if the probe is of the preferred length as specified by the Spacer settings.If not, an error message is given.";
    }

    public ProbeLengthModule() {
        super(new TestDescriptor[]{new TestDescriptor("Probe length")}, new DataDescriptor[0]);
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        this.prefLength = Integer.parseInt((String)pd.getParameters().get("PREFERRED_LENGTH"));
        if (this.tests[0].perform()) {
            if (p.length() < this.prefLength && this.prefLength > 0) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Probe is too short by " + (this.prefLength - p.length()) + " nucleotide(s)", PROBE_LENGTH, 2));
            } else if (p.length() > this.prefLength && this.prefLength > 0) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Probe is too long by " + (p.length() - this.prefLength) + " nucleotide(s)", PROBE_LENGTH, 2));
            }
        }
    }

    public void reset() {
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

