/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.tc;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.plugin.PlugIn;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.TargettedSequence;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTSSConstructor
extends AbstractParameterHolder
implements TSSConstructor,
PlugIn {
    public static String getBriefDescription() {
        return "Target sequences";
    }

    public static String getLongDescription() {
        return "This constructor uses the target-defined template sequences as target-specific sequences.No Tm calculations are performed";
    }

    public PropertyAcceptorNucleotideSequence get3PrimeTSS(ProbeMakerTarget target, byte type) {
        TargettedSequence temp;
        try {
            temp = (TargettedSequence)target.getTemplateCluster().getSequence("THREE_PRIME");
        }
        catch (ClusterException e) {
            temp = null;
        }
        if (temp != null) {
            return ProbeMakerSequenceFactory.createTSS((NucleotideSequence)temp, (String)target.getID());
        }
        return ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence("TSS3|" + target.getID(), "", type), (String)target.getID());
    }

    public PropertyAcceptorNucleotideSequence get5PrimeTSS(ProbeMakerTarget target, byte type) {
        TargettedSequence temp;
        try {
            temp = (TargettedSequence)target.getTemplateCluster().getSequence("FIVE_PRIME");
        }
        catch (ClusterException e) {
            temp = null;
        }
        if (temp != null) {
            return ProbeMakerSequenceFactory.createTSS((NucleotideSequence)temp, (String)target.getID());
        }
        return ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence("TSS5|" + target.getID(), "", type), (String)target.getID());
    }

    public Map<String, String> getDefaultParameters() {
        return new HashMap<String, String>();
    }
}

