/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import net.sf.apptools.plugin.PlugInLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryFilePlugInLoader
implements PlugInLoader {
    protected ClassLoader auxLoader;
    protected Log log = LogFactory.getLog(RegistryFilePlugInLoader.class);

    public RegistryFilePlugInLoader(ClassLoader auxLoader) {
        this.auxLoader = auxLoader;
    }

    @Override
    public List<String> getAvailablePlugIns(Class<?>[] pluginClasses, Collection<Class<?>>[] classes) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Enumeration<URL> en = this.auxLoader.getResources("META-INF/services/net.sf.apptools.plugin.PlugIn");
            this.log.info((Object)"Parsing plug-in registry files");
            ArrayList<String> classNames = new ArrayList<String>();
            while (en.hasMoreElements()) {
                URL resourceURL = en.nextElement();
                this.log.info((Object)("Loading plug-ins from: " + resourceURL));
                InputStream in = resourceURL.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String line = "";
                while ((line = br.readLine()) != null) {
                    String className = line.trim();
                    if (className.startsWith("#") || className.length() <= 0) continue;
                    classNames.add(className);
                }
            }
            for (String className : classNames) {
                this.log.debug((Object)("Loading plug-in " + className));
                try {
                    Class<?> c = Class.forName(className, true, this.auxLoader);
                    for (int index = 0; index < pluginClasses.length; ++index) {
                        Class<?> pic = pluginClasses[index];
                        if (pic == null) {
                            this.log.warn((Object)"Encountered a null plug-in class");
                            continue;
                        }
                        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
                            this.log.debug((Object)"  Interface/Abstract class");
                            continue;
                        }
                        this.log.debug((Object)("Checking against " + pic.getName()));
                        try {
                            c.getConstructor(new Class[0]);
                            if (pic.isAssignableFrom(c)) {
                                classes[index].add(c);
                                this.log.debug((Object)(c + " is a " + pic.getName()));
                                continue;
                            }
                            if (pic != c) continue;
                            classes[index].add(c);
                            this.log.debug((Object)(c + " is " + pic.getName()));
                            continue;
                        }
                        catch (SecurityException e1) {
                            messages.add("Security exception: " + e1.getMessage());
                            continue;
                        }
                        catch (NoSuchMethodException e1) {
                            this.log.warn((Object)(c + " has no constructor"));
                        }
                    }
                }
                catch (ClassNotFoundException cnfx) {
                    this.log.warn((Object)(className + " not found"), (Throwable)cnfx);
                    messages.add("(" + className + ") Class not found:" + cnfx.getMessage());
                }
                catch (Throwable ex) {
                    this.log.warn((Object)("Error loading " + className), ex);
                    messages.add("(" + className + ") Error:" + ex.toString());
                }
            }
        }
        catch (IOException iox) {
            messages.add(iox.toString());
        }
        return messages;
    }
}

