/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.ui.UIActivePlugIn;
import net.sf.apptools.ui.swing.AbstractSwingWorkbenchUI;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.SwingUserAction;

public class IFrameWorkbenchUI
extends AbstractSwingWorkbenchUI {
    protected JDesktopPane dtpane;
    protected Map<AbstractSwingWorkbenchUI.View, JInternalFrame> iFrames = new HashMap<AbstractSwingWorkbenchUI.View, JInternalFrame>();
    UserAction[] windowActions;
    UserAction arrangeVertical;
    UserAction cascade;

    public static final String getBriefDescription() {
        return "Workbench interface using internal frames";
    }

    public IFrameWorkbenchUI() {
        this.dtpane = new JDesktopPane();
        this.mainPane.add((Component)this.dtpane, "Center");
    }

    public void setup(Platform platform) {
        super.setup(platform);
        this.cascade = new AbstractUserAction(SwingUITexts.getString("IFrameWorkbenchUI.CAPTION_CASCADE"), SwingUITexts.getString("IFrameWorkbenchUI.TOOLTIP_CASCADE")){

            public void execute() {
                ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>(IFrameWorkbenchUI.this.iFrames.values());
                int x = 0;
                int y = 0;
                int w = IFrameWorkbenchUI.this.dtpane.getWidth();
                int h = IFrameWorkbenchUI.this.dtpane.getHeight();
                int count = frames.size();
                int offset = 20;
                for (int i = 0; i < frames.size(); ++i) {
                    JInternalFrame f = (JInternalFrame)frames.get(i);
                    try {
                        f.setMaximum(false);
                    }
                    catch (PropertyVetoException e1) {
                        // empty catch block
                    }
                    f.setBounds(x, y, w - (count - 1) * offset, h - (count - 1) * offset);
                    f.setPreferredSize(new Dimension(w - (count - 1) * offset, h - (count - 1) * offset));
                    x += offset;
                    y += offset;
                }
            }
        };
        this.arrangeVertical = new AbstractUserAction(SwingUITexts.getString("IFrameWorkbenchUI.CAPTION_ARRANGE_VERTICAL"), SwingUITexts.getString("IFrameWorkbenchUI.TOOLTIP_ARRANGE_VERTICAL")){

            public void execute() {
                ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>(IFrameWorkbenchUI.this.iFrames.values());
                int x = 0;
                int y = 0;
                int w = IFrameWorkbenchUI.this.dtpane.getWidth();
                int h = IFrameWorkbenchUI.this.dtpane.getHeight();
                int count = frames.size();
                if (count > 0) {
                    int fw = w / count;
                    for (JInternalFrame f : frames) {
                        try {
                            f.setMaximum(false);
                        }
                        catch (PropertyVetoException e1) {
                            // empty catch block
                        }
                        f.setPreferredSize(new Dimension(fw, h));
                        f.setBounds(x, y, fw, h);
                        x += fw;
                    }
                }
            }
        };
        this.windowActions = new UserAction[]{this.arrangeVertical, this.cascade};
        platform.addActionSet(new ActionSet(this.windowActions, "Window", (ActivePlugIn)this, 950));
    }

    protected void switchView(AbstractSwingWorkbenchUI.View v) {
        this.activeView = v;
        if (this.activeView != null) {
            JInternalFrame iframe = this.iFrames.get(this.activeView);
            try {
                iframe.setSelected(true);
                iframe.toFront();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.updateToolBar();
    }

    protected void addView(AbstractSwingWorkbenchUI.View v) {
        this.currentViews.add(v);
        final JInternalFrame iframe = new JInternalFrame(v.getName(), true, true, true, true);
        this.dtpane.add(iframe);
        this.iFrames.put(v, iframe);
        iframe.getContentPane().setLayout(new BorderLayout());
        String toolbarName = MessageFormat.format(SwingUITexts.getString("IFrameWorkbenchUI.CAPTION_PLUGIN_TOOLS"), v.getName());
        JToolBar tb = new JToolBar(toolbarName);
        tb.setRollover(true);
        List<ActionSet> l = v.getActionSets();
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                tb.addSeparator();
            }
            UserAction[] group = l.get(i).getActions();
            for (int a = 0; a < group.length; ++a) {
                JButton btn = new JButton(new SwingUserAction(group[a]));
                if (btn.getIcon() != null) {
                    btn.setText(null);
                }
                tb.add(btn);
            }
        }
        Icon icon = v.getPlugin().getIcon();
        if (icon != null) {
            iframe.setFrameIcon(icon);
        }
        JMenuBar mb = new JMenuBar();
        iframe.setJMenuBar(mb);
        AbstractSwingWorkbenchUI.MenuManager mm = new AbstractSwingWorkbenchUI.MenuManager(this, mb);
        List m = this.platform.getActionSets((ActivePlugIn)v.getPlugin());
        for (ActionSet as : m) {
            String groupID = as.getGroupID();
            int order = as.getOrder();
            if (groupID == null) continue;
            String[] split = groupID.split("/");
            JMenu menu = split.length == 2 ? mm.getOrCreateMenu(split[1], order) : mm.getOrCreateMenu(groupID, order);
            IFrameWorkbenchUI.addActionsToMenu(menu, as.getActions());
        }
        iframe.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                for (AbstractSwingWorkbenchUI.View view : IFrameWorkbenchUI.this.getCurrentViews()) {
                    if (IFrameWorkbenchUI.this.iFrames.get(view) != iframe) continue;
                    IFrameWorkbenchUI.this.removeView(view);
                    break;
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                UIActivePlugIn api = null;
                for (AbstractSwingWorkbenchUI.View view : IFrameWorkbenchUI.this.getCurrentViews()) {
                    if (IFrameWorkbenchUI.this.iFrames.get(view) != iframe) continue;
                    api = view.getPlugin();
                    break;
                }
                if (api != null) {
                    IFrameWorkbenchUI.this.getPlatform().deactivatePlugIn(api);
                }
            }
        });
        iframe.getContentPane().add(v.getUi(), "Center");
        iframe.getContentPane().add((Component)tb, "First");
        iframe.pack();
        try {
            iframe.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        iframe.setVisible(true);
        this.switchView(v);
    }

    protected void removeView(AbstractSwingWorkbenchUI.View v) {
        this.currentViews.remove(v);
        this.funcButtonGroup.remove(v.getButton());
        this.iFrames.remove(v).dispose();
        if (this.activeView == v) {
            AbstractSwingWorkbenchUI.View first = this.currentViews.size() > 0 ? (AbstractSwingWorkbenchUI.View)this.currentViews.get(0) : null;
            this.switchView(first);
        }
    }

    protected void toolBarUpdateActions() {
    }

    protected void addActionGroupInternal(ActionSet set) {
        if (set.getGroupID() == null) {
            return;
        }
        if (set.getPlugin() instanceof UIActivePlugIn) {
            return;
        }
        JMenu menu = this.menuManager.getOrCreateMenu(set.getGroupID(), set.getOrder());
        IFrameWorkbenchUI.addActionsToMenu(menu, set.getActions());
    }

    protected void removeActionGroupInternal(ActionSet set) {
        if (set.getGroupID() == null) {
            return;
        }
        if (set.getPlugin() instanceof UIActivePlugIn) {
            return;
        }
        JMenu menu = this.menuManager.getMenu(set.getGroupID());
        if (menu != null) {
            IFrameWorkbenchUI.removeActionsFromMenu(menu, set.getActions());
            if (menu.getMenuComponentCount() < 1) {
                this.menuManager.remove(menu);
            }
        }
    }
}

