/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.task;

import javax.swing.SwingUtilities;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.ProgressModel;
import net.sf.apptools.task.Task;

public class SwingTaskRunner
implements ProgressModel {
    Thread runThread;
    protected boolean aborted;
    protected Task task;
    protected ErrorHandler errorHandler;

    public SwingTaskRunner(Task task, ErrorHandler eh) {
        this.task = task;
        this.errorHandler = eh;
        this.aborted = false;
        Task r = task;
        Runnable finish = new Runnable(){

            public void run() {
                SwingTaskRunner.this.finished();
            }
        };
        Runnable doTask = new Runnable((Runnable)r, finish){
            final /* synthetic */ Runnable val$r;
            final /* synthetic */ Runnable val$finish;
            {
                this.val$r = runnable;
                this.val$finish = runnable2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.val$r.run();
                }
                catch (Throwable ex) {
                    if (SwingTaskRunner.this.errorHandler != null) {
                        SwingTaskRunner.this.errorHandler.handleError(ex.toString(), ex);
                    }
                    SwingTaskRunner.this.abort();
                    SwingTaskRunner.this.finished();
                }
                finally {
                    SwingTaskRunner.this.runThread = null;
                }
                SwingUtilities.invokeLater(this.val$finish);
            }
        };
        this.runThread = new Thread(doTask);
    }

    public void finished() {
    }

    public void abort() {
        this.task.abort();
        if (this.runThread != null) {
            this.runThread.interrupt();
        }
        this.runThread = null;
        this.aborted = true;
    }

    public void start() {
        if (this.runThread != null) {
            this.runThread.start();
        }
    }

    public String getTitle() {
        return this.task.getTitle();
    }

    public int getStatusLevels() {
        return this.task.getStatusLevels();
    }

    public int getMinProgress() {
        return this.task.getMinProgress();
    }

    public int getMaxProgress() {
        return this.task.getMaxProgress();
    }

    public void addListener(ProgressListener pl) {
        this.task.addListener(pl);
    }

    public void removeListener(ProgressListener pl) {
        this.task.removeListener(pl);
    }
}

