/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.apptools.CommandLineLauncher;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.plugin.ParameterPlugIn;
import net.sf.apptools.textio.ObjectBuilder;
import org.moltools.apps.probemaker.CommandLineErrorCallback;
import org.moltools.apps.probemaker.ProbeDesignTask;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.ProbeMakerPlugIn;
import org.moltools.apps.probemaker.ProbeSummarizer;
import org.moltools.apps.probemaker.TargetIOTask;
import org.moltools.apps.probemaker.design.DefaultProbeDesigner;
import org.moltools.apps.probemaker.design.DefaultTagLibrary;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.design.ProbeSelector;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.io.DefaultTargetInputFormat;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.project.ProjectHolder;
import org.moltools.apps.probemaker.project.ProjectXMLIOTask;
import org.moltools.apps.probemaker.project.Settings;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.db.ChangeableIndexedSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleDNASequenceBuilder;
import org.moltools.lib.seq.io.SequenceDBDataReader;
import org.moltools.lib.seq.io.SequenceDBWriter;
import org.moltools.lib.seq.io.impl.DefaultTextTableFormatter;
import org.moltools.lib.seq.io.impl.FastaDBFormat;
import org.moltools.lib.seq.io.impl.TextTableDBFormat;
import org.moltools.lib.seq.io.impl.TextTableFormatter;
import org.moltools.lib.seq.utils.SequenceIO;

public class ProbeMakerLauncher {
    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-h")) {
            ProbeMakerLauncher.printUsage(System.out);
        } else if (args[0].equals("-c")) {
            System.out.println("Launching console");
            CommandLineLauncher.main((String[])new String[0]);
        } else if (args[0].equals("-s")) {
            System.out.println("Running ProbeMaker with settings file");
            if (args.length < 2) {
                System.out.println("Error: No settings file specified");
                return;
            }
            if (args.length < 3) {
                System.out.println("Error: No target file specified");
                return;
            }
            if (args.length < 4) {
                System.out.println("Error: No output file specified");
                return;
            }
            try {
                ParameterPlugIn paFormat;
                DataDescriptor[] dds;
                ParameterPlugIn paSelector;
                DataDescriptor[] dds2;
                ParameterPlugIn paAcceptor;
                DataDescriptor[] dds3;
                ProbeMakerPlugIn pm = new ProbeMakerPlugIn();
                CommandLineErrorCallback callback = new CommandLineErrorCallback();
                File settingsFile = new File(args[1]);
                if (!settingsFile.exists()) {
                    System.out.println("Error: Could not find settings file: " + args[1]);
                    return;
                }
                File targetFile = new File(args[2]);
                if (!targetFile.exists()) {
                    System.out.println("Error: Could not find target file: " + args[2]);
                    return;
                }
                File outputFile = new File(args[3]);
                System.out.println("Reading settings");
                Properties props = new Properties();
                props.load(new FileInputStream(settingsFile));
                HashMap<String, String> vars = new HashMap<String, String>();
                for (Object key : props.keySet()) {
                    String keyString = (String)key;
                    if (!keyString.startsWith("$")) continue;
                    vars.put(keyString.substring(1), props.get(key).toString());
                }
                HashMap<String, String> transformedProps = new HashMap<String, String>();
                String prefix = "probemaker.design.";
                Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
                for (String string : props.keySet()) {
                    if (!string.startsWith("probemaker.design.")) continue;
                    String shortKey = string.substring("probemaker.design.".length());
                    String valueString = (String)props.get(string);
                    Matcher m = pattern.matcher(valueString);
                    String parsed = valueString;
                    while (m.find()) {
                        String varName = m.group(1);
                        String variableValue = (String)vars.get(varName);
                        parsed = parsed.replace("${" + varName + "}", variableValue);
                    }
                    transformedProps.put(shortKey, parsed);
                }
                Settings s = new Settings();
                s.addDesignerProperties(transformedProps);
                System.out.println("Done");
                System.out.println("Creating project");
                Project project = new Project("Unnamed", s);
                pm.setProject(project);
                String accClassName = props.getProperty("probemaker.acceptor");
                String selClassName = props.getProperty("probemaker.selector");
                String formatClassName = props.getProperty("probemaker.targetInputFormat");
                String targetClassName = props.getProperty("probemaker.targetType");
                if (accClassName == null) {
                    System.out.println("No acceptor specified");
                    return;
                }
                if (selClassName == null) {
                    System.out.println("No selector specified");
                    return;
                }
                if (formatClassName == null) {
                    System.out.println("No input format specified");
                    return;
                }
                ProbeAcceptor acceptor = (ProbeAcceptor)Class.forName(accClassName).newInstance();
                if (acceptor instanceof ParameterPlugIn && (dds3 = (paAcceptor = (ParameterPlugIn)acceptor).getDataDescriptors()) != null) {
                    for (int d = 0; d < dds3.length; ++d) {
                        DataDescriptor dd = dds3[d];
                        String string = props.getProperty("probemaker.acceptor." + dd.getKey());
                        paAcceptor.setData(dd.getKey(), (Object)string);
                    }
                }
                System.out.println("  Acceptor is: " + acceptor.getClass().getName());
                ProbeSelector selector = (ProbeSelector)Class.forName(selClassName).newInstance();
                if (selector instanceof ParameterPlugIn && (dds2 = (paSelector = (ParameterPlugIn)selector).getDataDescriptors()) != null) {
                    for (int d = 0; d < dds2.length; ++d) {
                        DataDescriptor dd = dds2[d];
                        String string = props.getProperty("probemaker.selector." + dd.getKey());
                        paSelector.setData(dd.getKey(), (Object)string);
                    }
                }
                System.out.println("  Selector is: " + selector.getClass().getName());
                SequenceDBDataReader format = (SequenceDBDataReader)Class.forName(formatClassName).newInstance();
                if (format instanceof ParameterPlugIn && (dds = (paFormat = (ParameterPlugIn)selector).getDataDescriptors()) != null) {
                    for (int d = 0; d < dds.length; ++d) {
                        DataDescriptor dd = dds[d];
                        String string = props.getProperty("probemaker.targetInputFormat." + dd.getKey());
                        paFormat.setData(dd.getKey(), (Object)string);
                    }
                }
                if (targetClassName == null) {
                    System.out.println("ERROR: Must specify a probemaker.targetType");
                    return;
                }
                Class<?> targetClass = Class.forName(targetClassName);
                SequenceBuilder seqBuilder = (SequenceBuilder)targetClass.getMethod("getSequenceBuilder", null).invoke(null, (Object[])null);
                System.out.println("  Format is: " + format.getClass().getName());
                System.out.println("  Target type is: " + targetClass.getName());
                DefaultTargetInputFormat tif = new DefaultTargetInputFormat("Input format", format, null, seqBuilder, ListSequenceDB.getDefaultBuilder());
                System.out.println("  Loading tag libs");
                int ti = 0;
                ArrayList<DefaultTagLibrary> libs = new ArrayList<DefaultTagLibrary>();
                while (props.containsKey("probemaker.taglibrary." + ti)) {
                    String taglibString = props.getProperty("probemaker.taglibrary." + ti);
                    String[] split = taglibString.split(":");
                    byte mode = Byte.parseByte(split[0]);
                    String libFileName = split[1];
                    File libFile = new File(libFileName);
                    if (!libFile.getAbsolutePath().equals(libFile.getPath())) {
                        libFile = new File(settingsFile.getAbsoluteFile().getParentFile(), libFile.getPath());
                    }
                    DefiniteSequenceDB tagseqs = SequenceIO.readSequenceDB((Reader)new FileReader(libFile), (SequenceDBDataReader)new FastaDBFormat(), null, (SequenceDBBuilder)ListSequenceDB.getDefaultBuilder(), (ObjectBuilder)new SimpleDNASequenceBuilder());
                    DefaultTagLibrary lib = new DefaultTagLibrary((DefiniteSequenceDB<? extends NucleotideSequence>)tagseqs, "taglib" + ti);
                    lib.setMode(mode);
                    libs.add(lib);
                    ++ti;
                }
                project.setTagLibraries(libs.toArray(new TagLibrary[libs.size()]));
                System.out.println("  Loading targets");
                new TargetIOTask(project, callback, new Reader[]{new FileReader(targetFile)}, tif).run();
                System.out.println("Done");
                File logPath = new File("");
                System.out.println("Writing log to: " + logPath);
                boolean append = false;
                TagAllocator ta = (TagAllocator)ProbeMakerPlugIn.defaultTagAllocatorClass.newInstance();
                TSSConstructor tsc = (TSSConstructor)ProbeMakerPlugIn.defaultTSSConstructorClass.newInstance();
                ta.addParameters(s.getDesignParameters());
                tsc.addParameters(s.getDesignParameters());
                DefaultProbeDesigner pd = new DefaultProbeDesigner(ta);
                ProbeDesignTask runner = pm.getProbeDesignTask(append, false, true, acceptor, selector, pd, tsc, callback);
                runner.timing = true;
                runner.verbose = true;
                System.out.println("Starting design of " + runner.getMaxProgress() + " probe groups");
                runner.run();
                System.out.println("Design completed in " + runner.getTotalTime() / 1000L + " seconds");
                System.out.println("Generated " + runner.getCandidatesGenerated() + " candidates");
                ChangeableIndexedSequenceDB<Probe> db = pm.project.getProbes();
                for (byte b = 3; b >= 1; b = (byte)(b - 1)) {
                    System.out.println(ProbeSummarizer.getQualityCount(db, b) + " probes of " + ProbeMakerConstants.qualityStrings[b] + " quality");
                }
                SequenceIO.writeSequenceDB((Writer)new FileWriter(outputFile), pm.project.getProbes(), (SequenceDBWriter)new TextTableDBFormat((TextTableFormatter)new DefaultTextTableFormatter()), null);
            }
            catch (Exception e) {
                System.err.println("An exception was caught:\n" + e.getMessage());
                e.printStackTrace();
            }
            catch (Error er) {
                System.err.println("An error was caught:\n" + er.getMessage());
                er.printStackTrace();
            }
        } else if (args[0].equals("-p")) {
            System.out.println("Running ProbeMaker with project file");
            if (args.length < 2) {
                System.out.println("Error: No project file specified");
                return;
            }
            try {
                byte by;
                ProbeMakerPlugIn pm = new ProbeMakerPlugIn();
                CommandLineErrorCallback callback = new CommandLineErrorCallback();
                File projectFile = new File(args[1]);
                if (!projectFile.exists()) {
                    System.out.println("Error: Could not find project file: " + args[1]);
                    return;
                }
                System.out.println("Loading project");
                new ProjectXMLIOTask((ProjectHolder)pm, (ErrorHandler)callback, new FileReader(projectFile)).run();
                System.out.println("Done");
                ProbeAcceptor acceptor = (ProbeAcceptor)ProbeMakerPlugIn.defaultProbeSelectorClass.newInstance();
                ProbeSelector selector = (ProbeSelector)ProbeMakerPlugIn.defaultProbeSelectorClass.newInstance();
                for (int i = 2; i < args.length; ++i) {
                    int j;
                    Object[] values;
                    DataDescriptor[] params;
                    if (args[i].equals("-a") || args[i].equals("-A")) {
                        if (++i < args.length) {
                            acceptor = (ProbeAcceptor)Class.forName(args[i]).newInstance();
                            if (acceptor instanceof ParameterPlugIn) {
                                ParameterPlugIn paAcceptor = (ParameterPlugIn)acceptor;
                                params = paAcceptor.getDataDescriptors();
                                ++i;
                                if (params != null) {
                                    values = new Object[params.length];
                                    try {
                                        for (j = 0; j < params.length; ++j) {
                                            values[j] = args[i];
                                            ++i;
                                        }
                                        DataHolderUtils.putOrderedData((Object[])values, (DataHolder)paAcceptor);
                                    }
                                    catch (ArrayIndexOutOfBoundsException ax) {
                                        System.out.println("Error: Wrong number of acceptor parameters");
                                        return;
                                    }
                                    catch (NumberFormatException ax) {
                                        System.out.println("Error: Wrong number of acceptor parameters");
                                        return;
                                    }
                                }
                            }
                        } else {
                            System.out.println("Error: No acceptor argument");
                            return;
                        }
                    }
                    if (i >= args.length) break;
                    if (!args[i].equals("-s") && !args[i].equals("-S")) continue;
                    if (++i < args.length) {
                        selector = (ProbeSelector)Class.forName(args[i]).newInstance();
                        if (!(selector instanceof ParameterPlugIn)) continue;
                        ParameterPlugIn paSelector = (ParameterPlugIn)selector;
                        params = paSelector.getDataDescriptors();
                        ++i;
                        if (params == null) continue;
                        values = new Object[params.length];
                        try {
                            for (j = 0; j < params.length; ++j) {
                                values[j] = args[i];
                                ++i;
                            }
                            DataHolderUtils.putOrderedData((Object[])values, (DataHolder)paSelector);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ax) {
                            System.out.println("Error: Wrong number of selector parameters");
                            return;
                        }
                        catch (NumberFormatException ax) {
                            System.out.println("Error: Wrong number of selector parameters");
                            return;
                        }
                    }
                    System.out.println("Error: No selector argument");
                    return;
                }
                boolean append = false;
                System.out.println("Using acceptor: " + acceptor.getClass());
                System.out.println("Using selector: " + selector.getClass());
                File logPath = new File("");
                System.out.println("Writing log to: " + logPath);
                TagAllocator ta = (TagAllocator)ProbeMakerPlugIn.defaultTagAllocatorClass.newInstance();
                TSSConstructor tsc = (TSSConstructor)ProbeMakerPlugIn.defaultTSSConstructorClass.newInstance();
                ProbeDesignTask runner = pm.getProbeDesignTask(append, false, true, acceptor, selector, new DefaultProbeDesigner(ta), tsc, callback);
                runner.timing = true;
                runner.verbose = true;
                System.out.println("Starting design of " + runner.getMaxProgress() + " probe groups");
                runner.run();
                System.out.println("Design completed in " + runner.getTotalTime() / 1000L + " seconds");
                System.out.println("Generated " + runner.getCandidatesGenerated() + " candidates");
                ChangeableIndexedSequenceDB<Probe> db = pm.project.getProbes();
                int n = 3;
                while (by >= 1) {
                    System.out.println(ProbeSummarizer.getQualityCount(db, by) + " probes of " + ProbeMakerConstants.qualityStrings[by] + " quality");
                    by = (byte)(by - true);
                }
                new ProjectXMLIOTask((ProjectHolder)pm, (ErrorHandler)callback, new FileWriter(projectFile.getAbsolutePath() + ".output")).run();
                SequenceIO.writeSequenceDB((Writer)new PrintWriter(System.out), pm.project.getProbes(), (SequenceDBWriter)new TextTableDBFormat((TextTableFormatter)new DefaultTextTableFormatter()), null);
            }
            catch (Exception e) {
                System.err.println("An exception was caught:\n" + e.getMessage());
                e.printStackTrace();
            }
            catch (Error er) {
                System.err.println("An error was caught:\n" + er.getMessage());
                er.printStackTrace();
            }
        } else {
            System.out.println("Unrecognized ProbeMaker command");
            ProbeMakerLauncher.printUsage(System.out);
        }
    }

    static void printUsage(PrintStream ps) {
        ps.println("Usage:\nProbeMaker [-h] | [-f file [options]]\nOptions:\n\t-h display this text\n\t-f file mode, requires \"file\" to be a project text file\n\t-a acceptor\tuses specified acceptor (full class name)\n\t-a selector\tuses specified selector (full class name)\n");
    }
}

