/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.utils.HTMLLogWriter;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.design.TSSPairDesigner;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.project.Settings;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.seq.db.SequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTSSPairDesigner
extends AbstractParameterHolder
implements ProbeMakerConstants,
TSSPairDesigner {
    public static Map<String, String> defaultParameters = new HashMap<String, String>();
    protected TSSConstructor tssConstructor;
    protected SequenceDB<ProbeMakerTarget> targets;
    protected HTMLLogWriter log;
    private String statusMessage;

    public Map<String, String> getDefaultParameters() {
        return defaultParameters;
    }

    @Override
    public void setProject(Project proj) {
        this.targets = proj.getTargets();
        Settings s = proj.getSettings();
        Map<String, String> params = s.getDesignParameters();
        this.addParameters(params);
    }

    public DefaultTSSPairDesigner(TSSConstructor con) {
        this.tssConstructor = con;
        this.setParameters(this.getDefaultParameters());
    }

    public void addParameters(Map<String, String> p) {
        super.addParameters(p);
        if (this.tssConstructor != null) {
            this.tssConstructor.addParameters(p);
        }
    }

    public void setParameters(Map<String, String> p) {
        super.setParameters(p);
        if (this.tssConstructor != null) {
            this.tssConstructor.setParameters(p);
        }
    }

    protected void setStatus(String status) {
        this.statusMessage = status;
    }

    @Override
    public String getStatus() {
        return this.statusMessage;
    }

    @Override
    public void setLog(HTMLLogWriter p) {
        this.log = p;
    }

    @Override
    public TSSPair designTSSPair(ProbeMakerTarget target) {
        byte probeAcidType = Byte.parseByte((String)this.parameters.get("PROBE_ACID_TYPE"));
        this.setStatus("Constructing 5' TSS");
        PropertyAcceptorNucleotideSequence tss5 = this.tssConstructor.get5PrimeTSS(target, probeAcidType);
        this.setStatus("Constructing 3' TSS");
        PropertyAcceptorNucleotideSequence tss3 = this.tssConstructor.get3PrimeTSS(target, probeAcidType);
        return ProbeMakerSequenceFactory.createTSSPair(tss5, tss3, target);
    }

    static {
        defaultParameters.put("PROBE_ACID_TYPE", Byte.toString((byte)0));
    }
}

