/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.SpacerLibrary;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.design.data.Candidate;
import org.moltools.design.data.Group;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.Identifiable;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagAllocationTable {
    private Map<String, Collection<KeyValue>> tagMap = new HashMap<String, Collection<KeyValue>>();
    private Map<String, String> groupTagMap = new HashMap<String, String>();
    private TagLibrary[] taglibraries;
    private Collection<String>[] usedLists;
    private int spacerPos;
    private boolean useSpacer;

    public void use(NucleotideSequence tag, Candidate user, int tagpos) {
        ProbeGroup pg;
        String tagID = tag.getID();
        this.tagMap.put(tagID, new ArrayList<DefaultKeyValue>(Collections.singleton(new DefaultKeyValue((Object)user.getID(), (Object)new Integer(tagpos)))));
        this.usedLists[tagpos].add(tagID);
        byte mode = this.taglibraries[tagpos].getMode();
        if (mode == 3 && (pg = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)user, (String)"probeGroup")) != null && pg.getID() != "DUMMY") {
            String groupTagID = this.getGroupTagID((Group<?>)pg);
            if (groupTagID != null) {
                if (!groupTagID.equals(tagID)) {
                    throw new UnsupportedOperationException("Tried to use a tag different from the group tag that was fixed");
                }
            } else {
                this.setGroupTagID((Group<?>)pg, (Identifiable)tag);
            }
        }
    }

    public void unuse(NucleotideSequence t, Probe p) {
        String tagID = t.getID();
        ArrayList<KeyValue> c = new ArrayList<KeyValue>(this.tagMap.get(tagID));
        for (KeyValue kv : c) {
            ProbeGroup pg;
            String userID = (String)kv.getKey();
            int tagpos = (Integer)kv.getValue();
            byte mode = this.taglibraries[tagpos].getMode();
            if (!userID.equals(p.getID())) continue;
            this.tagMap.get(tagID).remove(kv);
            Collection<KeyValue> left = this.tagMap.get(tagID);
            if (left != null) {
                if (left.isEmpty()) {
                    this.tagMap.remove(tagID);
                    this.usedLists[tagpos].remove(tagID);
                }
            } else {
                this.usedLists[tagpos].remove(tagID);
            }
            if (mode != 3 || (pg = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)p, (String)"probeGroup")) == null || this.tagMap.containsKey(tagID)) continue;
            this.clearGroupTagID((Group<?>)pg);
        }
    }

    protected boolean isUsedInPos(NucleotideSequence tag, int pos) {
        return this.usedLists[pos].contains(tag.getID());
    }

    public void clearProbe(Probe p) {
        for (NucleotideSequence tag : p.getTags()) {
            this.unuse(tag, p);
        }
    }

    public void clearTag(NucleotideSequence t) {
        this.tagMap.remove(t.getID());
        Iterator<Map.Entry<String, String>> i = this.groupTagMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> e = i.next();
            if (!e.getValue().equals(t.getID())) continue;
            i.remove();
        }
        for (int i2 = 0; i2 < this.usedLists.length; ++i2) {
            this.usedLists[i2].remove(t.getID());
        }
    }

    protected boolean isUsed(NucleotideSequence t) {
        Collection<KeyValue> c = this.tagMap.get(t.getID());
        if (c == null) {
            return false;
        }
        return c.size() > 0;
    }

    protected boolean isUsedOutsideUIGPosition(NucleotideSequence t) {
        Collection<KeyValue> c = this.tagMap.get(t.getID());
        if (c == null) {
            return false;
        }
        for (KeyValue kv : c) {
            int pos = (Integer)kv.getValue();
            byte mode = this.taglibraries[pos].getMode();
            if (mode == 4) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getUserIDs(NucleotideSequence t) {
        Collection<KeyValue> c = this.tagMap.get(t.getID());
        if (c == null) {
            return Collections.emptySet();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (KeyValue kv : c) {
            list.add((String)kv.getKey());
        }
        return list;
    }

    public boolean equals(Object arg0) {
        TagAllocationTable other = (TagAllocationTable)arg0;
        return ((Object)this.tagMap).equals(other.tagMap) && ((Object)this.groupTagMap).equals(other.groupTagMap);
    }

    public String toString() {
        StringBuffer string = new StringBuffer("\n");
        string.append("Tag usage:  " + this.tagMap.toString() + "\n");
        string.append("Group tags: " + this.groupTagMap.toString() + "\n");
        for (int i = 0; i < this.taglibraries.length; ++i) {
            string.append(i + ": " + this.usedLists[i] + "\n");
        }
        return string.toString();
    }

    public void clear() {
        this.tagMap.clear();
        this.groupTagMap.clear();
    }

    public String getGroupTagID(Group<?> group) {
        String id = this.groupTagMap.get(group.getID());
        return id;
    }

    public void setGroupTagID(Group<?> group, Identifiable tag) {
        if (this.groupTagMap.containsKey(group.getID())) {
            throw new UnsupportedOperationException("Cannot set tag for a group that already has tag set");
        }
        this.groupTagMap.put(group.getID(), tag.getID());
    }

    protected void clearGroupTagID(Group<?> group) {
        this.groupTagMap.remove(group.getID());
    }

    public void setTagLibraries(TagLibrary[] taglibs) {
        this.taglibraries = taglibs;
        this.usedLists = new Collection[taglibs.length];
        for (int i = 0; i < this.usedLists.length; ++i) {
            this.usedLists[i] = new LinkedHashSet<String>();
        }
        this.spacerPos = -1;
        this.useSpacer = false;
        this.clear();
    }

    public void setSpacerSettings(Map<String, String> parameters) {
        boolean newUseSpacer = new Boolean(parameters.get("USE_SPACER"));
        if (!this.useSpacer && !newUseSpacer) {
            return;
        }
        if (this.useSpacer && !newUseSpacer) {
            ArrayList<TagLibrary> libs = new ArrayList<TagLibrary>(Arrays.asList(this.taglibraries));
            List<Collection<String>> usedListsAsList = Arrays.asList(this.usedLists);
            ArrayList<Collection<String>> used = new ArrayList<Collection<String>>(usedListsAsList);
            libs.remove(this.spacerPos);
            ((Collection)used.remove(this.spacerPos)).clear();
            this.taglibraries = libs.toArray(new TagLibrary[libs.size()]);
            this.usedLists = used.toArray(new Collection[used.size()]);
            this.useSpacer = false;
            this.spacerPos = -1;
            return;
        }
        int newSpacerPos = Integer.parseInt(parameters.get("SPACER_POSITION"));
        String spacerString = parameters.get("SPACER_SEQUENCE");
        if (spacerString == null) {
            spacerString = "";
        }
        String spacerSequence = "";
        for (int i = 0; i < spacerString.length(); ++i) {
            Nucleotide nt = NucleotideSequenceHandler.getNucleotide((char)spacerString.charAt(i), (byte)0);
            if (nt == null) {
                throw new UnsupportedOperationException("Invalid spacer sequence");
            }
            spacerSequence = spacerSequence + nt.getChar();
        }
        ArrayList<TagLibrary> libs = new ArrayList<TagLibrary>(Arrays.asList(this.taglibraries));
        ArrayList<Collection<String>> used = new ArrayList<Collection<String>>(Arrays.asList(this.usedLists));
        if (!this.useSpacer) {
            if (newSpacerPos < 0 || newSpacerPos > this.taglibraries.length) {
                throw new IllegalArgumentException("Invalid spacer position");
            }
            SpacerLibrary spacerLib = new SpacerLibrary(0, 0);
            LinkedHashSet spacerUsed = new LinkedHashSet();
            libs.add(newSpacerPos, spacerLib);
            used.add(newSpacerPos, spacerUsed);
            this.taglibraries = libs.toArray(new TagLibrary[libs.size()]);
            this.usedLists = used.toArray(new Collection[used.size()]);
        } else {
            if (newSpacerPos < 0 || newSpacerPos > this.taglibraries.length - 1) {
                throw new IllegalArgumentException("Invalid spacer position");
            }
            TagLibrary spacerLib = this.taglibraries[this.spacerPos];
            Collection<String> spacerUsed = this.usedLists[this.spacerPos];
            libs.remove(this.spacerPos);
            used.remove(this.spacerPos);
            libs.add(newSpacerPos, spacerLib);
            used.add(newSpacerPos, spacerUsed);
            this.taglibraries = libs.toArray(new TagLibrary[libs.size()]);
            this.usedLists = used.toArray(new Collection[used.size()]);
        }
        this.useSpacer = true;
        this.spacerPos = newSpacerPos;
    }

    public void setTagLibraries(TagLibrary[] libs, Map<String, String> parameters) {
        this.setTagLibraries(libs);
        if (parameters != null) {
            this.setSpacerSettings(parameters);
        }
    }

    public void clearUsed() {
        if (this.taglibraries != null) {
            for (int i = 0; i < this.taglibraries.length; ++i) {
                for (String id : new ArrayList<String>(this.usedLists[i])) {
                    try {
                        this.clearTag((NucleotideSequence)this.taglibraries[i].getSequenceByID(id));
                    }
                    catch (IDNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public boolean isUsable(int tagpos, int tagno, Group<?> group) {
        boolean usable = false;
        TagLibrary lib = this.taglibraries[tagpos];
        Collection<String> usedTagIDs = this.usedLists[tagpos];
        byte mode = lib.getMode();
        NucleotideSequence tag = (NucleotideSequence)lib.getSequenceAt(tagno);
        switch (mode) {
            case 2: {
                usable = true;
                break;
            }
            case 0: {
                if (usedTagIDs.isEmpty()) {
                    usable = true;
                    break;
                }
                usable = usedTagIDs.contains(tag.getID());
                if (usedTagIDs.size() <= 1) break;
                throw new IllegalStateException("Cannot have two ids in same mode");
            }
            case 1: {
                usable = !this.isUsed(tag);
                break;
            }
            case 3: {
                if (group == null) {
                    usable = !this.isUsed(tag);
                    break;
                }
                String tagID = this.getGroupTagID(group);
                if (tagID != null) {
                    usable = tagID.equals(tag.getID());
                    break;
                }
                usable = !this.isUsed(tag);
                break;
            }
            case 4: {
                if (this.isUsedOutsideUIGPosition(tag)) {
                    usable = false;
                    break;
                }
                if (group == null) {
                    usable = true;
                    break;
                }
                if (this.isUsedInGroup(tag, group)) {
                    usable = false;
                    break;
                }
                if (group.getMembers().size() > usedTagIDs.size()) {
                    usable = true;
                    break;
                }
                usable = this.isUsed(tag);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Incorrect or no Tag usage mode specified");
            }
        }
        return usable;
    }

    protected boolean isUsedInGroup(NucleotideSequence t, Group<?> group) {
        if (group == null) {
            return false;
        }
        boolean ingroup = false;
        Collection<KeyValue> userEntries = this.tagMap.get(t.getID());
        if (userEntries == null) {
            return false;
        }
        for (KeyValue kv : userEntries) {
            String userID = (String)kv.getKey();
            for (Identifiable other : group.getMembers()) {
                if (!other.getID().equals(userID)) continue;
                ingroup = true;
            }
        }
        return ingroup;
    }
}

