/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.alignment;

import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;

public class AlignmentUtils {
    public static Alignment translateSecondStrand(Alignment la, int offset) {
        int i;
        int new1Start = la.getFirstStart();
        int new1End = la.getFirstEnd();
        int new2Start = la.getSecondStart() + offset;
        int new2End = la.getSecondEnd() + offset;
        String newFirst = la.getFirstString();
        String newSecond = la.getSecondString();
        if (new2End <= 0) {
            return null;
        }
        if (new2Start >= 1) {
            return new SimpleAlignment(new1Start, new1End, newFirst, new2Start, new2End, newSecond);
        }
        int initTrunc = 1 - new2Start;
        int trunc = 0;
        int strLen = newSecond.length();
        for (i = 0; i < strLen; ++i) {
            if (newSecond.charAt(i) != '-') {
                ++trunc;
            }
            if (trunc == initTrunc) break;
        }
        newFirst = newFirst.substring(i + 1);
        newSecond = newSecond.substring(i + 1);
        new1Start = la.getFirstStart() + (i + 1);
        new2Start = 1;
        SimpleAlignment newalign = new SimpleAlignment(new1Start, new1End, newFirst, new2Start, new2End, newSecond);
        return newalign;
    }
}

