/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.alphabet;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.NAAlphabet;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.alphabet.Symbol;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class DefaultDNAAlphabet
implements NAAlphabet {
    static final Nucleotide dA;
    static final Nucleotide dC;
    static final Nucleotide dG;
    static final Nucleotide dT;
    static final Nucleotide A;
    static final Nucleotide C;
    static final Nucleotide G;
    static final Nucleotide U;
    static final Collection<Nucleotide> nucleotides;
    static final Map<Nucleotide, Nucleotide>[][] complementTables;
    static final NAAlphabet defaultAlphabet;

    DefaultDNAAlphabet() {
    }

    public static NAAlphabet getAlphabet() {
        return defaultAlphabet;
    }

    public Symbol[] getSymbols() {
        return nucleotides.toArray(new Symbol[nucleotides.size()]);
    }

    public boolean contains(Object o) {
        if (o instanceof Nucleotide) {
            return nucleotides.contains(o);
        }
        throw new IllegalArgumentException("Wrong symbol type for NA alphabet");
    }

    public Nucleotide getNucleotide(char symbol, byte type) {
        for (Nucleotide n : nucleotides) {
            if (n.getChar() != Character.toUpperCase(symbol) || n.getType() != type) continue;
            return n;
        }
        return null;
    }

    public DegenerateNucleotide getDegenerateNucleotide(char[] varsymbols, byte type) {
        Nucleotide[] vars = new Nucleotide[varsymbols.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.getNucleotide(varsymbols[i], type);
        }
        Iterator<Nucleotide> i = nucleotides.iterator();
        while (i.hasNext()) {
            try {
                DegenerateNucleotide dn = (DegenerateNucleotide)i.next();
                if (!dn.hasPossible(vars)) continue;
                return dn;
            }
            catch (ClassCastException ccx) {
            }
        }
        return null;
    }

    public Iterator iterator() {
        return nucleotides.iterator();
    }

    public boolean isSingleNucleotide(Nucleotide n) {
        if (n == null) {
            return false;
        }
        return nucleotides.contains(n) && !(n instanceof DegenerateNucleotide);
    }

    public boolean isDegenerateNucleotide(Nucleotide n) {
        if (n == null) {
            return false;
        }
        return nucleotides.contains(n) && n instanceof DegenerateNucleotide;
    }

    public String toString() {
        String str = "";
        Object[] nucs = nucleotides.toArray();
        for (int i = 0; i < nucs.length; ++i) {
            Nucleotide n = (Nucleotide)nucs[i];
            str = str + n;
            if (this.isDegenerateNucleotide(n)) {
                Nucleotide[] poss = ((DegenerateNucleotide)n).getPossible();
                str = str + ": ";
                for (int j = 0; j < poss.length; ++j) {
                    str = str + poss[j] + " ";
                }
            }
            str = str + " (" + NucleotideSequenceHandler.getTypeString(n.getType()) + ")\n";
        }
        return str;
    }

    public Nucleotide getComplementNucleotide(Nucleotide n, byte type) {
        byte type1 = n.getType();
        Nucleotide nt = complementTables[type1][type].get(n);
        if (nt == null) {
            throw new UnsupportedOperationException("No complement found for " + n.getChar());
        }
        return nt;
    }

    static {
        nucleotides = new HashSet<Nucleotide>();
        dA = new Nucleotide('A', 0);
        dC = new Nucleotide('C', 0);
        dG = new Nucleotide('G', 0);
        dT = new Nucleotide('T', 0);
        A = new Nucleotide('A', 1);
        C = new Nucleotide('C', 1);
        G = new Nucleotide('G', 1);
        U = new Nucleotide('U', 1);
        nucleotides.add(dA);
        nucleotides.add(dG);
        nucleotides.add(dC);
        nucleotides.add(dT);
        complementTables = new Map[2][2];
        DefaultDNAAlphabet.complementTables[0][0] = new HashMap<Nucleotide, Nucleotide>();
        DefaultDNAAlphabet.complementTables[0][1] = new HashMap<Nucleotide, Nucleotide>();
        DefaultDNAAlphabet.complementTables[1][0] = new HashMap<Nucleotide, Nucleotide>();
        DefaultDNAAlphabet.complementTables[1][1] = new HashMap<Nucleotide, Nucleotide>();
        complementTables[0][0].put(dA, dT);
        complementTables[0][0].put(dC, dG);
        complementTables[0][0].put(dG, dC);
        complementTables[0][0].put(dT, dA);
        complementTables[0][1].put(dA, U);
        complementTables[0][1].put(dC, G);
        complementTables[0][1].put(dG, C);
        complementTables[0][1].put(dT, A);
        complementTables[1][0].put(A, dT);
        complementTables[1][0].put(C, dG);
        complementTables[1][0].put(G, dC);
        complementTables[1][0].put(U, dA);
        complementTables[1][1].put(A, U);
        complementTables[1][1].put(C, G);
        complementTables[1][1].put(G, C);
        complementTables[1][1].put(U, A);
        defaultAlphabet = new DefaultDNAAlphabet();
    }
}

