/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.db.impl;

import java.util.Collection;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SubSequenceDescriptor;
import org.moltools.lib.seq.db.SequenceDB;
import org.moltools.lib.seq.db.SubSequenceStringResolver;
import org.moltools.lib.seq.db.impl.HashMapSequenceDB;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubSequenceStringResolver
implements SubSequenceStringResolver {
    protected SequenceDB<? extends Sequence> sequences;

    public DefaultSubSequenceStringResolver(SequenceDB<? extends Sequence> sequences) {
        this.sequences = sequences;
    }

    public <T extends Sequence> DefaultSubSequenceStringResolver(Collection<T> seqs) throws DuplicateIDException {
        this.sequences = new HashMapSequenceDB<Sequence>(seqs);
    }

    @Override
    public String getSequenceString(SubSequenceDescriptor subseq) throws IDNotFoundException {
        Sequence parent = this.sequences.getSequenceByID(subseq.getParentID());
        if (parent == null) {
            throw new IDNotFoundException(subseq.getParentID());
        }
        int start = subseq.getStart();
        int end = subseq.getEnd();
        String sequence = parent.subsequence(start, end);
        if (parent instanceof NucleotideSequence) {
            if (subseq instanceof PolarSubSequenceDescriptor) {
                sequence = NucleotideSequenceHandler.getNucleotideSubSequenceString((NucleotideSequence)parent, (PolarSubSequenceDescriptor)subseq);
            } else {
                throw new IllegalArgumentException("A polar sub-sequence descriptor is required for nucleotide sequence substring extraction");
            }
        }
        return sequence;
    }
}

