/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.db.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.apptools.textio.ObjectBuilder;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.AbstractChangeableDefiniteSequenceDB;
import org.moltools.lib.utils.IDMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapSequenceDB<T extends Sequence>
extends AbstractChangeableDefiniteSequenceDB<T> {
    protected IDMap<T> sequences = new IDMap();

    public static SequenceDBBuilder getDefaultBuilder() {
        SequenceDBBuilder dbbuilder = new SequenceDBBuilder(){

            public <S extends Sequence> HashMapSequenceDB<S> buildDB(Collection<Map<String, String>> maps, ObjectBuilder<S> sb) throws DuplicateIDException {
                HashMapSequenceDB<Sequence> db = new HashMapSequenceDB<Sequence>();
                Iterator<Map<String, String>> i = maps.iterator();
                while (i.hasNext()) {
                    db.addSequence((Sequence)sb.buildObject(i.next()));
                }
                return db;
            }
        };
        return dbbuilder;
    }

    public HashMapSequenceDB() {
    }

    public HashMapSequenceDB(Collection<T> seqs) throws DuplicateIDException {
        this();
        this.addSequences(seqs);
    }

    public HashMapSequenceDB(DefiniteSequenceDB<T> seqs) throws DuplicateIDException {
        this(seqs.getSequenceCollection());
    }

    @Override
    public void clear() {
        this.sequences.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.sequences.isEmpty();
    }

    @Override
    public int size() {
        return this.sequences.size();
    }

    @Override
    public Iterator<T> iterator() {
        Collection seqs = this.sequences.values();
        return seqs.iterator();
    }

    @Override
    public T getSequenceByID(String id) throws IDNotFoundException {
        Sequence s = (Sequence)this.sequences.get(id);
        if (s == null) {
            throw new IDNotFoundException("Could not find " + id);
        }
        return (T)s;
    }

    protected boolean addSequenceInternal(T seq) throws DuplicateIDException {
        if (this.sequences.containsKey(seq.getID())) {
            throw new DuplicateIDException("DB already contains a sequence with ID " + seq.getID());
        }
        this.sequences.add(seq);
        return true;
    }

    @Override
    public boolean addSequence(T seq) throws DuplicateIDException {
        boolean success = this.addSequenceInternal(seq);
        this.fireChangeEvent();
        return success;
    }

    @Override
    public void addSequences(DefiniteSequenceDB<? extends T> db) throws DuplicateIDException {
        this.addSequences(db.getSequenceCollection());
        this.fireChangeEvent();
    }

    @Override
    public void addSequences(Collection<? extends T> seqs) throws DuplicateIDException {
        Iterator<T> seqI = seqs.iterator();
        while (seqI.hasNext()) {
            this.addSequenceInternal((Sequence)seqI.next());
        }
        this.fireChangeEvent();
    }

    public boolean removeSequence(Sequence seq) {
        Object o = this.sequences.remove(seq.getID());
        this.fireChangeEvent();
        return o != null;
    }

    @Override
    public boolean removeSequenceByID(String id) {
        Object o = this.sequences.remove(id);
        this.fireChangeEvent();
        return o != null;
    }

    @Override
    public Collection<T> getSequenceCollection() {
        return new HashSet(this.sequences.values());
    }
}

