/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.impl;

import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;

public class SimpleNucleotideSubSequence
extends SimpleNucleotideSequence
implements NucleotideSequence,
PolarSubSequenceDescriptor {
    protected byte polarity;
    protected String parentID;
    protected int subStart;
    protected int subEnd;

    public SimpleNucleotideSubSequence() {
        this("", "", 0, "", 1, 0, 0);
    }

    public SimpleNucleotideSubSequence(String id, String seq, byte type, String parentid, byte polarity, int start, int end) {
        super(id, seq, type);
        this.parentID = parentid;
        this.polarity = polarity;
        this.subStart = start;
        this.subEnd = end;
        if (seq.length() != end - start + 1) {
            throw new IllegalArgumentException("Incompatible length of sequence");
        }
    }

    public SimpleNucleotideSubSequence(String id, String seqString, byte type, PolarSubSequenceDescriptor subseqDesc) {
        this(id, seqString, type, subseqDesc.getParentID(), subseqDesc.getPolarity(), subseqDesc.getStart(), subseqDesc.getEnd());
    }

    public byte getPolarity() {
        return this.polarity;
    }

    public String getParentID() {
        return this.parentID;
    }

    public int getStart() {
        return this.subStart;
    }

    public int getEnd() {
        return this.subEnd;
    }
}

