/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.io.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.io.SequenceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaFormatter<T extends Sequence>
implements SequenceWriter<T>,
SequenceDataReader {
    protected int width = 60;
    protected boolean converttoupper = true;

    @Override
    public void writeSequence(PrintWriter ps, T s) {
        StringBuffer defline = new StringBuffer(">");
        defline.append(s.getID());
        ps.println(defline);
        String sequence = s.seqString();
        int length = sequence.length();
        for (int i = 0; i < length; i += this.width) {
            ps.println(sequence.substring(i, Math.min(i + this.width, length)));
        }
    }

    public void writeDataMap(PrintWriter ps, Map<String, String> dataMap) {
        StringBuffer defline = new StringBuffer(">");
        defline.append(dataMap.get("ID"));
        ps.println(defline);
        String sequence = dataMap.get("sequence.seqstring");
        int length = sequence.length();
        for (int i = 0; i < length; i += this.width) {
            ps.println(sequence.substring(i, Math.min(i + this.width, length)));
        }
    }

    public void setLineWidth(int newWidth) {
        this.width = newWidth;
    }

    protected boolean peekSequenceStart(BufferedReader pin) throws IOException {
        int i = pin.read();
        char c = (char)i;
        return c == '>';
    }

    protected boolean peekEOF(BufferedReader pin) throws IOException {
        int i = pin.read();
        return i < 0;
    }

    @Override
    public Map<String, String> readNextFormattedSequence(BufferedReader r) throws IOException {
        String name = "";
        String id = "";
        StringBuffer sequence = new StringBuffer();
        boolean state = false;
        boolean done = false;
        while (!done) {
            String defline;
            String line = r.readLine();
            if (line == null) {
                done = true;
                break;
            }
            if (line.length() == 0) break;
            if (!line.startsWith(">")) continue;
            id = defline = line.substring(1).trim();
            name = "";
            state = true;
            this.readSequenceData(r, sequence);
            break;
        }
        if (!state) {
            return null;
        }
        String seqstring = this.converttoupper ? sequence.toString().toUpperCase() : sequence.toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ID", id);
        map.put("sequence.name", name);
        map.put("sequence.seqstring", seqstring);
        return map;
    }

    private boolean readSequenceData(BufferedReader r, StringBuffer data) throws IOException {
        char[] buffer = new char[512];
        boolean done = false;
        boolean seenEOF = false;
        while (!done) {
            r.mark(buffer.length + 1);
            int bytesRead = r.read(buffer, 0, buffer.length);
            if (bytesRead < 0) {
                seenEOF = true;
                done = true;
                continue;
            }
            int parseStart = 0;
            int parseEnd = 0;
            while (!done && parseStart < bytesRead && buffer[parseStart] != '>') {
                for (parseEnd = parseStart; parseEnd < bytesRead && buffer[parseEnd] != '\n' && buffer[parseEnd] != '\r'; ++parseEnd) {
                }
                data.append(buffer, parseStart, parseEnd - parseStart);
                for (parseStart = parseEnd + 1; parseStart < bytesRead && (buffer[parseStart] == '\n' || buffer[parseStart] == '\r'); ++parseStart) {
                }
            }
            if (parseStart >= bytesRead || buffer[parseStart] != '>') continue;
            try {
                r.reset();
            }
            catch (IOException ioe) {
                throw new IOException("Can't reset: " + ioe.getMessage() + " parseStart=" + parseStart + " bytesRead=" + bytesRead);
            }
            if (r.skip(parseStart) != (long)parseStart) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            done = true;
        }
        return seenEOF;
    }

    public static String eatSpace(String str) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            s.append(c);
        }
        return s.toString();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isConverttoupper() {
        return this.converttoupper;
    }

    public void setConverttoupper(boolean converttoupper) {
        this.converttoupper = converttoupper;
    }
}

