/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.util.ArrayList;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.SubSequenceDescriptor;
import org.moltools.lib.seq.alphabet.DegenerateNAAlphabet;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.NAAlphabet;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.impl.EmptyRegion;
import org.moltools.lib.seq.impl.SimpleRegion;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.utils.IndexUtils;

public class NucleotideSequenceHandler
extends SequenceHandler {
    protected static final NAAlphabet standardSet = DegenerateNAAlphabet.degenerateAlphabet;
    public static final byte A = 0;
    public static final byte C = 1;
    public static final byte G = 2;
    public static final byte T = 3;
    public static final byte PAIR_SUM = 3;
    private static final String[] TYPE_STRINGS = new String[]{"DNA", "RNA"};

    public static Nucleotide getComplementNucleotide(Nucleotide n, byte complementType) {
        return standardSet.getComplementNucleotide(n, complementType);
    }

    public static Nucleotide getNucleotide(char symbol, byte type) {
        return standardSet.getNucleotide(symbol, type);
    }

    public static DegenerateNucleotide getDegenerateNucleotide(char[] symbols, byte type) {
        return standardSet.getDegenerateNucleotide(symbols, type);
    }

    public static DegenerateNucleotide getDegenerateNucleotide(Nucleotide[] nts, byte type) {
        char[] symbols = new char[nts.length];
        for (int i = 0; i < symbols.length; ++i) {
            symbols[i] = nts[i].getChar();
        }
        return standardSet.getDegenerateNucleotide(symbols, type);
    }

    public static String[] getPossibleSequences(String s, byte type) {
        ArrayList<String> l = new ArrayList<String>();
        Nucleotide[][] possible = new Nucleotide[s.length()][];
        int[] sizes = new int[possible.length];
        for (int i = 0; i < possible.length; ++i) {
            Nucleotide n = NucleotideSequenceHandler.getNucleotide(s.charAt(i), type);
            possible[i] = n instanceof DegenerateNucleotide ? ((DegenerateNucleotide)n).getPossible() : new Nucleotide[]{n};
            sizes[i] = possible[i].length - 1;
        }
        int[] startIndices = new int[sizes.length];
        int[] indices = new int[sizes.length];
        IndexUtils ii = new IndexUtils(startIndices, sizes);
        do {
            String str = "";
            for (int i = 0; i < possible.length; ++i) {
                str = str + possible[i][indices[i]].getChar();
            }
            l.add(str);
        } while ((indices = ii.updateIndices()) != null);
        return l.toArray(new String[l.size()]);
    }

    public static boolean isSingleNucleotide(Nucleotide n) {
        return standardSet.isSingleNucleotide(n);
    }

    public static boolean isDegenerateNucleotide(Nucleotide n) {
        return standardSet.isDegenerateNucleotide(n);
    }

    public static Nucleotide complementOf(Nucleotide n, byte complementType) {
        return standardSet.getComplementNucleotide(n, complementType);
    }

    public static boolean isBase(char c, byte type) {
        Nucleotide n = NucleotideSequenceHandler.getNucleotide(c, type);
        if (n == null) {
            return false;
        }
        return !(n instanceof DegenerateNucleotide);
    }

    public static boolean isBase(Nucleotide n) {
        return NucleotideSequenceHandler.isSingleNucleotide(n);
    }

    public static boolean isPoly(char c, byte type) {
        Nucleotide n = NucleotideSequenceHandler.getNucleotide(c, type);
        if (n == null) {
            return false;
        }
        return n instanceof DegenerateNucleotide;
    }

    public static boolean isPoly(Nucleotide n) {
        return NucleotideSequenceHandler.isDegenerateNucleotide(n);
    }

    public static Nucleotide[] getPossible(char c, byte type) {
        Nucleotide n = NucleotideSequenceHandler.getNucleotide(c, type);
        if (n == null) {
            throw new UnsupportedOperationException("Invalid symbol");
        }
        if (n instanceof DegenerateNucleotide) {
            return ((DegenerateNucleotide)n).getPossible();
        }
        return new Nucleotide[]{n};
    }

    public static char[] getPossibleSymbols(char c, byte type) {
        Nucleotide[] poss = NucleotideSequenceHandler.getPossible(c, type);
        char[] symbols = new char[poss.length];
        for (int i = 0; i < symbols.length; ++i) {
            symbols[i] = poss[i].getChar();
        }
        return symbols;
    }

    public static boolean isValid(String s) {
        for (int p = 0; p < s.length(); ++p) {
            if (NucleotideSequenceHandler.isValidSymbolOfAnyType(s.charAt(0))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSymbol(char c, byte type) {
        Nucleotide n = NucleotideSequenceHandler.getNucleotide(c, type);
        return n != null;
    }

    public static boolean isValidSymbolOfAnyType(char c) {
        Nucleotide n = NucleotideSequenceHandler.getNucleotide(c, (byte)0);
        if (n == null) {
            n = NucleotideSequenceHandler.getNucleotide(c, (byte)1);
        }
        return n != null;
    }

    public static boolean isValidNoGapSymbolOfAnyType(char c) {
        if (c == '-') {
            return false;
        }
        return NucleotideSequenceHandler.isValidSymbolOfAnyType(c);
    }

    public static int countPolys(String seq, byte type) {
        int polys = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (!NucleotideSequenceHandler.isPoly(seq.charAt(i), type)) continue;
            ++polys;
        }
        return polys;
    }

    public static int countPolys(NucleotideSequence seq) {
        int polys = 0;
        String seqstr = seq.seqString();
        for (int i = 0; i < seqstr.length(); ++i) {
            if (!NucleotideSequenceHandler.isPoly(seqstr.charAt(i), seq.getType())) continue;
            ++polys;
        }
        return polys;
    }

    public static String getComp(String seq, byte type) {
        String s = "";
        for (int i = 0; i < seq.length(); ++i) {
            s = s + NucleotideSequenceHandler.complementOf(NucleotideSequenceHandler.getNucleotide(seq.charAt(i), type), type).getChar();
        }
        return s;
    }

    public static String getComp(NucleotideSequence seq) {
        return NucleotideSequenceHandler.getComp(seq, seq.getType());
    }

    public static String getComp(NucleotideSequence seq, byte type) {
        return NucleotideSequenceHandler.getComp(seq.seqString(), type);
    }

    public static String getRevComp(String seq, byte typeSource, byte typeTarget) {
        if (seq == null) {
            return null;
        }
        String s = "";
        for (int i = seq.length() - 1; i >= 0; --i) {
            Nucleotide n = NucleotideSequenceHandler.getNucleotide(seq.charAt(i), typeSource);
            if (n == null) {
                throw new IllegalArgumentException("No such nucleotide: " + seq.charAt(i));
            }
            Nucleotide cn = standardSet.getComplementNucleotide(n, typeTarget);
            if (cn == null) {
                throw new IllegalArgumentException("No complement found for " + n);
            }
            s = s + cn.getChar();
        }
        return s;
    }

    public static String getRevComp(NucleotideSequence seq) {
        return NucleotideSequenceHandler.getRevComp(seq, seq.getType());
    }

    public static String getRevComp(NucleotideSequence seq, byte targettype) {
        return NucleotideSequenceHandler.getRevComp(seq.seqString(), seq.getType(), targettype);
    }

    public static byte[] getSequenceByteArray(NucleotideSequence sequence) {
        return NucleotideSequenceHandler.getSequenceStringByteArray(sequence.seqString());
    }

    public static byte[] getSequenceStringByteArray(String seq) {
        byte[] bytes = new byte[seq.length()];
        char[] chars = seq.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case 'A': {
                    bytes[i] = 0;
                    continue block6;
                }
                case 'C': {
                    bytes[i] = 1;
                    continue block6;
                }
                case 'G': {
                    bytes[i] = 2;
                    continue block6;
                }
                case 'T': {
                    bytes[i] = 3;
                }
            }
        }
        return bytes;
    }

    public static String getByteArrayString(byte[] sequence) {
        char[] chars = new char[sequence.length];
        block6: for (int i = 0; i < sequence.length; ++i) {
            switch (sequence[i]) {
                case 0: {
                    chars[i] = 65;
                    continue block6;
                }
                case 3: {
                    chars[i] = 84;
                    continue block6;
                }
                case 2: {
                    chars[i] = 71;
                    continue block6;
                }
                case 1: {
                    chars[i] = 67;
                }
            }
        }
        return new String(chars);
    }

    public static String getNucleotideSubSequenceString(NucleotideSequence parent, PolarSubSequenceDescriptor subseq) {
        int start = subseq.getStart();
        int end = subseq.getEnd();
        String sequence = parent.subsequence(start, end);
        if (subseq.getPolarity() == -1) {
            sequence = NucleotideSequenceHandler.getRevComp(sequence, parent.getType(), parent.getType());
        }
        return sequence;
    }

    public static Region getParentRegion(PolarSubSequenceDescriptor subseq, Region regionOnSubSeq) {
        int parentEnd;
        int parentStart;
        if (regionOnSubSeq.length() < 1) {
            return new EmptyRegion();
        }
        if (regionOnSubSeq.getStart() < 0 || regionOnSubSeq.getEnd() < 0) {
            parentStart = 0;
            parentEnd = -1;
        } else {
            switch (subseq.getPolarity()) {
                case 1: {
                    parentStart = subseq.getStart() + regionOnSubSeq.getStart() - 1;
                    parentEnd = parentStart + regionOnSubSeq.length() - 1;
                    break;
                }
                case -1: {
                    parentEnd = subseq.getEnd() - regionOnSubSeq.getStart() + 1;
                    parentStart = parentEnd - regionOnSubSeq.length() + 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect polarity");
                }
            }
        }
        return new SimpleRegion(parentStart, parentEnd);
    }

    public static int getParentPosition(PolarSubSequenceDescriptor subseq, int positionOnSubseq) {
        switch (subseq.getPolarity()) {
            case 1: {
                return subseq.getStart() + positionOnSubseq - 1;
            }
            case -1: {
                return subseq.getEnd() - positionOnSubseq + 1;
            }
        }
        throw new IllegalArgumentException("Incorrect polarity");
    }

    public static int getSubSequencePosition(PolarSubSequenceDescriptor subseq, int positionOnParent) {
        switch (subseq.getPolarity()) {
            case 1: {
                return positionOnParent - subseq.getStart() + 1;
            }
            case -1: {
                return subseq.getEnd() - positionOnParent + 1;
            }
        }
        throw new IllegalArgumentException("Incorrect polarity");
    }

    public static String makeSubSequenceID(PolarSubSequenceDescriptor ssd) {
        switch (ssd.getPolarity()) {
            case 1: {
                return ssd.getParentID() + ":" + ssd.getStart() + "-" + ssd.getEnd();
            }
            case -1: {
                return ssd.getParentID() + ":c(" + ssd.getStart() + "-" + ssd.getEnd() + ")";
            }
        }
        throw new IllegalArgumentException("Invalid polarity");
    }

    public static String makeSubSequenceID(SubSequenceDescriptor ssd, byte polarity) {
        switch (polarity) {
            case 1: {
                return ssd.getParentID() + ":" + ssd.getStart() + "-" + ssd.getEnd();
            }
            case -1: {
                return ssd.getParentID() + ":c(" + ssd.getStart() + "-" + ssd.getEnd() + ")";
            }
        }
        throw new IllegalArgumentException("Invalid polarity");
    }

    public static String getTypeString(byte type) {
        return TYPE_STRINGS[type];
    }
}

