/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.pof;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.apptools.plugin.PlugIn;
import net.sf.apptools.utils.HTMLWriter;
import org.moltools.apps.probemaker.ext.Messages;
import org.moltools.apps.probemaker.io.ProbeDBOutputFormat;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLOutputFormat<T extends Probe>
implements ProbeDBOutputFormat<T>,
PlugIn {
    protected static final String formatString = "##0.0";
    protected static NumberFormat tempFormat = new DecimalFormat("##0.0");
    protected static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    public static final String TITLE_STRING = "title";

    public static String getBriefDescription() {
        return Messages.getString("HTMLOutputFormat.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("HTMLOutputFormat.LONG_DESCRIPTION");
    }

    public void putSequenceDB(Writer out, DefiniteSequenceDB<? extends T> sequences, Map<?, ?> properties) {
        PrintWriter pw = new PrintWriter(out);
        HTMLWriter hw = new HTMLWriter(pw);
        String titleString = "No title";
        ArrayList<String> props = new ArrayList<String>();
        if (properties != null) {
            for (Map.Entry<?, ?> e : properties.entrySet()) {
                String keyString = e.getKey().toString();
                String valueString = e.getValue().toString();
                if (keyString.equals(TITLE_STRING)) {
                    titleString = keyString;
                    continue;
                }
                props.add(keyString + ": " + valueString);
            }
        }
        hw.printTag(HTMLWriter.HTML);
        hw.printAttributeTag(HTMLWriter.HEAD, new String[]{TITLE_STRING}, new String[]{titleString});
        hw.printEndTag(HTMLWriter.HEAD);
        hw.printTag(HTMLWriter.BODY);
        Iterator pi = props.iterator();
        while (pi.hasNext()) {
            pw.println(pi.next());
        }
        for (Object probe : sequences) {
            if (probe instanceof Probe) {
                PropertyAcceptorNucleotideSequence threePrime;
                PropertyAcceptorNucleotideSequence fivePrime;
                Probe p = (Probe)probe;
                try {
                    fivePrime = (PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
                }
                catch (ClusterException e) {
                    fivePrime = null;
                }
                try {
                    threePrime = (PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
                }
                catch (ClusterException e) {
                    threePrime = null;
                }
                hw.printEnclosed(p.getName(), HTMLWriter.H4);
                hw.println(Messages.getString("HTMLOutputFormat.ID") + p.getID());
                String seqstr = p.seqString();
                int index = 0;
                int width = 60;
                while (index <= seqstr.length() - width) {
                    hw.printEnclosed(seqstr.substring(index, index += width), HTMLWriter.TT);
                }
                hw.printEnclosed(seqstr.substring(index), HTMLWriter.TT);
                hw.printTag(HTMLWriter.BR);
                hw.println(p.getTarget() == null ? Messages.getString("HTMLOutputFormat.NO_TARGET") : Messages.getString("HTMLOutputFormat.TARGET") + p.getTarget().getID());
                hw.printEnclosed(Messages.getString("HTMLOutputFormat.BLOCKS"), HTMLWriter.H5);
                for (int i = 1; i <= p.getSequenceCount(); ++i) {
                    hw.println(((NucleotideSequence)p.getSequence(i)).getID() + ": " + ((NucleotideSequence)p.getSequence(i)).seqString());
                }
                hw.println(Messages.getString("HTMLOutputFormat.HYB_TEMPS_5") + tempFormat.format(fivePrime == null ? 0.0 : (double)ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)fivePrime)) + Messages.getString("HTMLOutputFormat.HYB_TEMPS_3") + tempFormat.format(threePrime == null ? 0.0 : (double)ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)threePrime)));
                hw.printEnclosed(Messages.getString("HTMLOutputFormat.MESSAGES"), HTMLWriter.H5);
                hw.printTag(HTMLWriter.UL);
                Iterator i = ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p).iterator();
                while (i.hasNext()) {
                    hw.printEnclosed(i.next().toString(), HTMLWriter.LI);
                }
                hw.printEndTag(HTMLWriter.UL);
                continue;
            }
            throw new IllegalArgumentException("Output sequence is not a Probe object");
        }
        hw.printEndTag(HTMLWriter.BODY);
        hw.printEndTag(HTMLWriter.HTML);
    }
}

